/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility.classfile;

import java.io.IOException;
import org.eclipse.persistence.tools.workbench.utility.classfile.Attribute;
import org.eclipse.persistence.tools.workbench.utility.classfile.AttributePool;
import org.eclipse.persistence.tools.workbench.utility.classfile.Visitor;
import org.eclipse.persistence.tools.workbench.utility.classfile.tools.ClassFileDataInputStream;
import org.eclipse.persistence.tools.workbench.utility.io.IndentingPrintWriter;

public class SourceDebugExtensionAttribute
extends Attribute {
    private byte[] debugExtension;

    public SourceDebugExtensionAttribute(ClassFileDataInputStream classFileDataInputStream, short s, AttributePool attributePool) throws IOException {
        super(classFileDataInputStream, s, attributePool);
    }

    void initializeInfo(ClassFileDataInputStream classFileDataInputStream) throws IOException {
        int n = this.getLength();
        this.debugExtension = new byte[n];
        classFileDataInputStream.read(this.debugExtension);
    }

    void displayInfoStringOn(IndentingPrintWriter indentingPrintWriter) {
        this.writeHexStringOn(this.debugExtension, indentingPrintWriter);
        indentingPrintWriter.println();
    }

    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    public byte[] getDebugExtension() {
        return this.debugExtension;
    }

    void toString(StringBuffer stringBuffer) {
        this.appendHexStringTo(this.debugExtension, stringBuffer);
    }
}

