/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility.classfile.descriptor;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import org.eclipse.persistence.tools.workbench.utility.classfile.Visitor;
import org.eclipse.persistence.tools.workbench.utility.classfile.descriptor.FieldType;

public class ObjectType
extends FieldType {
    private String internalTypeName;
    private String typeName;

    ObjectType(Reader reader) throws IOException {
        this(ObjectType.extractInternalNameFrom(reader));
    }

    ObjectType(String string) {
        this.internalTypeName = string;
        this.typeName = this.internalTypeName.replace('/', '.');
    }

    private static String extractInternalNameFrom(Reader reader) throws IOException {
        StringBuffer stringBuffer = new StringBuffer(256);
        int n = reader.read();
        while (n != 59) {
            stringBuffer.append((char)n);
            n = reader.read();
        }
        return stringBuffer.toString();
    }

    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    public int arrayDepth() {
        return 0;
    }

    public String elementTypeName() {
        return this.typeName;
    }

    public String javaName() {
        return this.typeName;
    }

    public Class javaClass() throws ClassNotFoundException {
        return Class.forName(this.typeName);
    }

    public void appendDeclarationTo(StringBuffer stringBuffer) {
        stringBuffer.append(this.typeName);
    }

    public void printDeclarationOn(PrintWriter printWriter) {
        printWriter.print(this.typeName);
    }

    public String internalName() {
        StringBuffer stringBuffer = new StringBuffer();
        this.appendInternalNameTo(stringBuffer);
        return stringBuffer.toString();
    }

    void appendArrayJavaNameTo(StringBuffer stringBuffer) {
        stringBuffer.append('L');
        stringBuffer.append(this.typeName);
        stringBuffer.append(';');
    }

    void appendArrayInternalNameTo(StringBuffer stringBuffer) {
        this.appendInternalNameTo(stringBuffer);
    }

    void appendInternalNameTo(StringBuffer stringBuffer) {
        stringBuffer.append('L');
        stringBuffer.append(this.internalTypeName);
        stringBuffer.append(';');
    }
}

