/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility.diff;

import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import org.eclipse.persistence.tools.workbench.utility.diff.Diff;
import org.eclipse.persistence.tools.workbench.utility.diff.Differentiator;
import org.eclipse.persistence.tools.workbench.utility.io.IndentingPrintWriter;

public class MapEntryDiff
implements Diff {
    private final Map.Entry entry1;
    private final Map.Entry entry2;
    private final Diff keyDiff;
    private final Diff valueDiff;
    private final Differentiator differentiator;

    public MapEntryDiff(Map.Entry entry, Map.Entry entry2, Diff diff, Diff diff2, Differentiator differentiator) {
        this.entry1 = entry;
        this.entry2 = entry2;
        this.keyDiff = diff;
        this.valueDiff = diff2;
        this.differentiator = differentiator;
    }

    public Object getObject1() {
        return this.entry1;
    }

    public Object getObject2() {
        return this.entry2;
    }

    public boolean identical() {
        return !this.different();
    }

    public boolean different() {
        return this.keyDiff.different() || this.valueDiff.different();
    }

    public Differentiator getDifferentiator() {
        return this.differentiator;
    }

    public String getDescription() {
        if (this.identical()) {
            return "";
        }
        StringWriter stringWriter = new StringWriter();
        IndentingPrintWriter indentingPrintWriter = new IndentingPrintWriter((Writer)stringWriter, "    ");
        this.appendHeader(indentingPrintWriter);
        indentingPrintWriter.indent();
        this.appendDescription(indentingPrintWriter);
        indentingPrintWriter.undent();
        return ((Object)stringWriter).toString();
    }

    protected void appendHeader(IndentingPrintWriter indentingPrintWriter) {
        indentingPrintWriter.print("Map Entries are different:");
        indentingPrintWriter.println();
        indentingPrintWriter.print("entry 1: ");
        indentingPrintWriter.print(this.entry1);
        indentingPrintWriter.println();
        indentingPrintWriter.print("entry 2: ");
        indentingPrintWriter.print(this.entry2);
        indentingPrintWriter.println();
    }

    public void appendDescription(IndentingPrintWriter indentingPrintWriter) {
        if (this.keyDiff.different()) {
            indentingPrintWriter.print("The entries' keys are different");
            indentingPrintWriter.println();
            indentingPrintWriter.indent();
            this.keyDiff.appendDescription(indentingPrintWriter);
            indentingPrintWriter.undent();
        }
        if (this.valueDiff.different()) {
            indentingPrintWriter.print("The entries' values are different");
            indentingPrintWriter.println();
            indentingPrintWriter.indent();
            this.valueDiff.appendDescription(indentingPrintWriter);
            indentingPrintWriter.undent();
        }
    }

    public Map.Entry getEntry1() {
        return this.entry1;
    }

    public Map.Entry getEntry2() {
        return this.entry2;
    }

    public Diff getKeyDiff() {
        return this.keyDiff;
    }

    public Diff getValueDiff() {
        return this.valueDiff;
    }

    public String toString() {
        return this.identical() ? "<no difference>" : this.getDescription();
    }
}

