/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility.events;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.persistence.tools.workbench.utility.IdentityHashBag;
import org.eclipse.persistence.tools.workbench.utility.events.ChangeNotifier;
import org.eclipse.persistence.tools.workbench.utility.events.CollectionChangeEvent;
import org.eclipse.persistence.tools.workbench.utility.events.CollectionChangeListener;
import org.eclipse.persistence.tools.workbench.utility.events.DefaultChangeNotifier;
import org.eclipse.persistence.tools.workbench.utility.events.ListChangeEvent;
import org.eclipse.persistence.tools.workbench.utility.events.ListChangeListener;
import org.eclipse.persistence.tools.workbench.utility.events.StateChangeEvent;
import org.eclipse.persistence.tools.workbench.utility.events.StateChangeListener;
import org.eclipse.persistence.tools.workbench.utility.events.TreeChangeEvent;
import org.eclipse.persistence.tools.workbench.utility.events.TreeChangeListener;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

public class ChangeSupport
implements Serializable {
    protected final Object source;
    private transient Map listeners;
    private Map children;
    private static final long serialVersionUID = 1L;

    public ChangeSupport(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        this.source = object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addListener(Class clazz, Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        ChangeSupport changeSupport = this;
        synchronized (changeSupport) {
            IdentityHashBag identityHashBag;
            if (this.listeners == null) {
                this.listeners = new IdentityHashMap();
            }
            if ((identityHashBag = (IdentityHashBag)this.listeners.get(clazz)) == null) {
                identityHashBag = new IdentityHashBag();
                this.listeners.put(clazz, identityHashBag);
            }
            identityHashBag.add(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addListener(String string, Class clazz, Object object) {
        if (string == null || object == null) {
            throw new NullPointerException();
        }
        ChangeSupport changeSupport = this;
        synchronized (changeSupport) {
            ChangeSupport changeSupport2;
            if (this.children == null) {
                this.children = new IdentityHashMap();
            }
            if ((changeSupport2 = (ChangeSupport)this.children.get(string)) == null) {
                changeSupport2 = this.buildChildChangeSupport();
                this.children.put(string, changeSupport2);
            }
            changeSupport2.addListener(clazz, object);
        }
    }

    protected ChangeSupport buildChildChangeSupport() {
        return new ChangeSupport(this.source);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeListener(Class clazz, Object object) {
        if (this.listeners == null) {
            throw new IllegalArgumentException("listener not registered");
        }
        ChangeSupport changeSupport = this;
        synchronized (changeSupport) {
            IdentityHashBag identityHashBag = (IdentityHashBag)this.listeners.get(clazz);
            if (identityHashBag == null) {
                throw new IllegalArgumentException("listener not registered");
            }
            if (!identityHashBag.remove(object)) {
                throw new IllegalArgumentException("listener not registered");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeListener(String string, Class clazz, Object object) {
        if (this.children == null) {
            throw new IllegalArgumentException("listener not registered");
        }
        ChangeSupport changeSupport = this;
        synchronized (changeSupport) {
            ChangeSupport changeSupport2 = (ChangeSupport)this.children.get(string);
            if (changeSupport2 == null) {
                throw new IllegalArgumentException("listener not registered");
            }
            changeSupport2.removeListener(clazz, object);
        }
    }

    protected ChangeNotifier notifier() {
        return DefaultChangeNotifier.instance();
    }

    protected synchronized boolean hasAnyListeners(Class clazz) {
        if (this.listeners == null) {
            return false;
        }
        IdentityHashBag identityHashBag = (IdentityHashBag)this.listeners.get(clazz);
        return identityHashBag != null && !identityHashBag.isEmpty();
    }

    protected synchronized boolean hasAnyListeners(Class clazz, String string) {
        if (this.hasAnyListeners(clazz)) {
            return true;
        }
        if (this.children == null) {
            return false;
        }
        ChangeSupport changeSupport = (ChangeSupport)this.children.get(string);
        return changeSupport != null && changeSupport.hasAnyListeners(clazz);
    }

    protected void sourceChanged(String string) {
    }

    public void addStateChangeListener(StateChangeListener stateChangeListener) {
        this.addListener(StateChangeListener.class, stateChangeListener);
    }

    public void removeStateChangeListener(StateChangeListener stateChangeListener) {
        this.removeListener(StateChangeListener.class, stateChangeListener);
    }

    public boolean hasAnyStateChangeListeners() {
        return this.hasAnyListeners(StateChangeListener.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireStateChanged(StateChangeEvent stateChangeEvent) {
        IdentityHashBag identityHashBag = null;
        IdentityHashBag identityHashBag2 = null;
        ChangeSupport changeSupport = this;
        synchronized (changeSupport) {
            if (this.listeners != null && (identityHashBag = (IdentityHashBag)this.listeners.get(StateChangeListener.class)) != null) {
                identityHashBag2 = (IdentityHashBag)identityHashBag.clone();
            }
        }
        if (identityHashBag2 != null) {
            for (StateChangeListener stateChangeListener : identityHashBag2) {
                boolean bl;
                ChangeSupport changeSupport2 = this;
                synchronized (changeSupport2) {
                    bl = identityHashBag.contains(stateChangeListener);
                }
                if (!bl) continue;
                this.notifier().stateChanged(stateChangeListener, stateChangeEvent);
            }
        }
        this.sourceChanged(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireStateChanged() {
        IdentityHashBag identityHashBag = null;
        IdentityHashBag identityHashBag2 = null;
        Serializable serializable = this;
        synchronized (serializable) {
            if (this.listeners != null && (identityHashBag = (IdentityHashBag)this.listeners.get(StateChangeListener.class)) != null) {
                identityHashBag2 = (IdentityHashBag)identityHashBag.clone();
            }
        }
        if (identityHashBag2 != null) {
            serializable = null;
            for (StateChangeListener stateChangeListener : identityHashBag2) {
                boolean bl;
                ChangeSupport changeSupport = this;
                synchronized (changeSupport) {
                    bl = identityHashBag.contains(stateChangeListener);
                }
                if (!bl) continue;
                if (serializable == null) {
                    serializable = new StateChangeEvent(this.source);
                }
                this.notifier().stateChanged(stateChangeListener, (StateChangeEvent)serializable);
            }
        }
        this.sourceChanged(null);
    }

    public boolean valuesAreEqual(Object object, Object object2) {
        if (object == null && object2 == null) {
            return true;
        }
        if (object == null || object2 == null) {
            return false;
        }
        return object.equals(object2);
    }

    public boolean valuesAreDifferent(Object object, Object object2) {
        return !this.valuesAreEqual(object, object2);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.addListener(PropertyChangeListener.class, propertyChangeListener);
    }

    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.addListener(string, PropertyChangeListener.class, propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.removeListener(PropertyChangeListener.class, propertyChangeListener);
    }

    public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.removeListener(string, PropertyChangeListener.class, propertyChangeListener);
    }

    public boolean hasAnyPropertyChangeListeners(String string) {
        return this.hasAnyListeners(PropertyChangeListener.class, string);
    }

    public boolean hasAnyPropertyChangeListeners() {
        return this.hasAnyListeners(PropertyChangeListener.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void firePropertyChanged(PropertyChangeEvent propertyChangeEvent) {
        if (this.valuesAreEqual(propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue())) {
            return;
        }
        String string = propertyChangeEvent.getPropertyName();
        IdentityHashBag identityHashBag = null;
        IdentityHashBag identityHashBag2 = null;
        ChangeSupport changeSupport = null;
        ChangeSupport changeSupport2 = this;
        synchronized (changeSupport2) {
            if (this.listeners != null && (identityHashBag = (IdentityHashBag)this.listeners.get(PropertyChangeListener.class)) != null) {
                identityHashBag2 = (IdentityHashBag)identityHashBag.clone();
            }
            if (string != null && this.children != null) {
                changeSupport = (ChangeSupport)this.children.get(string);
            }
        }
        if (identityHashBag2 != null) {
            for (PropertyChangeListener propertyChangeListener : identityHashBag2) {
                boolean bl;
                ChangeSupport changeSupport3 = this;
                synchronized (changeSupport3) {
                    bl = identityHashBag.contains(propertyChangeListener);
                }
                if (!bl) continue;
                this.notifier().propertyChange(propertyChangeListener, propertyChangeEvent);
            }
        }
        if (changeSupport != null) {
            changeSupport.firePropertyChanged(propertyChangeEvent);
        }
        this.sourceChanged(string);
    }

    public void firePropertyChanged(String string, Object object, Object object2) {
        if (this.valuesAreDifferent(object, object2)) {
            this.firePropertyChangedInternal(string, object, object2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void firePropertyChangedInternal(String string, Object object, Object object2) {
        IdentityHashBag identityHashBag = null;
        IdentityHashBag identityHashBag2 = null;
        ChangeSupport changeSupport = null;
        Serializable serializable = this;
        synchronized (serializable) {
            if (this.listeners != null && (identityHashBag = (IdentityHashBag)this.listeners.get(PropertyChangeListener.class)) != null) {
                identityHashBag2 = (IdentityHashBag)identityHashBag.clone();
            }
            if (string != null && this.children != null) {
                changeSupport = (ChangeSupport)this.children.get(string);
            }
        }
        serializable = null;
        if (identityHashBag2 != null) {
            for (PropertyChangeListener propertyChangeListener : identityHashBag2) {
                boolean bl;
                ChangeSupport changeSupport2 = this;
                synchronized (changeSupport2) {
                    bl = identityHashBag.contains(propertyChangeListener);
                }
                if (!bl) continue;
                if (serializable == null) {
                    serializable = new PropertyChangeEvent(this.source, string, object, object2);
                }
                this.notifier().propertyChange(propertyChangeListener, (PropertyChangeEvent)serializable);
            }
        }
        if (changeSupport != null) {
            if (serializable == null) {
                changeSupport.firePropertyChanged(string, object, object2);
            } else {
                changeSupport.firePropertyChanged((PropertyChangeEvent)serializable);
            }
        }
        this.sourceChanged(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void firePropertyChanged(String string, int n, int n2) {
        if (n == n2) {
            return;
        }
        IdentityHashBag identityHashBag = null;
        IdentityHashBag identityHashBag2 = null;
        ChangeSupport changeSupport = null;
        Serializable serializable = this;
        synchronized (serializable) {
            if (this.listeners != null && (identityHashBag = (IdentityHashBag)this.listeners.get(PropertyChangeListener.class)) != null) {
                identityHashBag2 = (IdentityHashBag)identityHashBag.clone();
            }
            if (string != null && this.children != null) {
                changeSupport = (ChangeSupport)this.children.get(string);
            }
        }
        serializable = null;
        if (identityHashBag2 != null) {
            for (PropertyChangeListener propertyChangeListener : identityHashBag2) {
                boolean bl;
                ChangeSupport changeSupport2 = this;
                synchronized (changeSupport2) {
                    bl = identityHashBag.contains(propertyChangeListener);
                }
                if (!bl) continue;
                if (serializable == null) {
                    serializable = new PropertyChangeEvent(this.source, string, new Integer(n), new Integer(n2));
                }
                this.notifier().propertyChange(propertyChangeListener, (PropertyChangeEvent)serializable);
            }
        }
        if (changeSupport != null) {
            if (serializable == null) {
                changeSupport.firePropertyChanged(string, n, n2);
            } else {
                changeSupport.firePropertyChanged((PropertyChangeEvent)serializable);
            }
        }
        this.sourceChanged(string);
    }

    public void firePropertyChanged(String string, boolean bl, boolean bl2) {
        if (bl != bl2) {
            this.firePropertyChangedInternal(string, bl, bl2);
        }
    }

    public void addCollectionChangeListener(CollectionChangeListener collectionChangeListener) {
        this.addListener(CollectionChangeListener.class, collectionChangeListener);
    }

    public void addCollectionChangeListener(String string, CollectionChangeListener collectionChangeListener) {
        this.addListener(string, CollectionChangeListener.class, collectionChangeListener);
    }

    public void removeCollectionChangeListener(CollectionChangeListener collectionChangeListener) {
        this.removeListener(CollectionChangeListener.class, collectionChangeListener);
    }

    public void removeCollectionChangeListener(String string, CollectionChangeListener collectionChangeListener) {
        this.removeListener(string, CollectionChangeListener.class, collectionChangeListener);
    }

    public boolean hasAnyCollectionChangeListeners(String string) {
        return this.hasAnyListeners(CollectionChangeListener.class, string);
    }

    public boolean hasAnyCollectionChangeListeners() {
        return this.hasAnyListeners(CollectionChangeListener.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireItemsAdded(CollectionChangeEvent collectionChangeEvent) {
        if (collectionChangeEvent.size() == 0) {
            return;
        }
        String string = collectionChangeEvent.getCollectionName();
        IdentityHashBag identityHashBag = null;
        IdentityHashBag identityHashBag2 = null;
        ChangeSupport changeSupport = null;
        ChangeSupport changeSupport2 = this;
        synchronized (changeSupport2) {
            if (this.listeners != null && (identityHashBag = (IdentityHashBag)this.listeners.get(CollectionChangeListener.class)) != null) {
                identityHashBag2 = (IdentityHashBag)identityHashBag.clone();
            }
            if (string != null && this.children != null) {
                changeSupport = (ChangeSupport)this.children.get(string);
            }
        }
        if (identityHashBag2 != null) {
            for (CollectionChangeListener collectionChangeListener : identityHashBag2) {
                boolean bl;
                ChangeSupport changeSupport3 = this;
                synchronized (changeSupport3) {
                    bl = identityHashBag.contains(collectionChangeListener);
                }
                if (!bl) continue;
                this.notifier().itemsAdded(collectionChangeListener, collectionChangeEvent);
            }
        }
        if (changeSupport != null) {
            changeSupport.fireItemsAdded(collectionChangeEvent);
        }
        this.sourceChanged(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireItemsAdded(String string, Collection collection) {
        if (collection.size() == 0) {
            return;
        }
        IdentityHashBag identityHashBag = null;
        IdentityHashBag identityHashBag2 = null;
        ChangeSupport changeSupport = null;
        Serializable serializable = this;
        synchronized (serializable) {
            if (this.listeners != null && (identityHashBag = (IdentityHashBag)this.listeners.get(CollectionChangeListener.class)) != null) {
                identityHashBag2 = (IdentityHashBag)identityHashBag.clone();
            }
            if (string != null && this.children != null) {
                changeSupport = (ChangeSupport)this.children.get(string);
            }
        }
        serializable = null;
        if (identityHashBag2 != null) {
            for (CollectionChangeListener collectionChangeListener : identityHashBag2) {
                boolean bl;
                ChangeSupport changeSupport2 = this;
                synchronized (changeSupport2) {
                    bl = identityHashBag.contains(collectionChangeListener);
                }
                if (!bl) continue;
                if (serializable == null) {
                    serializable = new CollectionChangeEvent(this.source, string, collection);
                }
                this.notifier().itemsAdded(collectionChangeListener, (CollectionChangeEvent)serializable);
            }
        }
        if (changeSupport != null) {
            if (serializable == null) {
                changeSupport.fireItemsAdded(string, collection);
            } else {
                changeSupport.fireItemsAdded((CollectionChangeEvent)serializable);
            }
        }
        this.sourceChanged(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireItemAdded(String string, Object object) {
        IdentityHashBag identityHashBag = null;
        IdentityHashBag identityHashBag2 = null;
        ChangeSupport changeSupport = null;
        Serializable serializable = this;
        synchronized (serializable) {
            if (this.listeners != null && (identityHashBag = (IdentityHashBag)this.listeners.get(CollectionChangeListener.class)) != null) {
                identityHashBag2 = (IdentityHashBag)identityHashBag.clone();
            }
            if (string != null && this.children != null) {
                changeSupport = (ChangeSupport)this.children.get(string);
            }
        }
        serializable = null;
        if (identityHashBag2 != null) {
            for (CollectionChangeListener collectionChangeListener : identityHashBag2) {
                boolean bl;
                ChangeSupport changeSupport2 = this;
                synchronized (changeSupport2) {
                    bl = identityHashBag.contains(collectionChangeListener);
                }
                if (!bl) continue;
                if (serializable == null) {
                    serializable = new CollectionChangeEvent(this.source, string, Collections.singleton(object));
                }
                this.notifier().itemsAdded(collectionChangeListener, (CollectionChangeEvent)serializable);
            }
        }
        if (changeSupport != null) {
            if (serializable == null) {
                changeSupport.fireItemAdded(string, object);
            } else {
                changeSupport.fireItemsAdded((CollectionChangeEvent)serializable);
            }
        }
        this.sourceChanged(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireItemsRemoved(CollectionChangeEvent collectionChangeEvent) {
        if (collectionChangeEvent.size() == 0) {
            return;
        }
        String string = collectionChangeEvent.getCollectionName();
        IdentityHashBag identityHashBag = null;
        IdentityHashBag identityHashBag2 = null;
        ChangeSupport changeSupport = null;
        ChangeSupport changeSupport2 = this;
        synchronized (changeSupport2) {
            if (this.listeners != null && (identityHashBag = (IdentityHashBag)this.listeners.get(CollectionChangeListener.class)) != null) {
                identityHashBag2 = (IdentityHashBag)identityHashBag.clone();
            }
            if (string != null && this.children != null) {
                changeSupport = (ChangeSupport)this.children.get(string);
            }
        }
        if (identityHashBag2 != null) {
            for (CollectionChangeListener collectionChangeListener : identityHashBag2) {
                boolean bl;
                ChangeSupport changeSupport3 = this;
                synchronized (changeSupport3) {
                    bl = identityHashBag.contains(collectionChangeListener);
                }
                if (!bl) continue;
                this.notifier().itemsRemoved(collectionChangeListener, collectionChangeEvent);
            }
        }
        if (changeSupport != null) {
            changeSupport.fireItemsRemoved(collectionChangeEvent);
        }
        this.sourceChanged(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireItemsRemoved(String string, Collection collection) {
        if (collection.size() == 0) {
            return;
        }
        IdentityHashBag identityHashBag = null;
        IdentityHashBag identityHashBag2 = null;
        ChangeSupport changeSupport = null;
        Serializable serializable = this;
        synchronized (serializable) {
            if (this.listeners != null && (identityHashBag = (IdentityHashBag)this.listeners.get(CollectionChangeListener.class)) != null) {
                identityHashBag2 = (IdentityHashBag)identityHashBag.clone();
            }
            if (string != null && this.children != null) {
                changeSupport = (ChangeSupport)this.children.get(string);
            }
        }
        serializable = null;
        if (identityHashBag2 != null) {
            for (CollectionChangeListener collectionChangeListener : identityHashBag2) {
                boolean bl;
                ChangeSupport changeSupport2 = this;
                synchronized (changeSupport2) {
                    bl = identityHashBag.contains(collectionChangeListener);
                }
                if (!bl) continue;
                if (serializable == null) {
                    serializable = new CollectionChangeEvent(this.source, string, collection);
                }
                this.notifier().itemsRemoved(collectionChangeListener, (CollectionChangeEvent)serializable);
            }
        }
        if (changeSupport != null) {
            if (serializable == null) {
                changeSupport.fireItemsRemoved(string, collection);
            } else {
                changeSupport.fireItemsRemoved((CollectionChangeEvent)serializable);
            }
        }
        this.sourceChanged(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireItemRemoved(String string, Object object) {
        IdentityHashBag identityHashBag = null;
        IdentityHashBag identityHashBag2 = null;
        ChangeSupport changeSupport = null;
        Serializable serializable = this;
        synchronized (serializable) {
            if (this.listeners != null && (identityHashBag = (IdentityHashBag)this.listeners.get(CollectionChangeListener.class)) != null) {
                identityHashBag2 = (IdentityHashBag)identityHashBag.clone();
            }
            if (string != null && this.children != null) {
                changeSupport = (ChangeSupport)this.children.get(string);
            }
        }
        serializable = null;
        if (identityHashBag2 != null) {
            for (CollectionChangeListener collectionChangeListener : identityHashBag2) {
                boolean bl;
                ChangeSupport changeSupport2 = this;
                synchronized (changeSupport2) {
                    bl = identityHashBag.contains(collectionChangeListener);
                }
                if (!bl) continue;
                if (serializable == null) {
                    serializable = new CollectionChangeEvent(this.source, string, Collections.singleton(object));
                }
                this.notifier().itemsRemoved(collectionChangeListener, (CollectionChangeEvent)serializable);
            }
        }
        if (changeSupport != null) {
            if (serializable == null) {
                changeSupport.fireItemRemoved(string, object);
            } else {
                changeSupport.fireItemsRemoved((CollectionChangeEvent)serializable);
            }
        }
        this.sourceChanged(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireCollectionChanged(CollectionChangeEvent collectionChangeEvent) {
        String string = collectionChangeEvent.getCollectionName();
        IdentityHashBag identityHashBag = null;
        IdentityHashBag identityHashBag2 = null;
        ChangeSupport changeSupport = null;
        ChangeSupport changeSupport2 = this;
        synchronized (changeSupport2) {
            if (this.listeners != null && (identityHashBag = (IdentityHashBag)this.listeners.get(CollectionChangeListener.class)) != null) {
                identityHashBag2 = (IdentityHashBag)identityHashBag.clone();
            }
            if (string != null && this.children != null) {
                changeSupport = (ChangeSupport)this.children.get(string);
            }
        }
        if (identityHashBag2 != null) {
            for (CollectionChangeListener collectionChangeListener : identityHashBag2) {
                boolean bl;
                ChangeSupport changeSupport3 = this;
                synchronized (changeSupport3) {
                    bl = identityHashBag.contains(collectionChangeListener);
                }
                if (!bl) continue;
                this.notifier().collectionChanged(collectionChangeListener, collectionChangeEvent);
            }
        }
        if (changeSupport != null) {
            changeSupport.fireCollectionChanged(collectionChangeEvent);
        }
        this.sourceChanged(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireCollectionChanged(String string) {
        IdentityHashBag identityHashBag = null;
        IdentityHashBag identityHashBag2 = null;
        ChangeSupport changeSupport = null;
        Serializable serializable = this;
        synchronized (serializable) {
            if (this.listeners != null && (identityHashBag = (IdentityHashBag)this.listeners.get(CollectionChangeListener.class)) != null) {
                identityHashBag2 = (IdentityHashBag)identityHashBag.clone();
            }
            if (string != null && this.children != null) {
                changeSupport = (ChangeSupport)this.children.get(string);
            }
        }
        serializable = null;
        if (identityHashBag2 != null) {
            for (CollectionChangeListener collectionChangeListener : identityHashBag2) {
                boolean bl;
                ChangeSupport changeSupport2 = this;
                synchronized (changeSupport2) {
                    bl = identityHashBag.contains(collectionChangeListener);
                }
                if (!bl) continue;
                if (serializable == null) {
                    serializable = new CollectionChangeEvent(this.source, string);
                }
                this.notifier().collectionChanged(collectionChangeListener, (CollectionChangeEvent)serializable);
            }
        }
        if (changeSupport != null) {
            if (serializable == null) {
                changeSupport.fireCollectionChanged(string);
            } else {
                changeSupport.fireCollectionChanged((CollectionChangeEvent)serializable);
            }
        }
        this.sourceChanged(string);
    }

    public void addListChangeListener(ListChangeListener listChangeListener) {
        this.addListener(ListChangeListener.class, listChangeListener);
    }

    public void addListChangeListener(String string, ListChangeListener listChangeListener) {
        this.addListener(string, ListChangeListener.class, listChangeListener);
    }

    public void removeListChangeListener(ListChangeListener listChangeListener) {
        this.removeListener(ListChangeListener.class, listChangeListener);
    }

    public void removeListChangeListener(String string, ListChangeListener listChangeListener) {
        this.removeListener(string, ListChangeListener.class, listChangeListener);
    }

    public boolean hasAnyListChangeListeners(String string) {
        return this.hasAnyListeners(ListChangeListener.class, string);
    }

    public boolean hasAnyListChangeListeners() {
        return this.hasAnyListeners(ListChangeListener.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireItemsAdded(ListChangeEvent listChangeEvent) {
        if (listChangeEvent.size() == 0) {
            return;
        }
        String string = listChangeEvent.getListName();
        IdentityHashBag identityHashBag = null;
        IdentityHashBag identityHashBag2 = null;
        ChangeSupport changeSupport = null;
        ChangeSupport changeSupport2 = this;
        synchronized (changeSupport2) {
            if (this.listeners != null && (identityHashBag = (IdentityHashBag)this.listeners.get(ListChangeListener.class)) != null) {
                identityHashBag2 = (IdentityHashBag)identityHashBag.clone();
            }
            if (string != null && this.children != null) {
                changeSupport = (ChangeSupport)this.children.get(string);
            }
        }
        if (identityHashBag2 != null) {
            for (ListChangeListener listChangeListener : identityHashBag2) {
                boolean bl;
                ChangeSupport changeSupport3 = this;
                synchronized (changeSupport3) {
                    bl = identityHashBag.contains(listChangeListener);
                }
                if (!bl) continue;
                this.notifier().itemsAdded(listChangeListener, listChangeEvent);
            }
        }
        if (changeSupport != null) {
            changeSupport.fireItemsAdded(listChangeEvent);
        }
        this.sourceChanged(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireItemsAdded(String string, int n, List list) {
        if (list.size() == 0) {
            return;
        }
        IdentityHashBag identityHashBag = null;
        IdentityHashBag identityHashBag2 = null;
        ChangeSupport changeSupport = null;
        Serializable serializable = this;
        synchronized (serializable) {
            if (this.listeners != null && (identityHashBag = (IdentityHashBag)this.listeners.get(ListChangeListener.class)) != null) {
                identityHashBag2 = (IdentityHashBag)identityHashBag.clone();
            }
            if (string != null && this.children != null) {
                changeSupport = (ChangeSupport)this.children.get(string);
            }
        }
        serializable = null;
        if (identityHashBag2 != null) {
            for (ListChangeListener listChangeListener : identityHashBag2) {
                boolean bl;
                ChangeSupport changeSupport2 = this;
                synchronized (changeSupport2) {
                    bl = identityHashBag.contains(listChangeListener);
                }
                if (!bl) continue;
                if (serializable == null) {
                    serializable = new ListChangeEvent(this.source, string, n, list);
                }
                this.notifier().itemsAdded(listChangeListener, (ListChangeEvent)serializable);
            }
        }
        if (changeSupport != null) {
            if (serializable == null) {
                changeSupport.fireItemsAdded(string, n, list);
            } else {
                changeSupport.fireItemsAdded((ListChangeEvent)serializable);
            }
        }
        this.sourceChanged(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireItemAdded(String string, int n, Object object) {
        IdentityHashBag identityHashBag = null;
        IdentityHashBag identityHashBag2 = null;
        ChangeSupport changeSupport = null;
        Serializable serializable = this;
        synchronized (serializable) {
            if (this.listeners != null && (identityHashBag = (IdentityHashBag)this.listeners.get(ListChangeListener.class)) != null) {
                identityHashBag2 = (IdentityHashBag)identityHashBag.clone();
            }
            if (string != null && this.children != null) {
                changeSupport = (ChangeSupport)this.children.get(string);
            }
        }
        serializable = null;
        if (identityHashBag2 != null) {
            for (ListChangeListener listChangeListener : identityHashBag2) {
                boolean bl;
                ChangeSupport changeSupport2 = this;
                synchronized (changeSupport2) {
                    bl = identityHashBag.contains(listChangeListener);
                }
                if (!bl) continue;
                if (serializable == null) {
                    serializable = new ListChangeEvent(this.source, string, n, Collections.singletonList(object));
                }
                this.notifier().itemsAdded(listChangeListener, (ListChangeEvent)serializable);
            }
        }
        if (changeSupport != null) {
            if (serializable == null) {
                changeSupport.fireItemAdded(string, n, object);
            } else {
                changeSupport.fireItemsAdded((ListChangeEvent)serializable);
            }
        }
        this.sourceChanged(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireItemsRemoved(ListChangeEvent listChangeEvent) {
        if (listChangeEvent.size() == 0) {
            return;
        }
        String string = listChangeEvent.getListName();
        IdentityHashBag identityHashBag = null;
        IdentityHashBag identityHashBag2 = null;
        ChangeSupport changeSupport = null;
        ChangeSupport changeSupport2 = this;
        synchronized (changeSupport2) {
            if (this.listeners != null && (identityHashBag = (IdentityHashBag)this.listeners.get(ListChangeListener.class)) != null) {
                identityHashBag2 = (IdentityHashBag)identityHashBag.clone();
            }
            if (string != null && this.children != null) {
                changeSupport = (ChangeSupport)this.children.get(string);
            }
        }
        if (identityHashBag2 != null) {
            for (ListChangeListener listChangeListener : identityHashBag2) {
                boolean bl;
                ChangeSupport changeSupport3 = this;
                synchronized (changeSupport3) {
                    bl = identityHashBag.contains(listChangeListener);
                }
                if (!bl) continue;
                this.notifier().itemsRemoved(listChangeListener, listChangeEvent);
            }
        }
        if (changeSupport != null) {
            changeSupport.fireItemsRemoved(listChangeEvent);
        }
        this.sourceChanged(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireItemsRemoved(String string, int n, List list) {
        if (list.size() == 0) {
            return;
        }
        IdentityHashBag identityHashBag = null;
        IdentityHashBag identityHashBag2 = null;
        ChangeSupport changeSupport = null;
        Serializable serializable = this;
        synchronized (serializable) {
            if (this.listeners != null && (identityHashBag = (IdentityHashBag)this.listeners.get(ListChangeListener.class)) != null) {
                identityHashBag2 = (IdentityHashBag)identityHashBag.clone();
            }
            if (string != null && this.children != null) {
                changeSupport = (ChangeSupport)this.children.get(string);
            }
        }
        serializable = null;
        if (identityHashBag2 != null) {
            for (ListChangeListener listChangeListener : identityHashBag2) {
                boolean bl;
                ChangeSupport changeSupport2 = this;
                synchronized (changeSupport2) {
                    bl = identityHashBag.contains(listChangeListener);
                }
                if (!bl) continue;
                if (serializable == null) {
                    serializable = new ListChangeEvent(this.source, string, n, list);
                }
                this.notifier().itemsRemoved(listChangeListener, (ListChangeEvent)serializable);
            }
        }
        if (changeSupport != null) {
            if (serializable == null) {
                changeSupport.fireItemsRemoved(string, n, list);
            } else {
                changeSupport.fireItemsRemoved((ListChangeEvent)serializable);
            }
        }
        this.sourceChanged(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireItemRemoved(String string, int n, Object object) {
        IdentityHashBag identityHashBag = null;
        IdentityHashBag identityHashBag2 = null;
        ChangeSupport changeSupport = null;
        Serializable serializable = this;
        synchronized (serializable) {
            if (this.listeners != null && (identityHashBag = (IdentityHashBag)this.listeners.get(ListChangeListener.class)) != null) {
                identityHashBag2 = (IdentityHashBag)identityHashBag.clone();
            }
            if (string != null && this.children != null) {
                changeSupport = (ChangeSupport)this.children.get(string);
            }
        }
        serializable = null;
        if (identityHashBag2 != null) {
            for (ListChangeListener listChangeListener : identityHashBag2) {
                boolean bl;
                ChangeSupport changeSupport2 = this;
                synchronized (changeSupport2) {
                    bl = identityHashBag.contains(listChangeListener);
                }
                if (!bl) continue;
                if (serializable == null) {
                    serializable = new ListChangeEvent(this.source, string, n, Collections.singletonList(object));
                }
                this.notifier().itemsRemoved(listChangeListener, (ListChangeEvent)serializable);
            }
        }
        if (changeSupport != null) {
            if (serializable == null) {
                changeSupport.fireItemRemoved(string, n, object);
            } else {
                changeSupport.fireItemsRemoved((ListChangeEvent)serializable);
            }
        }
        this.sourceChanged(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireItemsReplaced(ListChangeEvent listChangeEvent) {
        if (listChangeEvent.size() == 0) {
            return;
        }
        String string = listChangeEvent.getListName();
        IdentityHashBag identityHashBag = null;
        IdentityHashBag identityHashBag2 = null;
        ChangeSupport changeSupport = null;
        ChangeSupport changeSupport2 = this;
        synchronized (changeSupport2) {
            if (this.listeners != null && (identityHashBag = (IdentityHashBag)this.listeners.get(ListChangeListener.class)) != null) {
                identityHashBag2 = (IdentityHashBag)identityHashBag.clone();
            }
            if (string != null && this.children != null) {
                changeSupport = (ChangeSupport)this.children.get(string);
            }
        }
        if (identityHashBag2 != null) {
            for (ListChangeListener listChangeListener : identityHashBag2) {
                boolean bl;
                ChangeSupport changeSupport3 = this;
                synchronized (changeSupport3) {
                    bl = identityHashBag.contains(listChangeListener);
                }
                if (!bl) continue;
                this.notifier().itemsReplaced(listChangeListener, listChangeEvent);
            }
        }
        if (changeSupport != null) {
            changeSupport.fireItemsReplaced(listChangeEvent);
        }
        this.sourceChanged(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireItemsReplaced(String string, int n, List list, List list2) {
        if (list.size() == 0) {
            return;
        }
        IdentityHashBag identityHashBag = null;
        IdentityHashBag identityHashBag2 = null;
        ChangeSupport changeSupport = null;
        Serializable serializable = this;
        synchronized (serializable) {
            if (this.listeners != null && (identityHashBag = (IdentityHashBag)this.listeners.get(ListChangeListener.class)) != null) {
                identityHashBag2 = (IdentityHashBag)identityHashBag.clone();
            }
            if (string != null && this.children != null) {
                changeSupport = (ChangeSupport)this.children.get(string);
            }
        }
        serializable = null;
        if (identityHashBag2 != null) {
            for (ListChangeListener listChangeListener : identityHashBag2) {
                boolean bl;
                ChangeSupport changeSupport2 = this;
                synchronized (changeSupport2) {
                    bl = identityHashBag.contains(listChangeListener);
                }
                if (!bl) continue;
                if (serializable == null) {
                    serializable = new ListChangeEvent(this.source, string, n, list, list2);
                }
                this.notifier().itemsReplaced(listChangeListener, (ListChangeEvent)serializable);
            }
        }
        if (changeSupport != null) {
            if (serializable == null) {
                changeSupport.fireItemsReplaced(string, n, list, list2);
            } else {
                changeSupport.fireItemsReplaced((ListChangeEvent)serializable);
            }
        }
        this.sourceChanged(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireItemReplaced(String string, int n, Object object, Object object2) {
        IdentityHashBag identityHashBag = null;
        IdentityHashBag identityHashBag2 = null;
        ChangeSupport changeSupport = null;
        Serializable serializable = this;
        synchronized (serializable) {
            if (this.listeners != null && (identityHashBag = (IdentityHashBag)this.listeners.get(ListChangeListener.class)) != null) {
                identityHashBag2 = (IdentityHashBag)identityHashBag.clone();
            }
            if (string != null && this.children != null) {
                changeSupport = (ChangeSupport)this.children.get(string);
            }
        }
        serializable = null;
        if (identityHashBag2 != null) {
            for (ListChangeListener listChangeListener : identityHashBag2) {
                boolean bl;
                ChangeSupport changeSupport2 = this;
                synchronized (changeSupport2) {
                    bl = identityHashBag.contains(listChangeListener);
                }
                if (!bl) continue;
                if (serializable == null) {
                    serializable = new ListChangeEvent(this.source, string, n, Collections.singletonList(object), Collections.singletonList(object2));
                }
                this.notifier().itemsReplaced(listChangeListener, (ListChangeEvent)serializable);
            }
        }
        if (changeSupport != null) {
            if (serializable == null) {
                changeSupport.fireItemReplaced(string, n, object, object2);
            } else {
                changeSupport.fireItemsReplaced((ListChangeEvent)serializable);
            }
        }
        this.sourceChanged(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireListChanged(ListChangeEvent listChangeEvent) {
        String string = listChangeEvent.getListName();
        IdentityHashBag identityHashBag = null;
        IdentityHashBag identityHashBag2 = null;
        ChangeSupport changeSupport = null;
        ChangeSupport changeSupport2 = this;
        synchronized (changeSupport2) {
            if (this.listeners != null && (identityHashBag = (IdentityHashBag)this.listeners.get(ListChangeListener.class)) != null) {
                identityHashBag2 = (IdentityHashBag)identityHashBag.clone();
            }
            if (string != null && this.children != null) {
                changeSupport = (ChangeSupport)this.children.get(string);
            }
        }
        if (identityHashBag2 != null) {
            for (ListChangeListener listChangeListener : identityHashBag2) {
                boolean bl;
                ChangeSupport changeSupport3 = this;
                synchronized (changeSupport3) {
                    bl = identityHashBag.contains(listChangeListener);
                }
                if (!bl) continue;
                this.notifier().listChanged(listChangeListener, listChangeEvent);
            }
        }
        if (changeSupport != null) {
            changeSupport.fireListChanged(listChangeEvent);
        }
        this.sourceChanged(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireListChanged(String string) {
        IdentityHashBag identityHashBag = null;
        IdentityHashBag identityHashBag2 = null;
        ChangeSupport changeSupport = null;
        Serializable serializable = this;
        synchronized (serializable) {
            if (this.listeners != null && (identityHashBag = (IdentityHashBag)this.listeners.get(ListChangeListener.class)) != null) {
                identityHashBag2 = (IdentityHashBag)identityHashBag.clone();
            }
            if (string != null && this.children != null) {
                changeSupport = (ChangeSupport)this.children.get(string);
            }
        }
        serializable = null;
        if (identityHashBag2 != null) {
            for (ListChangeListener listChangeListener : identityHashBag2) {
                boolean bl;
                ChangeSupport changeSupport2 = this;
                synchronized (changeSupport2) {
                    bl = identityHashBag.contains(listChangeListener);
                }
                if (!bl) continue;
                if (serializable == null) {
                    serializable = new ListChangeEvent(this.source, string);
                }
                this.notifier().listChanged(listChangeListener, (ListChangeEvent)serializable);
            }
        }
        if (changeSupport != null) {
            if (serializable == null) {
                changeSupport.fireListChanged(string);
            } else {
                changeSupport.fireListChanged((ListChangeEvent)serializable);
            }
        }
        this.sourceChanged(string);
    }

    public void addTreeChangeListener(TreeChangeListener treeChangeListener) {
        this.addListener(TreeChangeListener.class, treeChangeListener);
    }

    public void addTreeChangeListener(String string, TreeChangeListener treeChangeListener) {
        this.addListener(string, TreeChangeListener.class, treeChangeListener);
    }

    public void removeTreeChangeListener(TreeChangeListener treeChangeListener) {
        this.removeListener(TreeChangeListener.class, treeChangeListener);
    }

    public void removeTreeChangeListener(String string, TreeChangeListener treeChangeListener) {
        this.removeListener(string, TreeChangeListener.class, treeChangeListener);
    }

    public boolean hasAnyTreeChangeListeners(String string) {
        return this.hasAnyListeners(TreeChangeListener.class, string);
    }

    public boolean hasAnyTreeChangeListeners() {
        return this.hasAnyListeners(TreeChangeListener.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireNodeAdded(TreeChangeEvent treeChangeEvent) {
        String string = treeChangeEvent.getTreeName();
        IdentityHashBag identityHashBag = null;
        IdentityHashBag identityHashBag2 = null;
        ChangeSupport changeSupport = null;
        ChangeSupport changeSupport2 = this;
        synchronized (changeSupport2) {
            if (this.listeners != null && (identityHashBag = (IdentityHashBag)this.listeners.get(TreeChangeListener.class)) != null) {
                identityHashBag2 = (IdentityHashBag)identityHashBag.clone();
            }
            if (string != null && this.children != null) {
                changeSupport = (ChangeSupport)this.children.get(string);
            }
        }
        if (identityHashBag2 != null) {
            for (TreeChangeListener treeChangeListener : identityHashBag2) {
                boolean bl;
                ChangeSupport changeSupport3 = this;
                synchronized (changeSupport3) {
                    bl = identityHashBag.contains(treeChangeListener);
                }
                if (!bl) continue;
                this.notifier().nodeAdded(treeChangeListener, treeChangeEvent);
            }
        }
        if (changeSupport != null) {
            changeSupport.fireNodeAdded(treeChangeEvent);
        }
        this.sourceChanged(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireNodeAdded(String string, Object[] objectArray) {
        IdentityHashBag identityHashBag = null;
        IdentityHashBag identityHashBag2 = null;
        ChangeSupport changeSupport = null;
        Serializable serializable = this;
        synchronized (serializable) {
            if (this.listeners != null && (identityHashBag = (IdentityHashBag)this.listeners.get(TreeChangeListener.class)) != null) {
                identityHashBag2 = (IdentityHashBag)identityHashBag.clone();
            }
            if (string != null && this.children != null) {
                changeSupport = (ChangeSupport)this.children.get(string);
            }
        }
        serializable = null;
        if (identityHashBag2 != null) {
            for (TreeChangeListener treeChangeListener : identityHashBag2) {
                boolean bl;
                ChangeSupport changeSupport2 = this;
                synchronized (changeSupport2) {
                    bl = identityHashBag.contains(treeChangeListener);
                }
                if (!bl) continue;
                if (serializable == null) {
                    serializable = new TreeChangeEvent(this.source, string, objectArray);
                }
                this.notifier().nodeAdded(treeChangeListener, (TreeChangeEvent)serializable);
            }
        }
        if (changeSupport != null) {
            if (serializable == null) {
                changeSupport.fireNodeAdded(string, objectArray);
            } else {
                changeSupport.fireNodeAdded((TreeChangeEvent)serializable);
            }
        }
        this.sourceChanged(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireNodeRemoved(TreeChangeEvent treeChangeEvent) {
        String string = treeChangeEvent.getTreeName();
        IdentityHashBag identityHashBag = null;
        IdentityHashBag identityHashBag2 = null;
        ChangeSupport changeSupport = null;
        ChangeSupport changeSupport2 = this;
        synchronized (changeSupport2) {
            if (this.listeners != null && (identityHashBag = (IdentityHashBag)this.listeners.get(TreeChangeListener.class)) != null) {
                identityHashBag2 = (IdentityHashBag)identityHashBag.clone();
            }
            if (string != null && this.children != null) {
                changeSupport = (ChangeSupport)this.children.get(string);
            }
        }
        if (identityHashBag2 != null) {
            for (TreeChangeListener treeChangeListener : identityHashBag2) {
                boolean bl;
                ChangeSupport changeSupport3 = this;
                synchronized (changeSupport3) {
                    bl = identityHashBag.contains(treeChangeListener);
                }
                if (!bl) continue;
                this.notifier().nodeRemoved(treeChangeListener, treeChangeEvent);
            }
        }
        if (changeSupport != null) {
            changeSupport.fireNodeRemoved(treeChangeEvent);
        }
        this.sourceChanged(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireNodeRemoved(String string, Object[] objectArray) {
        IdentityHashBag identityHashBag = null;
        IdentityHashBag identityHashBag2 = null;
        ChangeSupport changeSupport = null;
        Serializable serializable = this;
        synchronized (serializable) {
            if (this.listeners != null && (identityHashBag = (IdentityHashBag)this.listeners.get(TreeChangeListener.class)) != null) {
                identityHashBag2 = (IdentityHashBag)identityHashBag.clone();
            }
            if (string != null && this.children != null) {
                changeSupport = (ChangeSupport)this.children.get(string);
            }
        }
        serializable = null;
        if (identityHashBag2 != null) {
            for (TreeChangeListener treeChangeListener : identityHashBag2) {
                boolean bl;
                ChangeSupport changeSupport2 = this;
                synchronized (changeSupport2) {
                    bl = identityHashBag.contains(treeChangeListener);
                }
                if (!bl) continue;
                if (serializable == null) {
                    serializable = new TreeChangeEvent(this.source, string, objectArray);
                }
                this.notifier().nodeRemoved(treeChangeListener, (TreeChangeEvent)serializable);
            }
        }
        if (changeSupport != null) {
            if (serializable == null) {
                changeSupport.fireNodeRemoved(string, objectArray);
            } else {
                changeSupport.fireNodeRemoved((TreeChangeEvent)serializable);
            }
        }
        this.sourceChanged(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireTreeChanged(TreeChangeEvent treeChangeEvent) {
        String string = treeChangeEvent.getTreeName();
        IdentityHashBag identityHashBag = null;
        IdentityHashBag identityHashBag2 = null;
        ChangeSupport changeSupport = null;
        ChangeSupport changeSupport2 = this;
        synchronized (changeSupport2) {
            if (this.listeners != null && (identityHashBag = (IdentityHashBag)this.listeners.get(TreeChangeListener.class)) != null) {
                identityHashBag2 = (IdentityHashBag)identityHashBag.clone();
            }
            if (string != null && this.children != null) {
                changeSupport = (ChangeSupport)this.children.get(string);
            }
        }
        if (identityHashBag2 != null) {
            for (TreeChangeListener treeChangeListener : identityHashBag2) {
                boolean bl;
                ChangeSupport changeSupport3 = this;
                synchronized (changeSupport3) {
                    bl = identityHashBag.contains(treeChangeListener);
                }
                if (!bl) continue;
                this.notifier().treeChanged(treeChangeListener, treeChangeEvent);
            }
        }
        if (changeSupport != null) {
            changeSupport.fireTreeChanged(treeChangeEvent);
        }
        this.sourceChanged(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireTreeChanged(String string, Object[] objectArray) {
        IdentityHashBag identityHashBag = null;
        IdentityHashBag identityHashBag2 = null;
        ChangeSupport changeSupport = null;
        Serializable serializable = this;
        synchronized (serializable) {
            if (this.listeners != null && (identityHashBag = (IdentityHashBag)this.listeners.get(TreeChangeListener.class)) != null) {
                identityHashBag2 = (IdentityHashBag)identityHashBag.clone();
            }
            if (string != null && this.children != null) {
                changeSupport = (ChangeSupport)this.children.get(string);
            }
        }
        serializable = null;
        if (identityHashBag2 != null) {
            for (TreeChangeListener treeChangeListener : identityHashBag2) {
                boolean bl;
                ChangeSupport changeSupport2 = this;
                synchronized (changeSupport2) {
                    bl = identityHashBag.contains(treeChangeListener);
                }
                if (!bl) continue;
                if (serializable == null) {
                    serializable = new TreeChangeEvent(this.source, string, objectArray);
                }
                this.notifier().treeChanged(treeChangeListener, (TreeChangeEvent)serializable);
            }
        }
        if (changeSupport != null) {
            if (serializable == null) {
                changeSupport.fireTreeChanged(string, objectArray);
            } else {
                changeSupport.fireTreeChanged((TreeChangeEvent)serializable);
            }
        }
        this.sourceChanged(string);
    }

    public void fireTreeChanged(String string) {
        this.fireTreeChanged(string, null);
    }

    public String toString() {
        return StringTools.buildToStringFor(this, this.source);
    }
}

