/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility.events;

import java.util.EventObject;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.NullListIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.ReadOnlyListIterator;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

public class ListChangeEvent
extends EventObject {
    private String listName;
    private int index = -1;
    private List items;
    private List replacedItems;
    private static final long serialVersionUID = 1L;

    public ListChangeEvent(Object object) {
        super(object);
    }

    public ListChangeEvent(Object object, String string) {
        this(object);
        this.listName = string;
    }

    public ListChangeEvent(Object object, String string, int n, List list) {
        this(object, string);
        this.index = n;
        this.items = list;
    }

    public ListChangeEvent(Object object, String string, int n, List list, List list2) {
        this(object, string, n, list);
        this.replacedItems = list2;
    }

    public String getListName() {
        return this.listName;
    }

    public int getIndex() {
        return this.index;
    }

    public ListIterator items() {
        if (this.items == null) {
            return NullListIterator.instance();
        }
        return new ReadOnlyListIterator(this.items);
    }

    public int size() {
        if (this.items == null) {
            return 0;
        }
        return this.items.size();
    }

    public ListIterator replacedItems() {
        if (this.replacedItems == null) {
            return NullListIterator.instance();
        }
        return new ReadOnlyListIterator(this.replacedItems);
    }

    public ListChangeEvent cloneWithSource(Object object) {
        return new ListChangeEvent(object, this.listName, this.index, this.items, this.replacedItems);
    }

    public ListChangeEvent cloneWithSource(Object object, String string) {
        return new ListChangeEvent(object, string, this.index, this.items, this.replacedItems);
    }

    public ListChangeEvent cloneWithSource(Object object, String string, int n) {
        return new ListChangeEvent(object, string, this.index + n, this.items, this.replacedItems);
    }

    public String toString() {
        return StringTools.buildToStringFor(this, this.listName);
    }
}

