/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility.iterators;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.persistence.tools.workbench.utility.ClassTools;
import org.eclipse.persistence.tools.workbench.utility.iterators.ArrayIterator;

public class CloneIterator
implements Iterator {
    private Iterator nestedIterator;
    private Object current;
    private Mutator mutator;
    private static final Object UNKNOWN = new Object();

    public CloneIterator(Collection collection) {
        this(collection, Mutator.READ_ONLY_INSTANCE);
    }

    public CloneIterator(Collection collection, Mutator mutator) {
        this.nestedIterator = new ArrayIterator(collection.toArray());
        this.mutator = mutator;
        this.current = UNKNOWN;
    }

    public boolean hasNext() {
        return this.nestedIterator.hasNext();
    }

    public Object next() {
        this.current = this.nestedIterator.next();
        return this.current;
    }

    public void remove() {
        if (this.current == UNKNOWN) {
            throw new IllegalStateException();
        }
        this.remove(this.current);
        this.current = UNKNOWN;
    }

    protected void remove(Object object) {
        this.mutator.remove(object);
    }

    public String toString() {
        return ClassTools.shortClassNameForObject(this);
    }

    public static interface Mutator {
        public static final Mutator READ_ONLY_INSTANCE = new Mutator(){

            public void remove(Object object) {
                throw new UnsupportedOperationException();
            }

            public String toString() {
                return "ReadOnlyMutator";
            }
        };

        public void remove(Object var1);
    }
}

