/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility.node;

import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.eclipse.persistence.tools.workbench.utility.SynchronizedBoolean;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public class RunnableValidation
implements Runnable {
    private Node node;
    private SynchronizedBoolean validateFlag;
    private SynchronizedBoolean continueFlag;
    private Logger exceptionLogger;
    private Level exceptionLevel;
    private String exceptionMessage;

    public RunnableValidation(Node node, SynchronizedBoolean synchronizedBoolean, SynchronizedBoolean synchronizedBoolean2, Logger logger, Level level, String string) {
        this.node = node;
        this.validateFlag = synchronizedBoolean;
        this.continueFlag = synchronizedBoolean2;
        this.exceptionLogger = logger;
        this.exceptionLevel = level;
        this.exceptionMessage = string;
    }

    public void run() {
        while (this.continueFlag.isTrue()) {
            try {
                this.validateFlag.waitToSetFalse();
            }
            catch (InterruptedException interruptedException) {
                return;
            }
            this.validateNode();
        }
    }

    private void validateNode() {
        try {
            this.node.validateBranch();
        }
        catch (Throwable throwable) {
            this.logException(throwable);
        }
    }

    private void logException(Throwable throwable) {
        LogRecord logRecord = new LogRecord(this.exceptionLevel, this.exceptionMessage);
        logRecord.setParameters(new Object[]{this.node.displayString()});
        logRecord.setThrown(throwable);
        logRecord.setLoggerName(this.exceptionLogger.getName());
        logRecord.setResourceBundle(this.exceptionLogger.getResourceBundle());
        this.exceptionLogger.log(logRecord);
    }
}

