/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.ant;

import java.io.File;
import java.io.PrintStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import java.util.prefs.Preferences;
import org.apache.tools.ant.BuildException;
import org.eclipse.persistence.tools.workbench.ant.ProjectExplorerInterface;
import org.eclipse.persistence.tools.workbench.ant.ProjectRunner;
import org.eclipse.persistence.tools.workbench.framework.resources.DefaultStringRepository;
import org.eclipse.persistence.tools.workbench.framework.resources.StringRepository;
import org.eclipse.persistence.tools.workbench.mappingsio.ProjectIOManager;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWLoginSpec;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.MWProject;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.xml.MWEisLoginSpec;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.xml.MWEisProject;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.xml.MWOXProject;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.project.UiProjectBundle;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;

public class ProjectExporter
extends ProjectRunner
implements ProjectExplorerInterface {
    private StringRepository uiProjectStringRepository;

    public ProjectExporter() {
    }

    public ProjectExporter(PrintStream printStream) {
        super(printStream);
    }

    protected void initialize(PrintStream printStream) {
        super.initialize(printStream);
        this.uiProjectStringRepository = new DefaultStringRepository(UiProjectBundle.class);
    }

    public int execute(String string, String string2, String string3, Vector vector, Boolean bl, String string4, String string5, String string6, String string7) {
        boolean bl2 = bl;
        File file = new File(string);
        File file2 = new File(string2);
        try {
            MWProject mWProject = new ProjectIOManager().read(file, Preferences.userNodeForPackage(this.getClass()));
            mWProject.validateBranch();
            if (mWProject.hasBranchProblems()) {
                Collection collection = CollectionTools.collection((Iterator)mWProject.branchProblems());
                Vector vector2 = this.getIgnoredProblems(collection, vector);
                this.log(this.igoredProblemsSummary(vector2, vector).append('\n'));
                if (bl2 && collection.size() - vector2.size() > 0) {
                    throw new BuildException(this.problemsSummary(mWProject, mWProject.branchProblemsSize()).toString());
                }
            }
            this.export(mWProject, file2, string3, bl2, string4, string5, string6, string7);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable.getCause() == null ? throwable : throwable.getCause();
            String string8 = throwable2.getMessage() == null ? throwable2.toString() : throwable2.getMessage();
            throw new BuildException(this.stringRepository.getString("errorWhileExporting", string8), throwable);
        }
        return 0;
    }

    protected void export(MWProject mWProject, File file, String string, boolean bl, String string2, String string3, String string4, String string5) {
        if (mWProject instanceof MWOXProject) {
            this.exportOXProject(mWProject, file);
        } else if (mWProject instanceof MWEisProject) {
            this.exportEisProject(mWProject, file, string2, string3, string4, string5);
        } else {
            this.exportRelationalProject(mWProject, file, string2, string3, string4, string5);
        }
    }

    private void exportRelationalProject(MWProject mWProject, File file, String string, String string2, String string3, String string4) {
        if (file.getPath() != "") {
            mWProject.setDeploymentXMLFileName(file.getPath());
        }
        if (mWProject.getDeploymentXMLFileName() == "") {
            throw new RuntimeException(this.stringRepository.getString("notDefined", "DeploymentFileName"));
        }
        MWLoginSpec mWLoginSpec = mWProject.getDatabase().getDeploymentLoginSpec();
        if (string != "") {
            if (string != "") {
                mWLoginSpec.setURL(string);
            }
            if (string2 != "") {
                mWLoginSpec.setDriverClassName(string2);
            }
            if (string3 != "") {
                mWLoginSpec.setUserName(string3);
            }
            if (string4 != "") {
                mWLoginSpec.setPassword(string4);
            }
        }
        this.log(this.stringRepository.getString("exportingXml", mWProject.getDeploymentXMLFileName()) + "\n");
        mWProject.exportDeploymentXML();
    }

    private void exportOXProject(MWProject mWProject, File file) {
        if (file.getPath() != "") {
            mWProject.setDeploymentXMLFileName(file.getPath());
        }
        if (mWProject.getDeploymentXMLFileName() == "") {
            throw new RuntimeException(this.stringRepository.getString("notDefined", "DeploymentFileName"));
        }
        this.log(this.stringRepository.getString("exportingXml", mWProject.getDeploymentXMLFileName()) + "\n");
        mWProject.exportDeploymentXML();
    }

    private void exportEisProject(MWProject mWProject, File file, String string, String string2, String string3, String string4) {
        if (file.getPath() != "") {
            mWProject.setDeploymentXMLFileName(file.getPath());
        }
        if (mWProject.getDeploymentXMLFileName() == "") {
            throw new RuntimeException(this.stringRepository.getString("notDefined", "DeploymentFileName"));
        }
        MWEisLoginSpec mWEisLoginSpec = ((MWEisProject)mWProject).getEisLoginSpec();
        if (string != "") {
            if (string != "") {
                mWEisLoginSpec.setConnectionFactoryURL(string);
            }
            if (string2 != "") {
                mWEisLoginSpec.setJ2CAdapterName(string2);
            }
            if (string3 != "") {
                mWEisLoginSpec.setUserName(string3);
            }
            if (string4 != "") {
                mWEisLoginSpec.setPassword(string4);
            }
        }
        this.log(this.stringRepository.getString("exportingXml", mWProject.getDeploymentXMLFileName()) + "\n");
        mWProject.exportDeploymentXML();
    }
}

