/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.framework.help;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import org.eclipse.persistence.tools.workbench.framework.action.FrameworkAction;
import org.eclipse.persistence.tools.workbench.framework.app.PreferencesNode;
import org.eclipse.persistence.tools.workbench.framework.context.PreferencesContext;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.help.DefaultHelpManager;
import org.eclipse.persistence.tools.workbench.framework.help.HelpManager;
import org.eclipse.persistence.tools.workbench.framework.help.HelpManagerConfig;
import org.eclipse.persistence.tools.workbench.framework.help.HelpPreferencesNode;
import org.eclipse.persistence.tools.workbench.framework.help.HelpTopicIDWindowAction;
import org.eclipse.persistence.tools.workbench.framework.help.InternalHelpManager;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

public final class HelpFacade {
    private static final String HELP_PREFERENCES_NODE = "help";
    private static final String HELP_SET_FILE_NAME = "/tlmwhelp.hs";
    private static final String HELP_JAR_NAME = "/tlmwhelp.jar";
    private static final String BASE_HELP_JAR_NAME = "/tlmwhelp";
    static final String LOCAL_FILE_PREFERENCE = "local file";
    static final String LOCAL_FILE_PREFERENCE_DEFAULT = "";
    static final String DISPLAY_WELCOME_PREFERENCE = "display welcome";
    static final boolean DISPLAY_WELCOME_PREFERENCE_DEFAULT = true;

    public static HelpManager buildHelpManager(HelpManagerConfig helpManagerConfig) {
        Preferences preferences = helpManagerConfig.getPreferences().node(HELP_PREFERENCES_NODE);
        return new DefaultHelpManager(helpManagerConfig.getResourceRepository(), preferences);
    }

    private static URL buildLocalizedHelpUrl(Logger logger) {
        URL uRL = HelpFacade.class.getResource(HelpFacade.localizedHelpResourceJarName(true));
        if (uRL == null) {
            uRL = HelpFacade.class.getResource(HelpFacade.localizedHelpResourceJarName(false));
        }
        if (uRL != null) {
            try {
                uRL = new URL("jar:" + uRL.toString() + "!/");
            }
            catch (MalformedURLException malformedURLException) {
                HelpFacade.log(logger, "LOCALIZED_FILE_NOT_FOUND", uRL, malformedURLException);
            }
            URL[] uRLArray = new URL[]{uRL};
            URLClassLoader uRLClassLoader = new URLClassLoader(uRLArray);
            uRL = uRLClassLoader.findResource(HELP_SET_FILE_NAME);
        }
        return uRL;
    }

    private static String localizedHelpResourceJarName(boolean bl) {
        Locale locale = Locale.getDefault();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(BASE_HELP_JAR_NAME);
        stringBuffer.append("_");
        stringBuffer.append(locale.getLanguage());
        if (bl && !StringTools.stringIsEmpty((String)locale.getCountry())) {
            stringBuffer.append("_");
            stringBuffer.append(locale.getCountry());
        }
        stringBuffer.append(".jar");
        return stringBuffer.toString();
    }

    private static void startPostLaunchThread(InternalHelpManager internalHelpManager, HelpManagerConfig helpManagerConfig) {
        new Thread(HelpFacade.buildPostLaunchRunnable(internalHelpManager, helpManagerConfig), "Display Welcome").start();
    }

    private static Runnable buildPostLaunchRunnable(final InternalHelpManager internalHelpManager, final HelpManagerConfig helpManagerConfig) {
        return new Runnable(){

            public void run() {
                try {
                    helpManagerConfig.getLaunchCompleteFlag().waitUntilTrue();
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
                Preferences preferences = helpManagerConfig.getPreferences().node(HelpFacade.HELP_PREFERENCES_NODE);
                if (helpManagerConfig.forceStupidWelcomeScreen() || preferences.getBoolean(HelpFacade.DISPLAY_WELCOME_PREFERENCE, true)) {
                    internalHelpManager.showTopic("welcome");
                }
                internalHelpManager.launchComplete();
            }
        };
    }

    private static void log(Logger logger, String string, Object object, Throwable throwable) {
        LogRecord logRecord = new LogRecord(Level.WARNING, string);
        logRecord.setParameters(new Object[]{object});
        logRecord.setThrown(throwable);
        logRecord.setLoggerName(logger.getName());
        logRecord.setResourceBundle(logger.getResourceBundle());
        logger.log(logRecord);
    }

    public static FrameworkAction buildHelpTopicIDWindowAction(WorkbenchContext workbenchContext) {
        return new HelpTopicIDWindowAction(workbenchContext);
    }

    public static PreferencesNode buildHelpPreferencesNode(PreferencesContext preferencesContext) {
        PreferencesContext preferencesContext2 = (PreferencesContext)preferencesContext.buildRedirectedPreferencesContext(HELP_PREFERENCES_NODE);
        return new HelpPreferencesNode(preferencesContext2);
    }

    private HelpFacade() {
        throw new UnsupportedOperationException();
    }

    private static class LocalHelpBookWarning
    extends RuntimeException {
        LocalHelpBookWarning() {
        }
    }
}

