/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.framework.internal;

import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import org.eclipse.persistence.tools.workbench.framework.internal.WorkbenchWindow;
import org.eclipse.persistence.tools.workbench.uitools.swing.EmptyIcon;
import org.eclipse.persistence.tools.workbench.utility.io.FileTools;

final class OpenRecentFileAction
extends AbstractAction {
    private WorkbenchWindow workbenchWindow;
    private File recentFile;
    private static final Icon ICON = new EmptyIcon(16);

    OpenRecentFileAction(WorkbenchWindow workbenchWindow, int n, File file) {
        this.initialize(workbenchWindow, n, file);
    }

    void initialize(WorkbenchWindow workbenchWindow, int n, File file) {
        this.workbenchWindow = workbenchWindow;
        this.recentFile = file;
        String string = Integer.toString(n);
        String string2 = FileTools.shortenFileName((File)file.getAbsoluteFile());
        this.putValue("Name", string + " " + string2);
        this.putValue("ShortDescription", file.getAbsolutePath());
        this.putValue("SmallIcon", ICON);
        if (n < 10) {
            this.putValue("MnemonicKey", new Integer(string.charAt(0)));
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.recentFile.exists()) {
            this.workbenchWindow.nodeManager().open(this.recentFile, this.workbenchWindow.getContext());
        } else {
            JOptionPane.showMessageDialog(this.workbenchWindow, this.workbenchWindow.resourceRepository().getString("recentProjectFileNotFound.message", this.recentFile.getAbsolutePath()), this.workbenchWindow.resourceRepository().getString("recentProjectFileNotFound.title"), 0);
            this.workbenchWindow.getApplication().recentFilesManager().removeRecentFile(this.recentFile);
        }
    }
}

