/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.framework.internal;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.persistence.tools.workbench.framework.action.AbstractFrameworkAction;
import org.eclipse.persistence.tools.workbench.framework.app.ApplicationNode;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.internal.FrameworkNodeManager;

final class SaveAction
extends AbstractFrameworkAction {
    private FrameworkNodeManager nodeManager;
    private ApplicationNode[] selectedProjectNodes;
    private PropertyChangeListener dirtyListener;

    SaveAction(WorkbenchContext workbenchContext, FrameworkNodeManager frameworkNodeManager) {
        super(workbenchContext);
        this.nodeManager = frameworkNodeManager;
    }

    protected void initialize() {
        super.initialize();
        this.initializeTextAndMnemonic("file.save");
        this.initializeIcon("file.save");
        this.initializeToolTipText("file.save.toolTipText");
        this.initializeAccelerator("file.save.ACCELERATOR");
        this.dirtyListener = this.buildDirtyListener();
    }

    private PropertyChangeListener buildDirtyListener() {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                SaveAction.this.updateEnabledState();
            }
        };
    }

    public void setUp() {
        super.setUp();
        this.selectedProjectNodes = this.selectedProjectNodes();
        this.engageSelectedProjectNodes();
        this.updateEnabledState();
    }

    public void tearDown() {
        this.disengageSelectedProjectNodes();
        super.tearDown();
    }

    void updateEnabledState() {
        if (this.selectedNodes().length == 0) {
            this.setEnabled(false);
            return;
        }
        int n = this.selectedProjectNodes.length;
        while (n-- > 0) {
            if (this.selectedProjectNodes[n].isDirty()) continue;
            this.setEnabled(false);
            return;
        }
        this.setEnabled(true);
    }

    private void engageSelectedProjectNodes() {
        int n = this.selectedProjectNodes.length;
        while (n-- > 0) {
            this.selectedProjectNodes[n].addPropertyChangeListener("dirty", this.dirtyListener);
        }
    }

    private void disengageSelectedProjectNodes() {
        int n = this.selectedProjectNodes.length;
        while (n-- > 0) {
            this.selectedProjectNodes[n].removePropertyChangeListener("dirty", this.dirtyListener);
        }
        this.selectedProjectNodes = null;
    }

    protected void execute() {
        int n = this.selectedProjectNodes.length;
        while (n-- > 0) {
            this.nodeManager.save(this.selectedProjectNodes[n], this.getWorkbenchContext());
        }
    }
}

