/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.framework.ui.chooser;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.chooser.ClassChooserDialog;
import org.eclipse.persistence.tools.workbench.framework.ui.chooser.ClassDescriptionAdapter;
import org.eclipse.persistence.tools.workbench.framework.ui.chooser.ClassDescriptionRepository;
import org.eclipse.persistence.tools.workbench.framework.ui.chooser.ClassDescriptionRepositoryFactory;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.TransformationPropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.DocumentAdapter;

public class ClassChooserPanel
extends AbstractPanel {
    private PropertyValueModel selectionHolder;
    private ClassDescriptionRepositoryFactory classDescriptionRepositoryFactory;
    ClassDescriptionAdapter classDescriptionAdapter;
    private boolean allowNullSelection;
    private String buttonKey;

    public ClassChooserPanel(PropertyValueModel propertyValueModel, ClassDescriptionRepositoryFactory classDescriptionRepositoryFactory, ClassDescriptionAdapter classDescriptionAdapter, WorkbenchContextHolder workbenchContextHolder) {
        this(propertyValueModel, classDescriptionRepositoryFactory, classDescriptionAdapter, null, workbenchContextHolder);
    }

    public ClassChooserPanel(PropertyValueModel propertyValueModel, ClassDescriptionRepositoryFactory classDescriptionRepositoryFactory, ClassDescriptionAdapter classDescriptionAdapter, JLabel jLabel, WorkbenchContextHolder workbenchContextHolder) {
        this(propertyValueModel, classDescriptionRepositoryFactory, classDescriptionAdapter, jLabel, workbenchContextHolder, "CLASS_CHOOSER_BROWSE_BUTTON");
    }

    public ClassChooserPanel(PropertyValueModel propertyValueModel, ClassDescriptionRepositoryFactory classDescriptionRepositoryFactory, ClassDescriptionAdapter classDescriptionAdapter, JLabel jLabel, WorkbenchContextHolder workbenchContextHolder, String string) {
        super(workbenchContextHolder);
        this.selectionHolder = propertyValueModel;
        this.classDescriptionRepositoryFactory = classDescriptionRepositoryFactory;
        this.classDescriptionAdapter = classDescriptionAdapter;
        this.allowNullSelection = false;
        this.buttonKey = string;
        this.initializeLayout(jLabel);
    }

    private void initializeLayout(JLabel jLabel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JTextField jTextField = new JTextField(new DocumentAdapter(this.buildClassNameHolder()), null, 1);
        jTextField.setEditable(false);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)jTextField, gridBagConstraints);
        if (jLabel != null) {
            jTextField.putClientProperty("labeledBy", jLabel);
        }
        JButton jButton = this.buildButton(this.buttonKey);
        jButton.addActionListener(this.buildActionListener());
        if (jLabel != null) {
            jLabel.setLabelFor(jButton);
            SwingComponentFactory.updateButtonAccessibleName(jLabel, jButton);
        }
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.add((Component)jButton, gridBagConstraints);
        this.addAlignRight(jButton);
    }

    private PropertyValueModel buildClassNameHolder() {
        return new TransformationPropertyValueModel(this.selectionHolder){

            protected Object transform(Object object) {
                return object == null ? "" : ClassChooserPanel.this.classDescriptionAdapter.className(object).replace('$', '.');
            }

            protected Object reverseTransform(Object object) {
                throw new UnsupportedOperationException();
            }
        };
    }

    private ActionListener buildActionListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ClassChooserPanel.this.promptUserToSelectClass();
            }
        };
    }

    private ClassDescriptionRepository buildRepository() {
        return this.classDescriptionRepositoryFactory.createClassDescriptionRepository();
    }

    private Object getSelection() {
        return this.selectionHolder.getValue();
    }

    void promptUserToSelectClass() {
        ClassChooserDialog classChooserDialog = this.buildDialog();
        classChooserDialog.setAllowNullSelection(this.allowNullSelection);
        classChooserDialog.setInitialSelection(this.getSelection());
        classChooserDialog.show();
        if (classChooserDialog.wasConfirmed()) {
            this.selectionHolder.setValue(classChooserDialog.selection());
        }
        classChooserDialog = null;
        ClassChooserDialog.gc();
    }

    private ClassChooserDialog buildDialog() {
        return ClassChooserDialog.createDialog(this.buildRepository(), this.classDescriptionAdapter, this.getWorkbenchContext());
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        int n = this.getComponentCount();
        while (n-- > 0) {
            this.getComponent(n).setEnabled(bl);
        }
    }

    public void setAllowNullSelection(boolean bl) {
        this.allowNullSelection = bl;
    }
}

