/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.framework.uitools;

import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.event.SwingPropertyChangeSupport;

public final class ComponentAligner {
    private boolean autoValidate;
    private PropertyChangeSupport changeSupport;
    private boolean locked;
    private int maximumWidth;
    private PropertyChangeListener propertyChangeListener;
    private Collection wrappers;
    private static final String TEXT_PROPERTY = "text";

    public ComponentAligner() {
        this(true);
    }

    public ComponentAligner(boolean bl) {
        this.initialize(bl);
    }

    public ComponentAligner(Collection collection) {
        this();
        this.addAll(collection);
    }

    public ComponentAligner(Collection collection, boolean bl) {
        this(bl);
        this.addAll(collection);
    }

    public void add(ComponentAligner componentAligner) {
        if (componentAligner == this) {
            throw new IllegalArgumentException("Can't add the ComponentAligner to itself");
        }
        Wrapper wrapper = this.buildWrapper(componentAligner);
        wrapper.addPropertyChangeListener(this.propertyChangeListener);
        this.wrappers.add(wrapper);
        if (!componentAligner.wrappers.isEmpty()) {
            this.revalidate();
        }
    }

    public void add(JComponent jComponent) {
        Wrapper wrapper = this.buildWrapper(jComponent);
        wrapper.addPropertyChangeListener(this.propertyChangeListener);
        this.wrappers.add(wrapper);
        this.revalidate();
    }

    public void addAll(Collection collection) {
        boolean bl = this.autoValidate;
        this.autoValidate = false;
        for (Object e : collection) {
            if (e instanceof ComponentAligner) {
                this.add((ComponentAligner)e);
                continue;
            }
            this.add((JComponent)e);
        }
        this.autoValidate = bl;
        this.revalidate();
    }

    private void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.changeSupport == null) {
            this.changeSupport = new SwingPropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(TEXT_PROPERTY, propertyChangeListener);
    }

    private Wrapper buildWrapper(ComponentAligner componentAligner) {
        return new ComponentAlignerWrapper(componentAligner);
    }

    private Wrapper buildWrapper(JComponent jComponent) {
        return new ComponentWrapper(jComponent);
    }

    private void firePropertyChange(int n, int n2) {
        if (this.changeSupport != null && n != n2) {
            this.changeSupport.firePropertyChange(TEXT_PROPERTY, new Integer(n), new Integer(n2));
        }
    }

    public int getMaximumWidth() {
        return this.maximumWidth;
    }

    private Dimension getPreferredSize() {
        if (this.maximumWidth == -1) {
            this.recalculateWidth();
        }
        return new Dimension(this.maximumWidth, 0);
    }

    private void initialize(boolean bl) {
        this.autoValidate = bl;
        this.maximumWidth = -1;
        this.propertyChangeListener = new PropertyChangeHandler();
        this.wrappers = new Vector();
    }

    private void invalidate(Object object) {
        Wrapper wrapper = this.retrieveWrapper(object);
        if (wrapper.isLocked()) {
            return;
        }
        Dimension dimension = wrapper.getCachedSize();
        dimension.width = 0;
        dimension.height = 0;
        wrapper.setPreferredSize(null);
    }

    public boolean isAutoValidate() {
        return this.autoValidate;
    }

    private void recalculateWidth() {
        int n = -1;
        Iterator iterator = this.wrappers();
        while (iterator.hasNext()) {
            Wrapper wrapper = (Wrapper)iterator.next();
            Dimension dimension = wrapper.getCachedSize();
            if (dimension.height == 0) {
                Dimension dimension2 = wrapper.getPreferredSize();
                dimension.width = dimension2.width;
                dimension.height = dimension2.height;
            }
            n = Math.max(dimension.width, n);
        }
        this.locked = true;
        this.setMaximumWidth(n);
        this.locked = false;
    }

    public void remove(ComponentAligner componentAligner) {
        Wrapper wrapper = this.retrieveWrapper(componentAligner);
        wrapper.removePropertyChangeListener(this.propertyChangeListener);
        this.wrappers.remove(wrapper);
        this.revalidate();
    }

    public void remove(JComponent jComponent) {
        Wrapper wrapper = this.retrieveWrapper(jComponent);
        wrapper.removePropertyChangeListener(this.propertyChangeListener);
        this.wrappers.remove(wrapper);
        this.revalidate();
    }

    private void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changeSupport.removePropertyChangeListener(TEXT_PROPERTY, propertyChangeListener);
        if (!this.changeSupport.hasListeners(TEXT_PROPERTY)) {
            this.changeSupport = null;
        }
    }

    private Wrapper retrieveWrapper(Object object) {
        Iterator iterator = this.wrappers();
        while (iterator.hasNext()) {
            Wrapper wrapper = (Wrapper)iterator.next();
            if (wrapper.getSource() != object) continue;
            return wrapper;
        }
        throw new IllegalArgumentException("Can't retrieve the Wrapper for " + object);
    }

    private void revalidate() {
        if (this.isAutoValidate()) {
            this.revalidatePreferredSize();
        }
    }

    public void revalidatePreferredSize() {
        this.recalculateWidth();
        this.revalidatePreferredSizeImp();
    }

    private void revalidatePreferredSizeImp() {
        Iterator iterator = this.wrappers();
        while (iterator.hasNext()) {
            Wrapper wrapper = (Wrapper)iterator.next();
            Dimension dimension = wrapper.getCachedSize();
            dimension = new Dimension(this.maximumWidth, dimension.height);
            wrapper.setPreferredSize(dimension);
        }
    }

    public void setAutoValidate(boolean bl) {
        boolean bl2 = this.isAutoValidate();
        this.autoValidate = bl;
        if (!bl2) {
            this.revalidate();
        }
    }

    private void setMaximumWidth(int n) {
        int n2 = this.getMaximumWidth();
        this.maximumWidth = n;
        this.firePropertyChange(n2, n);
    }

    private Iterator wrappers() {
        return this.wrappers.iterator();
    }

    private static interface Wrapper {
        public void addPropertyChangeListener(PropertyChangeListener var1);

        public Dimension getCachedSize();

        public Dimension getPreferredSize();

        public Object getSource();

        public boolean isLocked();

        public void removePropertyChangeListener(PropertyChangeListener var1);

        public void setPreferredSize(Dimension var1);
    }

    private class PropertyChangeHandler
    implements PropertyChangeListener {
        private PropertyChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            ComponentAligner.this.invalidate(propertyChangeEvent.getSource());
            ComponentAligner.this.revalidate();
        }
    }

    private class ComponentWrapper
    implements Wrapper {
        private Dimension cachedSize;
        private final JComponent component;

        private ComponentWrapper(JComponent jComponent) {
            this.component = jComponent;
            this.cachedSize = new Dimension();
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.component.addPropertyChangeListener(ComponentAligner.TEXT_PROPERTY, propertyChangeListener);
        }

        public Dimension getCachedSize() {
            return this.cachedSize;
        }

        public Dimension getPreferredSize() {
            return this.component.getPreferredSize();
        }

        public Object getSource() {
            return this.component;
        }

        public boolean isLocked() {
            return false;
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.component.removePropertyChangeListener(ComponentAligner.TEXT_PROPERTY, propertyChangeListener);
        }

        public void setPreferredSize(Dimension dimension) {
            this.component.setPreferredSize(dimension);
        }
    }

    private class ComponentAlignerWrapper
    implements Wrapper {
        private Dimension cachedSize;
        private final ComponentAligner componentAligner;

        private ComponentAlignerWrapper(ComponentAligner componentAligner2) {
            this.componentAligner = componentAligner2;
            this.cachedSize = new Dimension(componentAligner2.maximumWidth, 0);
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.componentAligner.addPropertyChangeListener(propertyChangeListener);
        }

        public Dimension getCachedSize() {
            return this.cachedSize;
        }

        public Dimension getPreferredSize() {
            return this.componentAligner.getPreferredSize();
        }

        public Object getSource() {
            return this.componentAligner;
        }

        public boolean isLocked() {
            return this.componentAligner.locked;
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.componentAligner.removePropertyChangeListener(propertyChangeListener);
        }

        public void setPreferredSize(Dimension dimension) {
            if (dimension == null) {
                this.componentAligner.maximumWidth = -1;
            } else if (this.componentAligner.maximumWidth != dimension.width) {
                this.componentAligner.maximumWidth = dimension.width;
                this.componentAligner.revalidatePreferredSizeImp();
            }
        }
    }
}

