/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.framework.uitools;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import org.eclipse.persistence.tools.workbench.framework.context.ApplicationContext;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.FileChooser;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.DocumentAdapter;

public class FileChooserPanel
extends AbstractPanel {
    private PropertyValueModel filePathHolder;
    private FileHolder fileChooserRootFileHolder;
    private FileFilter fileChooserFileFilter;
    private FileHolder fileChooserDefaultDirectoryHolder;
    private static final long serialVersionUID = 1L;

    public FileChooserPanel(ApplicationContext applicationContext, PropertyValueModel propertyValueModel, String string) {
        this(applicationContext, propertyValueModel, string, null, 0, false);
    }

    public FileChooserPanel(ApplicationContext applicationContext, PropertyValueModel propertyValueModel, String string, boolean bl) {
        this(applicationContext, propertyValueModel, string, null, 0, bl);
    }

    public FileChooserPanel(ApplicationContext applicationContext, PropertyValueModel propertyValueModel, String string, String string2) {
        this(applicationContext, propertyValueModel, string, string2, 0, false);
    }

    public FileChooserPanel(ApplicationContext applicationContext, PropertyValueModel propertyValueModel, String string, String string2, boolean bl) {
        this(applicationContext, propertyValueModel, string, string2, 0, bl);
    }

    public FileChooserPanel(ApplicationContext applicationContext, PropertyValueModel propertyValueModel, String string, int n) {
        this(applicationContext, propertyValueModel, string, null, n);
    }

    public FileChooserPanel(ApplicationContext applicationContext, PropertyValueModel propertyValueModel, String string, int n, boolean bl) {
        this(applicationContext, propertyValueModel, string, null, n, bl);
    }

    public FileChooserPanel(ApplicationContext applicationContext, PropertyValueModel propertyValueModel, String string, String string2, int n) {
        this(applicationContext, propertyValueModel, string, null, n, false);
    }

    public FileChooserPanel(ApplicationContext applicationContext, PropertyValueModel propertyValueModel, String string, String string2, int n, boolean bl) {
        super(applicationContext);
        this.filePathHolder = propertyValueModel;
        this.fileChooserRootFileHolder = new SimpleFileHolder();
        this.fileChooserDefaultDirectoryHolder = new SimpleFileHolder();
        this.initialize(string, string2, n, bl);
    }

    private void initialize(String string, String string2, int n, boolean bl) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        boolean bl2 = this.labelVisible();
        JLabel jLabel = this.buildLabel(string);
        jLabel.setVisible(bl2);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = bl ? 2 : 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)jLabel, gridBagConstraints);
        this.addAlignLeft(jLabel);
        JTextField jTextField = new JTextField(new DocumentAdapter(this.filePathHolder), null, 1);
        gridBagConstraints.gridx = bl ? 0 : 1;
        gridBagConstraints.gridy = bl ? 1 : 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(bl ? 1 : 0, bl ? 0 : (bl2 ? 5 : 0), 0, 0);
        this.add((Component)jTextField, gridBagConstraints);
        jLabel.setLabelFor(jTextField);
        JButton jButton = this.buildFileChooserButton(string2, n);
        SwingComponentFactory.updateButtonAccessibleName(jLabel, jButton);
        gridBagConstraints.gridx = bl ? 1 : 2;
        gridBagConstraints.gridy = bl ? 1 : 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(bl ? 1 : 0, 5, 0, 0);
        this.add((Component)jButton, gridBagConstraints);
        this.addAlignRight(jButton);
    }

    protected JButton buildFileChooserButton(String string, int n) {
        String string2 = string != null ? string : this.browseButtonKey();
        JButton jButton = this.buildButton(string2);
        jButton.addActionListener(this.buildFileActionListener(n));
        return jButton;
    }

    protected String browseButtonKey() {
        return "FILE_CHOOSER_PANEL.BROWSE_BUTTON_TEXT";
    }

    protected boolean labelVisible() {
        return true;
    }

    private ActionListener buildFileActionListener(final int n) {
        return new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FileChooserPanel.this.promptForFile(n);
            }
        };
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        Component[] componentArray = this.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            componentArray[i].setEnabled(bl);
        }
    }

    public void requestFocus() {
        this.getComponent(1).requestFocus();
    }

    public void setFileChooserRootFileHolder(FileHolder fileHolder) {
        if (fileHolder == null) {
            throw new NullPointerException();
        }
        this.fileChooserRootFileHolder = fileHolder;
    }

    public void setFileChooserFileFilter(FileFilter fileFilter) {
        this.fileChooserFileFilter = fileFilter;
    }

    public void setFileChooserDefaultDirectoryHolder(FileHolder fileHolder) {
        if (fileHolder == null) {
            throw new NullPointerException();
        }
        this.fileChooserDefaultDirectoryHolder = fileHolder;
    }

    private String getFilePath() {
        return (String)this.filePathHolder.getValue();
    }

    protected File getFileChooserDefaultDirectory() {
        return this.fileChooserDefaultDirectoryHolder.getFile();
    }

    private void setFileChooserDefaultDirectory(File file) {
        this.fileChooserDefaultDirectoryHolder.setFile(file);
    }

    private File getFile() {
        String string = this.getFilePath();
        if (string == null || string.length() == 0) {
            return null;
        }
        return new File(string);
    }

    private void setFilePath(String string) {
        this.filePathHolder.setValue(string);
    }

    void promptForFile(int n) {
        Window window = SwingUtilities.getWindowAncestor(this);
        File file = this.getFile();
        FileChooser fileChooser = new FileChooser(this.getFileChooserDefaultDirectory(), this.fileChooserRootFileHolder.getFile());
        fileChooser.setFileSelectionMode(n);
        fileChooser.setSelectedFile(file);
        fileChooser.setMultiSelectionEnabled(false);
        fileChooser.setFileFilter(this.fileChooserFileFilter);
        if (fileChooser.showOpenDialog(window) == 0) {
            this.setFilePath(fileChooser.getSelectedFile().getPath());
            this.setFileChooserDefaultDirectory(fileChooser.getCurrentDirectory());
        }
    }

    public class SimpleFileHolder
    implements FileHolder {
        private File file;

        public File getFile() {
            return this.file;
        }

        public void setFile(File file) {
            this.file = file;
        }
    }

    public static interface FileHolder {
        public File getFile();

        public void setFile(File var1);
    }
}

