/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.sourcegen;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.prefs.Preferences;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.resources.ResourceRepository;
import org.eclipse.persistence.tools.workbench.framework.ui.dialog.ExceptionDialog;
import org.eclipse.persistence.tools.workbench.framework.uitools.FileChooser;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.MWProject;
import org.eclipse.persistence.tools.workbench.mappingsplugin.MappingsPlugin;
import org.eclipse.persistence.tools.workbench.mappingsplugin.sourcegen.SourceCodeGenerator;
import org.eclipse.persistence.tools.workbench.uitools.CancelException;

public final class ModelSourceGenerationCoordinator
implements SourceCodeGenerator.FileAlreadyExistsListener,
SourceCodeGenerator.ContinuableExceptionListener {
    private WorkbenchContext context;
    private SourceCodeGenerator generator;
    private boolean processCanceled = false;
    private boolean processErrorless = true;

    public ModelSourceGenerationCoordinator(WorkbenchContext workbenchContext) {
        this.initialize(workbenchContext);
    }

    private void initialize(WorkbenchContext workbenchContext) {
        this.context = workbenchContext;
        this.setGenerator(new SourceCodeGenerator(workbenchContext.getApplicationContext()));
    }

    private void setGenerator(SourceCodeGenerator sourceCodeGenerator) {
        this.generator = sourceCodeGenerator;
        this.generator.addContinuableExceptionListener(this);
        this.generator.addFileAlreadyExistsListener(this);
    }

    public void exportModelJavaSource(MWProject mWProject, Collection collection) {
        try {
            this.validateModelSourceRootDirectory(mWProject);
            this.generator.generateSourceCode(mWProject, collection);
        }
        catch (CancelException cancelException) {
            return;
        }
        this.showUserFeedback(mWProject);
    }

    private void validateModelSourceRootDirectory(MWProject mWProject) {
        if (mWProject.getModelSourceDirectoryName().equals("")) {
            this.promptForModelSourceRootDirectory(mWProject);
        }
        if (mWProject.absoluteModelSourceDirectory().isFile()) {
            this.promptForNonFileModelSourceRootDirectory(mWProject);
        }
        if (!mWProject.absoluteModelSourceDirectory().exists()) {
            this.promptToCreateModelSourceRootDirectory(mWProject);
        }
    }

    private void promptForModelSourceRootDirectory(MWProject mWProject) {
        String string = this.resourceRepository().getString("MODEL_SOURCE_ROOT_DIRECTORY_DIALOG_NO_DIRECTORY_CHOSEN.message");
        this.promptForDirectory(mWProject, string);
    }

    private void promptForNonFileModelSourceRootDirectory(MWProject mWProject) {
        String string = this.resourceRepository().getString("MODEL_SOURCE_ROOT_DIRECTORY_DIALOG_CHOSEN_DIRECTORY_IS_A_FILE.message", new Object[]{mWProject.absoluteModelSourceDirectory()});
        this.promptForDirectory(mWProject, string);
    }

    private void promptForValidModelSourceRootDirectory(MWProject mWProject) {
        String string = this.resourceRepository().getString("MODEL_SOURCE_ROOT_DIRECTORY_DIALOG_CHOSEN_DIRECTORY_IS_INVALID.message", new Object[]{mWProject.absoluteModelSourceDirectory()});
        this.promptForDirectory(mWProject, string);
    }

    private void promptForCreatableModelSourceRootDirectory(MWProject mWProject) {
        String string = this.resourceRepository().getString("MODEL_SOURCE_ROOT_DIRECTORY_DIALOG_CHOSEN_DIRECTORY_COULD_NOT_BE_CREATED.message", new Object[]{mWProject.absoluteModelSourceDirectory()});
        this.promptForDirectory(mWProject, string);
    }

    private Preferences preferences() {
        return this.context.getApplicationContext().getPreferences();
    }

    private void promptForDirectory(MWProject mWProject, String string) {
        File file = MappingsPlugin.buildExportDirectory(mWProject, mWProject.getModelSourceDirectoryName(), this.preferences());
        FileChooser fileChooser = new FileChooser(file, mWProject.getSaveDirectory());
        fileChooser.setDialogTitle(this.resourceRepository().getString("MODEL_SOURCE_ROOT_DIRECTORY_DIALOG.title", mWProject.getName()));
        fileChooser.setFileSelectionMode(1);
        fileChooser.setApproveButtonText(this.resourceRepository().getString("MODEL_SOURCE_ROOT_DIRECTORY_DIALOG_SELECT_BUTTON"));
        fileChooser.setApproveButtonMnemonic(this.resourceRepository().getMnemonic("MODEL_SOURCE_ROOT_DIRECTORY_DIALOG_SELECT_BUTTON"));
        int n = fileChooser.showSaveDialog(this.context.getCurrentWindow());
        if (n == 1) {
            throw new CancelException();
        }
        File file2 = ((JFileChooser)fileChooser).getSelectedFile();
        mWProject.setModelSourceDirectoryName(file2.getPath());
        if (file2 != null && file2.isAbsolute() && !file2.equals(mWProject.getSaveDirectory())) {
            this.preferences().put("export location", file2.getPath());
        }
    }

    private void promptToCreateModelSourceRootDirectory(MWProject mWProject) {
        File file;
        try {
            file = mWProject.absoluteModelSourceDirectory().getCanonicalFile();
        }
        catch (IOException iOException) {
            this.promptForValidModelSourceRootDirectory(mWProject);
            return;
        }
        int n = JOptionPane.showConfirmDialog(this.context.getCurrentWindow(), this.resourceRepository().getString("CREATE_MODEL_SOURCE_ROOT_DIRECTORY_DIALOG.message", new Object[]{file}), this.resourceRepository().getString("CREATE_MODEL_SOURCE_ROOT_DIRECTORY_DIALOG.title"), 0, 3);
        if (n != 0) {
            throw new CancelException();
        }
        if (!mWProject.absoluteModelSourceDirectory().mkdirs()) {
            this.promptForCreatableModelSourceRootDirectory(mWProject);
        }
    }

    private boolean promptToConformEntityBeans() {
        int n = JOptionPane.showConfirmDialog(this.context.getCurrentWindow(), this.resourceRepository().getString("sourceCodeGeneration_specCompliance.message"), this.resourceRepository().getString("sourceCodeGeneration_specCompliance.title"), 0, 3);
        return n == 0;
    }

    private boolean promptToGenerateAssociatedClasses() {
        int n = JOptionPane.showConfirmDialog(this.context.getCurrentWindow(), this.resourceRepository().getString("sourceCodeGeneration_generateAssociatedClasses.message"), this.resourceRepository().getString("sourceCodeGeneration_generateAssociatedClasses.title"), 0, 3);
        return n == 0;
    }

    public boolean continueOnException(SourceCodeGenerator.ContinuableExceptionEvent continuableExceptionEvent) {
        this.processErrorless = false;
        ExceptionDialog exceptionDialog = new ExceptionDialog(this.resourceRepository().getString("EXPORT_MODEL_SOURCE_CONTINUABLE_ERROR_DIALOG.message"), continuableExceptionEvent.getException(), this.context, this.resourceRepository().getString("EXPORT_MODEL_SOURCE_CONTINUABLE_ERROR_DIALOG.title")){

            protected String buildOKText() {
                return this.resourceRepository().getString("EXPORT_MODEL_SOURCE_YES_BUTTON");
            }

            protected String buildCancelText() {
                return this.resourceRepository().getString("EXPORT_MODEL_SOURCE_NO_BUTTON");
            }
        };
        exceptionDialog.show();
        return exceptionDialog.wasConfirmed();
    }

    public boolean fileAlreadyExists(MWProject mWProject, SourceCodeGenerator.FileAlreadyExistsEvent fileAlreadyExistsEvent) {
        int n = JOptionPane.showConfirmDialog(this.context.getCurrentWindow(), this.resourceRepository().getString("sourceCodeGeneration_fileExists.message"), this.resourceRepository().getString("sourceCodeGeneration_fileExists.title"), 1, 3);
        this.generator.setOverwriteFiles(n == 0);
        if (n == 1) {
            this.promptForModelSourceRootDirectory(mWProject);
            this.validateModelSourceRootDirectory(mWProject);
            this.generator.checkForExistingFiles();
        }
        return n != 2;
    }

    private void showUserFeedback(MWProject mWProject) {
        if (this.processCanceled) {
            return;
        }
        if (this.generator.isAnyFileWritten()) {
            if (this.processErrorless) {
                this.showSuccessDialog(mWProject);
            } else {
                this.showCompletionDialog(mWProject);
            }
        }
    }

    private void showSuccessDialog(MWProject mWProject) {
        JOptionPane.showMessageDialog(this.context.getCurrentWindow(), this.resourceRepository().getString("EXPORT_MODEL_SOURCE_SUCCESS_DIALOG.message"), this.resourceRepository().getString("EXPORT_MODEL_SOURCE_SUCCESS_DIALOG.title", mWProject.getName()), 1);
    }

    private void showCompletionDialog(MWProject mWProject) {
        JOptionPane.showMessageDialog(this.context.getCurrentWindow(), this.resourceRepository().getString("EXPORT_MODEL_SOURCE_COMPLETION_DIALOG.message"), this.resourceRepository().getString("EXPORT_MODEL_SOURCE_COMPLETION_DIALOG.title", mWProject.getName()), 1);
    }

    private ResourceRepository resourceRepository() {
        return this.context.getApplicationContext().getResourceRepository();
    }
}

