/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.db;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.Document;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.ui.dialog.NewNameDialog;
import org.eclipse.persistence.tools.workbench.framework.ui.view.TitledPropertiesPage;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWDatabase;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWLoginSpec;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.common.UiCommonBundle;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.db.DatabasePlatformChooserDialog;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.db.LoginSpecPanel;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.db.UiDbBundle;
import org.eclipse.persistence.tools.workbench.platformsmodel.DatabasePlatform;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ItemPropertyListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SimplePropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SortedListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.ValuePropertyPropertyValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ComboBoxModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.DocumentAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ListModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ObjectListSelectionModel;
import org.eclipse.persistence.tools.workbench.uitools.cell.SimpleListCellRenderer;
import org.eclipse.persistence.tools.workbench.utility.NameTools;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

public class DatabasePropertiesPage
extends TitledPropertiesPage {
    ObjectListSelectionModel loginSpecSelectionModel;
    private PropertyValueModel selectedLoginSpecHolder;
    private static final Class[] REQUIRED_RESOURCE_BUNDLES = new Class[]{UiCommonBundle.class, UiDbBundle.class};

    public DatabasePropertiesPage(WorkbenchContext workbenchContext) {
        super(workbenchContext);
    }

    private MWDatabase getDatabase() {
        return (MWDatabase)this.getSelectionHolder().getValue();
    }

    private String helpTopicId() {
        return "database";
    }

    protected Component buildPage() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JTextField jTextField = this.buildPlatformNameTextField();
        JButton jButton = this.buildButton("CHANGE_DATABASE_PLATFORM_BUTTON_TEXT");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DatabasePropertiesPage.this.promptToChangePlatform();
            }
        });
        JComponent jComponent = this.buildLabeledComponent("DATABASE_PLATFORM_LABEL", jTextField, jButton);
        ((JLabel)jComponent.getComponent(0)).setLabelFor(jButton);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)jComponent, gridBagConstraints);
        this.addHelpTopicId(jComponent, this.helpTopicId() + ".platform");
        JLabel jLabel = this.buildLabel("DEFINED_LOGINS_LIST_LABEL_TEXT");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        jPanel.add((Component)jLabel, gridBagConstraints);
        this.addAlignLeft(jLabel);
        JList jList = this.buildLoginSpecListBox();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        JScrollPane jScrollPane = new JScrollPane(jList);
        jScrollPane.getVerticalScrollBar().setUnitIncrement(10);
        jScrollPane.setMinimumSize(new Dimension(50, 100));
        jScrollPane.setPreferredSize(new Dimension(50, 100));
        jScrollPane.setMaximumSize(new Dimension(50, 100));
        jPanel.add((Component)jScrollPane, gridBagConstraints);
        jLabel.setLabelFor(jList);
        this.addHelpTopicId(jList, this.helpTopicId() + ".login");
        JButton jButton2 = this.buildButton("ADD_LOGIN_BUTTON_TEXT");
        jButton2.addActionListener(this.buildAddButtonActionListener());
        jButton2.setToolTipText(this.resourceRepository().getString("ADD_LOGIN_TOOL_TIP_TEXT"));
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        jPanel.add((Component)jButton2, gridBagConstraints);
        this.addAlignRight(jButton2);
        JButton jButton3 = this.buildButton("RENAME_LOGIN_BUTTON_TEXT");
        jButton3.setToolTipText(this.resourceRepository().getString("RENAME_LOGIN_TOOL_TIP_TEXT"));
        jButton3.setEnabled(false);
        jButton3.addActionListener(this.buildRenameButtonActionListener());
        this.loginSpecSelectionModel.addListSelectionListener(this.buildLoginSpecListSelectionListener(jButton3));
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        jPanel.add((Component)jButton3, gridBagConstraints);
        this.addAlignRight(jButton3);
        JButton jButton4 = this.buildButton("REMOVE_LOGIN_BUTTON_TEXT");
        jButton4.setToolTipText(this.resourceRepository().getString("REMOVE_LOGIN_TOOL_TIP_TEXT"));
        jButton4.setEnabled(false);
        jButton4.addActionListener(this.buildRemoveButtonActionListener());
        this.loginSpecSelectionModel.addListSelectionListener(this.buildLoginSpecListSelectionListener(jButton4));
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 19;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        jPanel.add((Component)jButton4, gridBagConstraints);
        this.addAlignRight(jButton4);
        this.selectedLoginSpecHolder = this.buildSelectedLoginSpecHolder(this.loginSpecSelectionModel);
        LoginSpecPanel loginSpecPanel = new LoginSpecPanel(this.selectedLoginSpecHolder, this.getApplicationContext());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 19;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        jPanel.add((Component)loginSpecPanel, gridBagConstraints);
        this.addPaneForAlignment(loginSpecPanel);
        this.addHelpTopicId(loginSpecPanel, this.helpTopicId() + ".loginInfo");
        JComponent jComponent2 = this.buildDevelopmentLoginWidgets();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        jPanel.add((Component)jComponent2, gridBagConstraints);
        this.addHelpTopicId(jComponent2, this.helpTopicId() + ".devLogin");
        JComponent jComponent3 = this.buildDeploymentLoginWidgets();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 19;
        gridBagConstraints.insets = new Insets(5, 0, 5, 0);
        jPanel.add((Component)jComponent3, gridBagConstraints);
        this.addHelpTopicId(jComponent3, this.helpTopicId() + ".depLogin");
        this.addHelpTopicId(jPanel, this.helpTopicId());
        return jPanel;
    }

    private JTextField buildPlatformNameTextField() {
        JTextField jTextField = new JTextField(this.buildPlatformNameDocument(), null, 1);
        jTextField.setEditable(false);
        return jTextField;
    }

    private Document buildPlatformNameDocument() {
        return new DocumentAdapter(this.buildPlatformNameHolder());
    }

    private PropertyValueModel buildPlatformNameHolder() {
        return new PropertyAspectAdapter(this.getSelectionHolder(), "databasePlatform"){

            protected Object getValueFromSubject() {
                return ((MWDatabase)this.subject).getDatabasePlatform().getName();
            }
        };
    }

    void promptToChangePlatform() {
        if (this.getNode().isDirty()) {
            int n = JOptionPane.showConfirmDialog(this.getWorkbenchContext().getCurrentWindow(), this.resourceRepository().getString("CHANGE_DATABASE_PLATFORM.message", StringTools.CR), this.resourceRepository().getString("CHANGE_DATABASE_PLATFORM.title"), 1, 2);
            if (n == 2) {
                return;
            }
            if (n == 0) {
                this.getNode().save(null, this.getWorkbenchContext());
            }
        }
        SimplePropertyValueModel simplePropertyValueModel = new SimplePropertyValueModel(this.getDatabase().getDatabasePlatform());
        DatabasePlatformChooserDialog databasePlatformChooserDialog = new DatabasePlatformChooserDialog(this.getWorkbenchContext(), simplePropertyValueModel);
        databasePlatformChooserDialog.show();
        if (databasePlatformChooserDialog.wasConfirmed()) {
            DatabasePlatform databasePlatform = (DatabasePlatform)simplePropertyValueModel.getValue();
            this.getDatabase().setDatabasePlatform(databasePlatform);
            this.preferences().put("database platform", databasePlatform.getName());
        }
    }

    private JList buildLoginSpecListBox() {
        JList jList = SwingComponentFactory.buildList(this.buildLoginSpecListModel());
        this.loginSpecSelectionModel = new ObjectListSelectionModel(jList.getModel());
        jList.setSelectionModel(this.loginSpecSelectionModel);
        jList.getSelectionModel().setSelectionMode(0);
        jList.setDoubleBuffered(true);
        jList.setCellRenderer(this.buildLoginSpecCellRenderer());
        return jList;
    }

    private ListModel buildLoginSpecListModel() {
        return new ListModelAdapter(this.buildLoginSpecsNameAdapter());
    }

    private ListValueModel buildLoginSpecsNameAdapter() {
        return new ItemPropertyListValueModelAdapter(this.buildSortedLoginSpecsAdapter(), "name");
    }

    private ListValueModel buildSortedLoginSpecsAdapter() {
        return new SortedListValueModelAdapter(this.buildLoginSpecsAdapter());
    }

    private CollectionValueModel buildLoginSpecsAdapter() {
        return new CollectionAspectAdapter(this.getSelectionHolder(), "loginSpecs"){

            protected Iterator getValueFromSubject() {
                return ((MWDatabase)this.subject).loginSpecs();
            }

            protected int sizeFromSubject() {
                return ((MWDatabase)this.subject).loginSpecsSize();
            }
        };
    }

    private ListCellRenderer buildLoginSpecCellRenderer() {
        return new SimpleListCellRenderer(){

            protected String buildText(Object object) {
                return object == null ? "" : ((MWLoginSpec)object).getName();
            }
        };
    }

    private PropertyValueModel buildSelectedLoginSpecHolder(ObjectListSelectionModel objectListSelectionModel) {
        SimplePropertyValueModel simplePropertyValueModel = new SimplePropertyValueModel(null);
        objectListSelectionModel.addListSelectionListener(this.buildLoginSpecListSelectionListener(objectListSelectionModel, simplePropertyValueModel));
        return simplePropertyValueModel;
    }

    private ListSelectionListener buildLoginSpecListSelectionListener(final ObjectListSelectionModel objectListSelectionModel, final PropertyValueModel propertyValueModel) {
        return new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                propertyValueModel.setValue(objectListSelectionModel.getSelectedValue());
            }
        };
    }

    private ListSelectionListener buildLoginSpecListSelectionListener(final JButton jButton) {
        return new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                jButton.setEnabled(DatabasePropertiesPage.this.loginSpecSelectionModel.getSelectedValue() != null);
            }
        };
    }

    private ActionListener buildAddButtonActionListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DatabasePropertiesPage.this.addLoginSpec();
            }
        };
    }

    void addLoginSpec() {
        NewNameDialog newNameDialog = this.buildLoginSpecDialog();
        newNameDialog.show();
        if (newNameDialog.wasCanceled()) {
            return;
        }
        String string = newNameDialog.getNewName();
        MWLoginSpec mWLoginSpec = this.getDatabase().addLoginSpec(string);
        this.loginSpecSelectionModel.setSelectedValue(mWLoginSpec);
    }

    private NewNameDialog buildLoginSpecDialog() {
        NewNameDialog.Builder builder = new NewNameDialog.Builder();
        builder.setExistingNames(this.getDatabase().loginSpecNames());
        builder.setOriginalName(NameTools.uniqueNameFor((String)this.resourceRepository().getString("NEW_LOGIN_NAME"), (Iterator)this.getDatabase().loginSpecNames()));
        builder.setTextFieldDescription(this.resourceRepository().getString("NEW_LOGIN_DIALOG.message"));
        builder.setTitle(this.resourceRepository().getString("NEW_LOGIN_DIALOG.title"));
        builder.setHelpTopicId("dialog.newLogin");
        return builder.buildDialog(this.getWorkbenchContext());
    }

    private ActionListener buildRemoveButtonActionListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DatabasePropertiesPage.this.removeLoginSpec();
            }
        };
    }

    void removeLoginSpec() {
        int n = JOptionPane.showConfirmDialog(this, this.resourceRepository().getString("REMOVE_LOGIN_INFO_DIALOG.message"), this.resourceRepository().getString("REMOVE_LOGIN_INFO_DIALOG.title"), 0);
        if (n == 1) {
            return;
        }
        this.getDatabase().removeLoginSpec((MWLoginSpec)this.loginSpecSelectionModel.getSelectedValue());
    }

    private ActionListener buildRenameButtonActionListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DatabasePropertiesPage.this.renameLoginSpec();
            }
        };
    }

    void renameLoginSpec() {
        MWLoginSpec mWLoginSpec = (MWLoginSpec)this.loginSpecSelectionModel.getSelectedValue();
        NewNameDialog.Builder builder = new NewNameDialog.Builder();
        builder.setExistingNames(this.getDatabase().loginSpecNames());
        builder.setOriginalName(mWLoginSpec.getName());
        builder.setTextFieldDescription(this.resourceRepository().getString("RENAME_LOGIN_INFO_DIALOG.message"));
        builder.setTitle(this.resourceRepository().getString("RENAME_LOGIN_INFO_DIALOG.title", mWLoginSpec.getName()));
        builder.setHelpTopicId("dialog.loginInfoRename");
        NewNameDialog newNameDialog = builder.buildDialog(this.getWorkbenchContext());
        newNameDialog.setVisible(true);
        if (newNameDialog.wasConfirmed()) {
            mWLoginSpec.setName(newNameDialog.getNewName());
        }
    }

    private JComponent buildDevelopmentLoginWidgets() {
        return this.buildLabeledComboBox("DEVELOPMENT_LOGIN_LABEL", new ComboBoxModelAdapter(this.buildSortedLoginsHolder(), this.buildDevelopmentLoginAdapter()), this.buildLoginSpecCellRenderer());
    }

    private ListValueModel buildSortedLoginsHolder() {
        return new SortedListValueModelAdapter(this.buildAllLoginsAdapter());
    }

    private CollectionValueModel buildAllLoginsAdapter() {
        return new CollectionAspectAdapter(this.getSelectionHolder(), "loginSpecs"){

            protected Iterator getValueFromSubject() {
                return ((MWDatabase)this.subject).loginSpecs();
            }

            protected int sizeFromSubject() {
                return ((MWDatabase)this.subject).loginSpecsSize();
            }
        };
    }

    private PropertyValueModel buildDevelopmentLoginAdapter() {
        PropertyAspectAdapter propertyAspectAdapter = new PropertyAspectAdapter(this.getSelectionHolder(), "developmentLoginSpec"){

            protected Object getValueFromSubject() {
                return ((MWDatabase)this.subject).getDevelopmentLoginSpec();
            }

            protected void setValueOnSubject(Object object) {
                ((MWDatabase)this.subject).setDevelopmentLoginSpec((MWLoginSpec)object);
            }
        };
        return new ValuePropertyPropertyValueModelAdapter((PropertyValueModel)propertyAspectAdapter, "name");
    }

    private JComponent buildDeploymentLoginWidgets() {
        return this.buildLabeledComboBox("DEPLOYMENT_LOGIN_LABEL", new ComboBoxModelAdapter(this.buildAllLoginsAdapter(), this.buildDeploymentLoginAdapter()), this.buildLoginSpecCellRenderer());
    }

    private PropertyValueModel buildDeploymentLoginAdapter() {
        PropertyAspectAdapter propertyAspectAdapter = new PropertyAspectAdapter(this.getSelectionHolder(), "deploymentLoginSpec"){

            protected Object getValueFromSubject() {
                return ((MWDatabase)this.subject).getDeploymentLoginSpec();
            }

            protected void setValueOnSubject(Object object) {
                ((MWDatabase)this.subject).setDeploymentLoginSpec((MWLoginSpec)object);
            }
        };
        return new ValuePropertyPropertyValueModelAdapter((PropertyValueModel)propertyAspectAdapter, "name");
    }
}

