/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.db;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import javax.swing.Action;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.eclipse.persistence.tools.workbench.framework.action.AbstractFrameworkAction;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.resources.ResourceRepository;
import org.eclipse.persistence.tools.workbench.framework.ui.dialog.NewNameDialog;
import org.eclipse.persistence.tools.workbench.framework.ui.view.ScrollablePropertiesPage;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWReference;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWTable;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.common.cell.TableCellRendererAdapter;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.db.ColumnPairsPanel;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.db.NewTableReferenceDialog;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.project.relational.RelationalProjectComponentFactory;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ItemPropertyListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SimplePropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SortedListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.ValuePropertyPropertyValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ColumnAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ComboBoxModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ListModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ObjectListSelectionModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.TableModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.cell.AdaptableListCellRenderer;
import org.eclipse.persistence.tools.workbench.uitools.cell.CheckBoxTableCellRenderer;
import org.eclipse.persistence.tools.workbench.uitools.cell.ComboBoxTableCellRenderer;
import org.eclipse.persistence.tools.workbench.uitools.cell.TableCellEditorAdapter;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.Model;

public class ReferencesPropertiesPage
extends ScrollablePropertiesPage {
    private ListValueModel targetTablesHolder;
    ListValueModel sortedReferencesAdapter;
    private TableModel tableModel;
    private ObjectListSelectionModel rowSelectionModel;
    private PropertyValueModel selectedReferenceHolder;
    private Action removeAction;
    private Action renameAction;
    JTable table;

    public ReferencesPropertiesPage(PropertyValueModel propertyValueModel, WorkbenchContextHolder workbenchContextHolder) {
        super(propertyValueModel, workbenchContextHolder);
    }

    protected void initialize(PropertyValueModel propertyValueModel) {
        super.initialize(propertyValueModel);
        this.targetTablesHolder = RelationalProjectComponentFactory.buildExtendedTablesHolder(this.getSelectionHolder());
        this.sortedReferencesAdapter = this.buildSortedReferencesAdapter();
        this.tableModel = this.buildTableModel();
        this.selectedReferenceHolder = this.buildSelectedReferenceHolder();
        this.rowSelectionModel = this.buildRowSelectionModel();
        this.getSelectionHolder().addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (ReferencesPropertiesPage.this.table.isEditing()) {
                    ReferencesPropertiesPage.this.table.getCellEditor().cancelCellEditing();
                }
                if (ReferencesPropertiesPage.this.sortedReferencesAdapter.size() > 0) {
                    ReferencesPropertiesPage.this.setSelectedReference((MWReference)ReferencesPropertiesPage.this.sortedReferencesAdapter.getItem(0));
                }
            }
        });
    }

    protected String helpTopicId() {
        return "table.references";
    }

    private ListValueModel buildSortedReferencesAdapter() {
        return new SortedListValueModelAdapter(this.buildReferenceNameAdapter());
    }

    private ListValueModel buildReferenceNameAdapter() {
        return new ItemPropertyListValueModelAdapter(this.buildReferencesAdapter(), "name");
    }

    private CollectionValueModel buildReferencesAdapter() {
        return new CollectionAspectAdapter(this.getSelectionHolder(), "references"){

            protected Iterator getValueFromSubject() {
                return ((MWTable)this.subject).references();
            }

            protected int sizeFromSubject() {
                return ((MWTable)this.subject).referencesSize();
            }
        };
    }

    private TableModel buildTableModel() {
        return new TableModelAdapter(this.sortedReferencesAdapter, this.buildColumnAdapter());
    }

    private ColumnAdapter buildColumnAdapter() {
        return new ReferencesColumnAdapter(this.resourceRepository());
    }

    private PropertyValueModel buildSelectedReferenceHolder() {
        return new SimplePropertyValueModel(null);
    }

    private ObjectListSelectionModel buildRowSelectionModel() {
        ObjectListSelectionModel objectListSelectionModel = new ObjectListSelectionModel(new ListModelAdapter(this.sortedReferencesAdapter));
        objectListSelectionModel.addListSelectionListener(this.buildRowSelectionListener());
        objectListSelectionModel.setSelectionMode(0);
        return objectListSelectionModel;
    }

    private ListSelectionListener buildRowSelectionListener() {
        return new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    ReferencesPropertiesPage.this.rowSelectionChanged();
                }
            }
        };
    }

    void rowSelectionChanged() {
        Object object = this.rowSelectionModel.getSelectedValue();
        this.selectedReferenceHolder.setValue(object);
        boolean bl = object != null;
        this.removeAction.setEnabled(bl);
        this.renameAction.setEnabled(bl);
    }

    protected Component buildPage() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel2 = this.buildButtonPanel();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        jPanel.add((Component)jPanel2, gridBagConstraints);
        this.table = this.buildTable();
        JScrollPane jScrollPane = new JScrollPane(this.table);
        jScrollPane.getViewport().setPreferredSize(new Dimension(50, 50));
        jScrollPane.getViewport().setBackground(this.table.getBackground());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.insets = new Insets(5, 5, 5, 0);
        jPanel.add((Component)jScrollPane, gridBagConstraints);
        ColumnPairsPanel columnPairsPanel = this.buildFieldAssociationsPanel();
        this.addHelpTopicId(columnPairsPanel, this.helpTopicId() + ".associations");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        jPanel.add((Component)columnPairsPanel, gridBagConstraints);
        this.addPaneForAlignment(columnPairsPanel);
        this.addHelpTopicId(jPanel, this.helpTopicId());
        return jPanel;
    }

    private JTable buildTable() {
        JTable jTable = SwingComponentFactory.buildTable(this.tableModel, this.rowSelectionModel);
        jTable.getTableHeader().setReorderingAllowed(false);
        int n = 20;
        TableColumn tableColumn = jTable.getColumnModel().getColumn(1);
        ComboBoxTableCellRenderer comboBoxTableCellRenderer = this.buildTargetTableComboBoxRenderer();
        tableColumn.setCellRenderer(comboBoxTableCellRenderer);
        tableColumn.setCellEditor(new TableCellEditorAdapter(this.buildTargetTableComboBoxRenderer()));
        n = Math.max(n, comboBoxTableCellRenderer.getPreferredHeight());
        tableColumn = jTable.getColumnModel().getColumn(2);
        CheckBoxTableCellRenderer checkBoxTableCellRenderer = new CheckBoxTableCellRenderer();
        tableColumn.setCellRenderer(checkBoxTableCellRenderer);
        tableColumn.setCellEditor(new TableCellEditorAdapter(new CheckBoxTableCellRenderer()));
        n = Math.max(n, checkBoxTableCellRenderer.getPreferredHeight());
        jTable.setRowHeight(n);
        return jTable;
    }

    private JPanel buildButtonPanel() {
        JPanel jPanel = new JPanel(new GridLayout(0, 1, 0, 5));
        JButton jButton = this.buildAddButton();
        jPanel.add(jButton);
        this.addAlignRight(jButton);
        jButton = this.buildRemoveButton();
        jPanel.add(jButton);
        this.addAlignRight(jButton);
        jButton = this.buildRenameButton();
        jPanel.add(jButton);
        this.addAlignRight(jButton);
        return jPanel;
    }

    private ColumnPairsPanel buildFieldAssociationsPanel() {
        return new ColumnPairsPanel(this.getWorkbenchContextHolder(), this.selectedReferenceHolder);
    }

    private JButton buildAddButton() {
        return new JButton(this.buildAddAction());
    }

    private Action buildAddAction() {
        AbstractFrameworkAction abstractFrameworkAction = new AbstractFrameworkAction(this.getApplicationContext()){

            protected void initialize() {
                this.initializeText("ADD_REFERENCE_BUTTON_TEXT");
                this.initializeMnemonic("ADD_REFERENCE_BUTTON_TEXT");
            }

            public void actionPerformed(ActionEvent actionEvent) {
                ReferencesPropertiesPage.this.addReference();
            }
        };
        abstractFrameworkAction.setEnabled(true);
        return abstractFrameworkAction;
    }

    void addReference() {
        if (this.table.isEditing()) {
            this.table.getCellEditor().stopCellEditing();
        }
        ArrayList arrayList = new ArrayList(this.table().getDatabase().tablesSize());
        CollectionTools.addAll(arrayList, (Iterator)this.table().getDatabase().tables());
        CollectionTools.sort(arrayList);
        NewTableReferenceDialog newTableReferenceDialog = NewTableReferenceDialog.buildReferenceDialogDisallowSourceTableSelection(this.getWorkbenchContext(), Collections.singletonList(this.selection()), arrayList);
        newTableReferenceDialog.setSourceTable(this.table());
        newTableReferenceDialog.setTargetTable((MWTable)arrayList.get(0));
        newTableReferenceDialog.show();
        if (newTableReferenceDialog.wasCanceled()) {
            return;
        }
        MWReference mWReference = this.table().addReference(newTableReferenceDialog.getReferenceName(), newTableReferenceDialog.getTargetTable());
        mWReference.setOnDatabase(newTableReferenceDialog.isOnDatabase());
        this.setSelectedReference(mWReference);
    }

    private JButton buildRemoveButton() {
        return new JButton(this.buildRemoveAction());
    }

    private Action buildRemoveAction() {
        this.removeAction = new AbstractFrameworkAction(this.getApplicationContext()){

            protected void initialize() {
                this.initializeText("REMOVE_REFERENCE_BUTTON_TEXT");
                this.initializeMnemonic("REMOVE_REFERENCE_BUTTON_TEXT");
            }

            public void actionPerformed(ActionEvent actionEvent) {
                ReferencesPropertiesPage.this.removeReference();
            }
        };
        this.removeAction.setEnabled(false);
        return this.removeAction;
    }

    void removeReference() {
        MWReference mWReference;
        int n;
        if (this.table.isEditing()) {
            this.table.getCellEditor().stopCellEditing();
        }
        if ((n = JOptionPane.showConfirmDialog(this.getWorkbenchContext().getCurrentWindow(), this.resourceRepository().getString("REMOVE_REFERENCES_WARNING_DIALOG.message"), this.resourceRepository().getString("REMOVE_REFERENCES_WARNING_DIALOG.title"), 0, 3)) == 0 && (mWReference = this.selectedReference()) != null) {
            this.table().removeReference(mWReference);
        }
    }

    private JButton buildRenameButton() {
        return new JButton(this.buildRenameAction());
    }

    private Action buildRenameAction() {
        this.renameAction = new AbstractFrameworkAction(this.getApplicationContext()){

            protected void initialize() {
                this.initializeText("RENAME_REFERENCE_BUTTON_TEXT");
                this.initializeMnemonic("RENAME_REFERENCE_BUTTON_TEXT");
            }

            public void actionPerformed(ActionEvent actionEvent) {
                ReferencesPropertiesPage.this.renameReference();
            }
        };
        this.renameAction.setEnabled(false);
        return this.renameAction;
    }

    void renameReference() {
        String string;
        MWReference mWReference = this.selectedReference();
        if (mWReference != null && (string = this.getReferenceNameFromUser(mWReference.getName(), "RENAME_REFERENCE_DIALOG")) != null) {
            mWReference.setName(string);
            this.setSelectedReference(mWReference);
        }
    }

    private String getReferenceNameFromUser(String string, String string2) {
        NewNameDialog newNameDialog = this.buildNewNameDialog(string, string2);
        newNameDialog.show();
        return newNameDialog.wasConfirmed() ? newNameDialog.getNewName() : null;
    }

    private NewNameDialog buildNewNameDialog(String string, String string2) {
        NewNameDialog.Builder builder = new NewNameDialog.Builder();
        builder.setExistingNames(this.table().referenceNames());
        builder.setOriginalName(string);
        builder.setTextFieldDescription(this.resourceRepository().getString(string2 + ".message"));
        builder.setTitle(this.resourceRepository().getString(string2 + ".title"));
        builder.setHelpTopicId("dialog.referenceRename");
        return builder.buildDialog(this.getWorkbenchContext());
    }

    private ComboBoxTableCellRenderer buildTargetTableComboBoxRenderer() {
        return new ComboBoxTableCellRenderer(this.buildTargetTableComboBoxModel(), this.buildTargetTableListCellRenderer());
    }

    private ComboBoxModel buildTargetTableComboBoxModel() {
        return new ComboBoxModelAdapter(this.targetTablesHolder, (PropertyValueModel)new SimplePropertyValueModel());
    }

    private ListCellRenderer buildTargetTableListCellRenderer() {
        return new AdaptableListCellRenderer(new TableCellRendererAdapter(this.resourceRepository()));
    }

    private MWReference selectedReference() {
        if (this.rowSelectionModel.isSelectionEmpty()) {
            return null;
        }
        return (MWReference)this.rowSelectionModel.getSelectedValue();
    }

    void setSelectedReference(MWReference mWReference) {
        this.rowSelectionModel.setSelectedValue(mWReference);
    }

    private MWTable table() {
        return (MWTable)this.getSelectionHolder().getValue();
    }

    public static class ReferencesColumnAdapter
    implements ColumnAdapter {
        private ResourceRepository resourceRepository;
        public static final int COLUMN_COUNT = 3;
        public static final int REFERENCE_NAME_COLUMN = 0;
        public static final int TARGET_TABLE_COLUMN = 1;
        public static final int ON_DATABASE_COLUMN = 2;
        private static final String[] COLUMN_NAME_KEYS = new String[]{"REFERENCE_NAME_COLUMN_HEADER", "TARGET_TABLE_COLUMN_HEADER", "ON_DATABASE_COLUMN_HEADER"};

        protected ReferencesColumnAdapter(ResourceRepository resourceRepository) {
            this.resourceRepository = resourceRepository;
        }

        public int getColumnCount() {
            return 3;
        }

        public String getColumnName(int n) {
            return this.resourceRepository.getString(COLUMN_NAME_KEYS[n]);
        }

        public Class getColumnClass(int n) {
            switch (n) {
                case 0: {
                    return Object.class;
                }
                case 1: {
                    return Object.class;
                }
                case 2: {
                    return Boolean.class;
                }
            }
            return Object.class;
        }

        public boolean isColumnEditable(int n) {
            return n != 0;
        }

        public PropertyValueModel[] cellModels(Object object) {
            MWReference mWReference = (MWReference)object;
            PropertyValueModel[] propertyValueModelArray = new PropertyValueModel[]{this.buildReferenceNameAdapter(mWReference), this.buildTargetTableAdapter(mWReference), this.buildOnDatabaseAdapter(mWReference)};
            return propertyValueModelArray;
        }

        private PropertyValueModel buildReferenceNameAdapter(MWReference mWReference) {
            return new PropertyAspectAdapter("name", (Model)mWReference){

                protected Object getValueFromSubject() {
                    return ((MWReference)this.subject).getName();
                }

                protected void setValueOnSubject(Object object) {
                    ((MWReference)this.subject).setName((String)object);
                }
            };
        }

        private PropertyValueModel buildTargetTableAdapter(MWReference mWReference) {
            PropertyAspectAdapter propertyAspectAdapter = new PropertyAspectAdapter("targetTable", (Model)mWReference){

                protected Object getValueFromSubject() {
                    return ((MWReference)this.subject).getTargetTable();
                }

                protected void setValueOnSubject(Object object) {
                    ((MWReference)this.subject).setTargetTable((MWTable)object);
                }
            };
            return new ValuePropertyPropertyValueModelAdapter((PropertyValueModel)propertyAspectAdapter, "qualifiedName");
        }

        private PropertyValueModel buildOnDatabaseAdapter(MWReference mWReference) {
            return new PropertyAspectAdapter("onDatabase", (Model)mWReference){

                protected Object getValueFromSubject() {
                    return ((MWReference)this.subject).isOnDatabase();
                }

                protected void setValueOnSubject(Object object) {
                    ((MWReference)this.subject).setOnDatabase(((Boolean)object).booleanValue());
                }
            };
        }
    }
}

