/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.ButtonModel;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.SpinnerDateModel;
import javax.swing.SpinnerNumberModel;
import org.eclipse.persistence.tools.workbench.framework.context.ApplicationContext;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractSubjectPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWCacheExpiry;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWCachingPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptorCacheExpiry;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.UiDescriptorBundle;
import org.eclipse.persistence.tools.workbench.uitools.ComponentEnabler;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.TransformationPropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.CheckBoxModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.DateSpinnerModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.NumberSpinnerModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.RadioButtonModelAdapter;

final class CacheExpiryPanel
extends AbstractSubjectPanel {
    private PropertyValueModel cacheExpiryHolder;
    private PropertyValueModel cacheExpiryTypeHolder;

    CacheExpiryPanel(ApplicationContext applicationContext, PropertyValueModel propertyValueModel, String string) {
        super((ValueModel)propertyValueModel, applicationContext.buildExpandedResourceRepositoryContext(UiDescriptorBundle.class));
        this.addHelpTopicId(this, string);
    }

    protected void initialize(ValueModel valueModel) {
        super.initialize(valueModel);
        this.cacheExpiryHolder = this.buildCacheExpiryAdapter();
        this.cacheExpiryTypeHolder = this.buildCacheExpiryTypeAdapter();
    }

    private PropertyValueModel buildCacheExpiryAdapter() {
        return new PropertyAspectAdapter(this.getSubjectHolder(), "cacheExpiry"){

            protected Object getValueFromSubject() {
                return ((MWCachingPolicy)this.subject).getCacheExpiry();
            }

            protected void setValueOnSubject(Object object) {
            }
        };
    }

    private PropertyValueModel buildCacheExpiryTypeAdapter() {
        return new PropertyAspectAdapter(this.cacheExpiryHolder, "expiryType"){

            protected Object getValueFromSubject() {
                return ((MWCacheExpiry)this.subject).getExpiryType();
            }

            protected void setValueOnSubject(Object object) {
                ((MWCacheExpiry)this.subject).setExpiryType((String)object);
            }
        };
    }

    protected void initializeLayout() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setBorder(BorderFactory.createCompoundBorder(this.buildTitledBorder("CACHING_POLICY_CACHE_EXPIRY"), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        JCheckBox jCheckBox = this.buildCheckBox("CACHING_POLICY_PROJECT_DEFAULT_CHECK_BOX", this.buildProjectDefaultCheckBoxAdapter());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)jCheckBox, gridBagConstraints);
        JRadioButton jRadioButton = this.buildRadioButton("CACHING_POLICY_NO_EXPIRY", this.buildNoCacheExpiryRadioButtonAdapter());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.add((Component)jRadioButton, gridBagConstraints);
        JRadioButton jRadioButton2 = this.buildRadioButton("CACHING_POLICY_TIME_TO_LIVE_EXPIRY", this.buildTimeToLiveExpiryRadioButtonAdapter());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)jRadioButton2, gridBagConstraints);
        JLabel jLabel = this.buildLabel("CACHING_POLICY_TIME_TO_LIVE_EXPIRY_PREFIX_LABEL");
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 25, 0, 0);
        this.add((Component)jLabel, gridBagConstraints);
        JSpinner jSpinner = SwingComponentFactory.buildSpinnerNumber(this.buildTimeToLiveExpirySpinnerAdapter());
        SwingComponentFactory.attachDateSpinnerCommiter(jSpinner, this.cacheExpiryHolder);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.add((Component)jSpinner, gridBagConstraints);
        jLabel.setLabelFor(jSpinner);
        JLabel jLabel2 = this.buildLabel("CACHING_POLICY_TIME_TO_LIVE_EXPIRY_POSTFIX_LABEL");
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.add((Component)jLabel2, gridBagConstraints);
        this.buildTimeToLiveExpiryComponentEnabler(new Component[]{jSpinner, jLabel, jLabel2});
        JRadioButton jRadioButton3 = this.buildRadioButton("CACHING_POLICY_DAILY_EXPIRY", this.buildDailyExpiryRadioButtonAdapter());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)jRadioButton3, gridBagConstraints);
        jLabel2.setLabelFor(jRadioButton3);
        JLabel jLabel3 = this.buildLabel("CACHING_POLICY_DAILY_EXPIRY_PREFIX_LABEL");
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 25, 0, 0);
        this.add((Component)jLabel3, gridBagConstraints);
        SpinnerDateModel spinnerDateModel = this.buildDailyExpirySpinnerAdapter();
        JSpinner jSpinner2 = this.buildSpinnerDate(spinnerDateModel);
        jSpinner2.setEditor(new JSpinner.DateEditor(jSpinner2, "HH : mm : ss"));
        SwingComponentFactory.attachDateSpinnerCommiter(jSpinner2, this.cacheExpiryHolder);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 5, 5, 0);
        this.add((Component)jSpinner2, gridBagConstraints);
        jLabel3.setLabelFor(jSpinner2);
        this.buildDailyExpiryComponentEnabler(new Component[]{jSpinner2, jLabel3});
        JCheckBox jCheckBox2 = this.buildCheckBox("CACHING_POLICY_UPDATE_READ_TIME_ON_UPDATE", this.buildUpdateReadTimeOnUpdateCheckBoxAdapter());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(10, 0, 5, 0);
        this.add((Component)jCheckBox2, gridBagConstraints);
        this.buildUpdateReadTimeOnUpdateComponentEnabler(jCheckBox2);
    }

    private ButtonModel buildProjectDefaultCheckBoxAdapter() {
        return new CheckBoxModelAdapter(this.buildProjectDefaultAdapter());
    }

    private PropertyValueModel buildProjectDefaultAdapter() {
        return new TransformationPropertyValueModel(this.cacheExpiryHolder){

            protected Object transform(Object object) {
                return object instanceof MWDescriptorCacheExpiry ? Boolean.FALSE : Boolean.TRUE;
            }

            protected Object reverseTransform(Object object) {
                MWCachingPolicy mWCachingPolicy = (MWCachingPolicy)CacheExpiryPanel.this.getSubjectHolder().getValue();
                if (mWCachingPolicy == null) {
                    return null;
                }
                mWCachingPolicy.setUseProjectDefaultCacheExpiry(((Boolean)object).booleanValue());
                return mWCachingPolicy.getCacheExpiry();
            }
        };
    }

    private ButtonModel buildNoCacheExpiryRadioButtonAdapter() {
        return new RadioButtonModelAdapter(this.cacheExpiryTypeHolder, "No Expiry");
    }

    private ButtonModel buildTimeToLiveExpiryRadioButtonAdapter() {
        return new RadioButtonModelAdapter(this.cacheExpiryTypeHolder, "Time to Live Expiry");
    }

    private SpinnerNumberModel buildTimeToLiveExpirySpinnerAdapter() {
        return new NumberSpinnerModelAdapter(this.buildTimeToLiveAdapter(), new Long(0L), new Long(Long.MAX_VALUE), new Long(1L), new Long(0L));
    }

    private PropertyValueModel buildTimeToLiveAdapter() {
        return new PropertyAspectAdapter(this.cacheExpiryHolder, "timeToLiveExpiry"){

            protected Object getValueFromSubject() {
                return ((MWCacheExpiry)this.subject).getTimeToLiveExpiry();
            }

            protected void setValueOnSubject(Object object) {
                ((MWCacheExpiry)this.subject).setTimeToLiveExpiry((Long)object);
            }
        };
    }

    private ButtonModel buildDailyExpiryRadioButtonAdapter() {
        return new RadioButtonModelAdapter(this.cacheExpiryTypeHolder, "Daily Expiry");
    }

    private SpinnerDateModel buildDailyExpirySpinnerAdapter() {
        Date date = new Date(0, 0, 1, 0, 0, 0);
        Date date2 = new Date(300, 0, 1, 0, 0, 0);
        return new DateSpinnerModelAdapter(this.buildDailyExpiryHolder(), date, date2, 12, date);
    }

    private PropertyValueModel buildDailyExpiryHolder() {
        return new PropertyAspectAdapter(this.cacheExpiryHolder, "dailyExpiryTime"){

            protected Object getValueFromSubject() {
                return ((MWCacheExpiry)this.subject).getDailyExpiryTime();
            }

            protected void setValueOnSubject(Object object) {
                ((MWCacheExpiry)this.subject).setDailyExpiryTime((Date)object);
            }
        };
    }

    private ButtonModel buildUpdateReadTimeOnUpdateCheckBoxAdapter() {
        return new CheckBoxModelAdapter(this.buildUpdateReadTimeOnUpdateHolder());
    }

    private PropertyValueModel buildUpdateReadTimeOnUpdateHolder() {
        return new PropertyAspectAdapter(this.cacheExpiryHolder, "updateReadTimeOnUpdate"){

            protected Object getValueFromSubject() {
                return ((MWCacheExpiry)this.subject).getUpdateReadTimeOnUpdate();
            }

            protected void setValueOnSubject(Object object) {
                ((MWCacheExpiry)this.subject).setUpdateReadTimeOnUpdate(((Boolean)object).booleanValue());
            }
        };
    }

    private ComponentEnabler buildUpdateReadTimeOnUpdateComponentEnabler(Component component) {
        TransformationPropertyValueModel transformationPropertyValueModel = new TransformationPropertyValueModel(this.cacheExpiryTypeHolder){

            protected Object transform(Object object) {
                return object != "No Expiry";
            }
        };
        return new ComponentEnabler((ValueModel)transformationPropertyValueModel, component);
    }

    private ComponentEnabler buildTimeToLiveExpiryComponentEnabler(Component[] componentArray) {
        TransformationPropertyValueModel transformationPropertyValueModel = new TransformationPropertyValueModel(this.cacheExpiryTypeHolder){

            protected Object transform(Object object) {
                return object == "Time to Live Expiry";
            }
        };
        return new ComponentEnabler((ValueModel)transformationPropertyValueModel, componentArray);
    }

    private ComponentEnabler buildDailyExpiryComponentEnabler(Component[] componentArray) {
        TransformationPropertyValueModel transformationPropertyValueModel = new TransformationPropertyValueModel(this.cacheExpiryTypeHolder){

            protected Object transform(Object object) {
                return object == "Daily Expiry";
            }
        };
        return new ComponentEnabler((ValueModel)transformationPropertyValueModel, componentArray);
    }
}

