/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ListIterator;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.chooser.DefaultListChooser;
import org.eclipse.persistence.tools.workbench.framework.ui.chooser.DefaultListChooserDialog;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClassAttribute;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWMethod;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.common.cell.MethodCellRendererAdapter;
import org.eclipse.persistence.tools.workbench.uitools.ComponentEnabler;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.TransformationPropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.cell.AdaptableListCellRenderer;
import org.eclipse.persistence.tools.workbench.uitools.chooser.ListChooser;
import org.eclipse.persistence.tools.workbench.uitools.swing.CachingComboBoxModel;
import org.eclipse.persistence.tools.workbench.uitools.swing.ExtendedComboBoxModel;
import org.eclipse.persistence.tools.workbench.uitools.swing.IndirectComboBoxModel;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.string.StringConverter;

final class ClassAttributeAccessorsPanel
extends AbstractPanel {
    private ValueModel attributeHolder;
    private PropertyValueModel attributeTypeHolder;
    private PropertyValueModel attributeValueTypeHolder;
    private PropertyValueModel attributeTypeDimensionalityHolder;
    private JLabel getMethodLabel;
    private JLabel setMethodLabel;
    private JButton generateGetSetMethodsButton;
    private JPanel valueGetSetMethodsPanel;
    private JLabel valueGetMethodLabel;
    private JLabel valueSetMethodLabel;
    private JButton generateValueGetSetMethodsButton;
    private JPanel addRemoveMethodsPanel;
    private JLabel addMethodLabel;
    private JLabel removeMethodLabel;
    private JButton generateAddRemoveMethodsButton;
    private ListCellRenderer methodListCellRenderer;

    protected ClassAttributeAccessorsPanel(ValueModel valueModel, WorkbenchContextHolder workbenchContextHolder) {
        super(workbenchContextHolder);
        this.attributeHolder = valueModel;
        PropertyChangeListener propertyChangeListener = this.buildAttributeTypeDeclarationListener();
        this.attributeTypeHolder = this.buildAttributeTypeAdapter();
        this.attributeTypeHolder.addPropertyChangeListener("value", propertyChangeListener);
        this.attributeTypeDimensionalityHolder = this.buildAttributeDimensionalityAdapter();
        this.attributeTypeDimensionalityHolder.addPropertyChangeListener("value", propertyChangeListener);
        this.attributeValueTypeHolder = this.buildAttributeValueTypeAdapter();
        this.attributeValueTypeHolder.addPropertyChangeListener("value", this.buildAttributeValueTypeListener());
        this.initializeLayout();
    }

    private PropertyChangeListener buildAttributeTypeDeclarationListener() {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                ClassAttributeAccessorsPanel.this.updateGetAndSetMethodLabels();
                ClassAttributeAccessorsPanel.this.updateAccessorPanelVisibility();
            }
        };
    }

    private PropertyValueModel buildAttributeTypeAdapter() {
        return new PropertyAspectAdapter(this.attributeHolder, "type"){

            protected Object getValueFromSubject() {
                return ((MWClassAttribute)this.subject).getType();
            }
        };
    }

    private PropertyValueModel buildAttributeDimensionalityAdapter() {
        return new PropertyAspectAdapter(this.attributeHolder, "dimensionality"){

            protected Object getValueFromSubject() {
                return new Integer(((MWClassAttribute)this.subject).getDimensionality());
            }
        };
    }

    private PropertyValueModel buildAttributeValueTypeAdapter() {
        return new PropertyAspectAdapter(this.attributeHolder, "valueType"){

            protected Object getValueFromSubject() {
                return ((MWClassAttribute)this.subject).getValueType();
            }
        };
    }

    private PropertyChangeListener buildAttributeValueTypeListener() {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                ClassAttributeAccessorsPanel.this.updateAccessorPanelVisibility();
            }
        };
    }

    private void initializeLayout() {
        this.setBorder(BorderFactory.createEmptyBorder());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        ArrayList<JComponent> arrayList = new ArrayList<JComponent>();
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder((String)null));
        this.getMethodLabel = SwingComponentFactory.buildLabel("GET_METHOD_LABEL", this.resourceRepository());
        arrayList.add(this.getMethodLabel);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        jPanel.add((Component)this.getMethodLabel, gridBagConstraints);
        ListChooser listChooser = this.buildGetMethodListChooser();
        arrayList.add(listChooser);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        jPanel.add((Component)listChooser, gridBagConstraints);
        this.setMethodLabel = SwingComponentFactory.buildLabel("SET_METHOD_LABEL", this.resourceRepository());
        arrayList.add(this.setMethodLabel);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        jPanel.add((Component)this.setMethodLabel, gridBagConstraints);
        ListChooser listChooser2 = this.buildSetMethodListChooser();
        arrayList.add(listChooser2);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        jPanel.add((Component)listChooser2, gridBagConstraints);
        this.generateGetSetMethodsButton = SwingComponentFactory.buildButton("GENERATE_METHODS_BUTTON_TEXT", this.resourceRepository());
        this.generateGetSetMethodsButton.addActionListener(this.buildGenerateGetSetMethodsActionListener());
        arrayList.add(this.generateGetSetMethodsButton);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.insets = new Insets(10, 5, 5, 5);
        jPanel.add((Component)this.generateGetSetMethodsButton, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 19;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)jPanel, gridBagConstraints);
        this.valueGetSetMethodsPanel = new JPanel(new GridBagLayout());
        this.valueGetSetMethodsPanel.setBorder(BorderFactory.createTitledBorder((String)null));
        this.valueGetMethodLabel = SwingComponentFactory.buildLabel("VALUE_GET_METHOD_LABEL", this.resourceRepository());
        arrayList.add(this.valueGetMethodLabel);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.valueGetSetMethodsPanel.add((Component)this.valueGetMethodLabel, gridBagConstraints);
        ListChooser listChooser3 = this.buildValueGetMethodListChooser();
        arrayList.add(listChooser3);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.valueGetSetMethodsPanel.add((Component)listChooser3, gridBagConstraints);
        this.valueSetMethodLabel = SwingComponentFactory.buildLabel("VALUE_SET_METHOD_LABEL", this.resourceRepository());
        arrayList.add(this.valueSetMethodLabel);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.valueGetSetMethodsPanel.add((Component)this.valueSetMethodLabel, gridBagConstraints);
        ListChooser listChooser4 = this.buildValueSetMethodListChooser();
        arrayList.add(listChooser4);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.valueGetSetMethodsPanel.add((Component)listChooser4, gridBagConstraints);
        this.generateValueGetSetMethodsButton = SwingComponentFactory.buildButton("GENERATE_METHODS_BUTTON_TEXT", this.resourceRepository());
        this.generateValueGetSetMethodsButton.addActionListener(this.buildGenerateValueGetSetMethodsActionListener());
        arrayList.add(this.generateValueGetSetMethodsButton);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.insets = new Insets(10, 5, 5, 5);
        this.valueGetSetMethodsPanel.add((Component)this.generateValueGetSetMethodsButton, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 19;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.valueGetSetMethodsPanel, gridBagConstraints);
        this.setPanelVisible(this.valueGetSetMethodsPanel, false);
        this.addRemoveMethodsPanel = new JPanel(new GridBagLayout());
        this.addRemoveMethodsPanel.setBorder(BorderFactory.createTitledBorder((String)null));
        this.addMethodLabel = SwingComponentFactory.buildLabel("ADD_METHOD_LABEL", this.resourceRepository());
        arrayList.add(this.addMethodLabel);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.addRemoveMethodsPanel.add((Component)this.addMethodLabel, gridBagConstraints);
        ListChooser listChooser5 = this.buildAddMethodListChooser();
        arrayList.add(listChooser5);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.addRemoveMethodsPanel.add((Component)listChooser5, gridBagConstraints);
        this.removeMethodLabel = SwingComponentFactory.buildLabel("REMOVE_METHOD_LABEL", this.resourceRepository());
        arrayList.add(this.removeMethodLabel);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(5, 5, 5, 0);
        this.addRemoveMethodsPanel.add((Component)this.removeMethodLabel, gridBagConstraints);
        ListChooser listChooser6 = this.buildRemoveMethodListChooser();
        arrayList.add(listChooser6);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.addRemoveMethodsPanel.add((Component)listChooser6, gridBagConstraints);
        this.generateAddRemoveMethodsButton = SwingComponentFactory.buildButton("GENERATE_METHODS_BUTTON_TEXT", this.resourceRepository());
        this.generateAddRemoveMethodsButton.addActionListener(this.buildGenerateAddRemoveMethodsActionListener());
        arrayList.add(this.generateAddRemoveMethodsButton);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.insets = new Insets(10, 5, 5, 5);
        this.addRemoveMethodsPanel.add((Component)this.generateAddRemoveMethodsButton, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 19;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.addRemoveMethodsPanel, gridBagConstraints);
        this.setPanelVisible(this.addRemoveMethodsPanel, false);
        new ComponentEnabler(this.buildAttributeTypeBooleanHolder(), arrayList);
        this.addHelpTopicId(this, this.helpTopicId());
    }

    private ValueModel buildAttributeTypeBooleanHolder() {
        return new TransformationPropertyValueModel(this.attributeTypeHolder){

            protected Object transform(Object object) {
                return object == null ? Boolean.FALSE : Boolean.TRUE;
            }
        };
    }

    private ActionListener buildGenerateGetSetMethodsActionListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ClassAttributeAccessorsPanel.this.getAttribute().generateGetAndSetMethods();
            }
        };
    }

    private ActionListener buildGenerateValueGetSetMethodsActionListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ClassAttributeAccessorsPanel.this.getAttribute().generateValueGetAndSetMethods();
            }
        };
    }

    private ActionListener buildGenerateAddRemoveMethodsActionListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ClassAttributeAccessorsPanel.this.getAttribute().generateAddAndRemoveMethods();
            }
        };
    }

    private String helpTopicId() {
        return "descriptor.classInfo.attributes.accessors";
    }

    private ListChooser buildGetMethodListChooser() {
        DefaultListChooser defaultListChooser = new DefaultListChooser(this.buildGetMethodComboBoxModel(), this.getWorkbenchContextHolder(), this.buildGetMethodChooserDialogBuilder());
        defaultListChooser.setRenderer(this.getMethodListCellRenderer());
        return defaultListChooser;
    }

    private CachingComboBoxModel buildGetMethodComboBoxModel() {
        return new ExtendedComboBoxModel(new IndirectComboBoxModel(this.buildGetMethodHolder(), this.attributeHolder){

            protected ListIterator listValueFromSubject(Object object) {
                return ClassAttributeAccessorsPanel.this.orderedGetMethodChoices((MWClassAttribute)object);
            }
        });
    }

    private PropertyValueModel buildGetMethodHolder() {
        return new PropertyAspectAdapter(this.attributeHolder, "getMethod"){

            protected Object getValueFromSubject() {
                return ((MWClassAttribute)this.subject).getGetMethod();
            }

            protected void setValueOnSubject(Object object) {
                ((MWClassAttribute)this.subject).setGetMethod((MWMethod)object);
            }
        };
    }

    ListIterator orderedGetMethodChoices(MWClassAttribute mWClassAttribute) {
        return CollectionTools.sort((Iterator)mWClassAttribute.candidateGetMethods()).listIterator();
    }

    private DefaultListChooserDialog.Builder buildGetMethodChooserDialogBuilder() {
        DefaultListChooserDialog.Builder builder = new DefaultListChooserDialog.Builder();
        builder.setTitleKey("GET_METHOD_LIST_BROWSER_DIALOG.title");
        builder.setListBoxLabelKey("GET_METHOD_LIST_BROWSER_DIALOG.listLabel");
        builder.setStringConverter(this.buildMethodStringConverter());
        return builder;
    }

    private ListChooser buildSetMethodListChooser() {
        DefaultListChooser defaultListChooser = new DefaultListChooser(this.buildSetMethodComboBoxModel(), this.getWorkbenchContextHolder(), this.buildSetMethodChooserDialogBuilder());
        defaultListChooser.setRenderer(this.getMethodListCellRenderer());
        return defaultListChooser;
    }

    private CachingComboBoxModel buildSetMethodComboBoxModel() {
        return new ExtendedComboBoxModel(new IndirectComboBoxModel(this.buildSetMethodHolder(), this.attributeHolder){

            protected ListIterator listValueFromSubject(Object object) {
                return ClassAttributeAccessorsPanel.this.orderedSetMethodChoices((MWClassAttribute)object);
            }
        });
    }

    private PropertyValueModel buildSetMethodHolder() {
        return new PropertyAspectAdapter(this.attributeHolder, "setMethod"){

            protected Object getValueFromSubject() {
                return ((MWClassAttribute)this.subject).getSetMethod();
            }

            protected void setValueOnSubject(Object object) {
                ((MWClassAttribute)this.subject).setSetMethod((MWMethod)object);
            }
        };
    }

    ListIterator orderedSetMethodChoices(MWClassAttribute mWClassAttribute) {
        return CollectionTools.sort((Iterator)mWClassAttribute.candidateSetMethods()).listIterator();
    }

    private DefaultListChooserDialog.Builder buildSetMethodChooserDialogBuilder() {
        DefaultListChooserDialog.Builder builder = new DefaultListChooserDialog.Builder();
        builder.setTitleKey("SET_METHOD_LIST_BROWSER_DIALOG.title");
        builder.setListBoxLabelKey("SET_METHOD_LIST_BROWSER_DIALOG.listLabel");
        builder.setStringConverter(this.buildMethodStringConverter());
        return builder;
    }

    private ListChooser buildValueGetMethodListChooser() {
        DefaultListChooser defaultListChooser = new DefaultListChooser(this.buildValueGetMethodComboBoxModel(), this.getWorkbenchContextHolder(), this.buildValueGetMethodChooserDialogBuilder());
        defaultListChooser.setRenderer(this.getMethodListCellRenderer());
        return defaultListChooser;
    }

    private CachingComboBoxModel buildValueGetMethodComboBoxModel() {
        return new ExtendedComboBoxModel(new IndirectComboBoxModel(this.buildValueGetMethodHolder(), this.attributeHolder){

            protected ListIterator listValueFromSubject(Object object) {
                return ClassAttributeAccessorsPanel.this.orderedValueGetMethodChoices((MWClassAttribute)object);
            }
        });
    }

    private PropertyValueModel buildValueGetMethodHolder() {
        return new PropertyAspectAdapter(this.attributeHolder, "valueGetMethod"){

            protected Object getValueFromSubject() {
                return ((MWClassAttribute)this.subject).getValueGetMethod();
            }

            protected void setValueOnSubject(Object object) {
                ((MWClassAttribute)this.subject).setValueGetMethod((MWMethod)object);
            }
        };
    }

    ListIterator orderedValueGetMethodChoices(MWClassAttribute mWClassAttribute) {
        return CollectionTools.sort((Iterator)mWClassAttribute.candidateValueGetMethods()).listIterator();
    }

    private DefaultListChooserDialog.Builder buildValueGetMethodChooserDialogBuilder() {
        DefaultListChooserDialog.Builder builder = new DefaultListChooserDialog.Builder();
        builder.setTitleKey("VALUE_GET_METHOD_LIST_BROWSER_DIALOG.title");
        builder.setListBoxLabelKey("VALUE_GET_METHOD_LIST_BROWSER_DIALOG.listLabel");
        builder.setStringConverter(this.buildMethodStringConverter());
        return builder;
    }

    private ListChooser buildValueSetMethodListChooser() {
        DefaultListChooser defaultListChooser = new DefaultListChooser(this.buildValueSetMethodComboBoxModel(), this.getWorkbenchContextHolder(), this.buildValueSetMethodChooserDialogBuilder());
        defaultListChooser.setRenderer(this.getMethodListCellRenderer());
        return defaultListChooser;
    }

    private CachingComboBoxModel buildValueSetMethodComboBoxModel() {
        return new ExtendedComboBoxModel(new IndirectComboBoxModel(this.buildValueSetMethodHolder(), this.attributeHolder){

            protected ListIterator listValueFromSubject(Object object) {
                return ClassAttributeAccessorsPanel.this.orderedValueSetMethodChoices((MWClassAttribute)object);
            }
        });
    }

    private PropertyValueModel buildValueSetMethodHolder() {
        return new PropertyAspectAdapter(this.attributeHolder, "valueSetMethod"){

            protected Object getValueFromSubject() {
                return ((MWClassAttribute)this.subject).getValueSetMethod();
            }

            protected void setValueOnSubject(Object object) {
                ((MWClassAttribute)this.subject).setValueSetMethod((MWMethod)object);
            }
        };
    }

    ListIterator orderedValueSetMethodChoices(MWClassAttribute mWClassAttribute) {
        return CollectionTools.sort((Iterator)mWClassAttribute.candidateValueSetMethods()).listIterator();
    }

    private DefaultListChooserDialog.Builder buildValueSetMethodChooserDialogBuilder() {
        DefaultListChooserDialog.Builder builder = new DefaultListChooserDialog.Builder();
        builder.setTitleKey("VALUE_SET_METHOD_LIST_BROWSER_DIALOG.title");
        builder.setListBoxLabelKey("VALUE_SET_METHOD_LIST_BROWSER_DIALOG.listLabel");
        builder.setStringConverter(this.buildMethodStringConverter());
        return builder;
    }

    private ListChooser buildAddMethodListChooser() {
        DefaultListChooser defaultListChooser = new DefaultListChooser(this.buildAddMethodComboBoxModel(), this.getWorkbenchContextHolder(), this.buildAddMethodChooserDialogBuilder());
        defaultListChooser.setRenderer(this.getMethodListCellRenderer());
        return defaultListChooser;
    }

    private CachingComboBoxModel buildAddMethodComboBoxModel() {
        return new ExtendedComboBoxModel(new IndirectComboBoxModel(this.buildAddMethodHolder(), this.attributeHolder){

            protected ListIterator listValueFromSubject(Object object) {
                return ClassAttributeAccessorsPanel.this.orderedAddMethodChoices((MWClassAttribute)object);
            }
        });
    }

    private PropertyValueModel buildAddMethodHolder() {
        return new PropertyAspectAdapter(this.attributeHolder, "addMethod"){

            protected Object getValueFromSubject() {
                return ((MWClassAttribute)this.subject).getAddMethod();
            }

            protected void setValueOnSubject(Object object) {
                ((MWClassAttribute)this.subject).setAddMethod((MWMethod)object);
            }
        };
    }

    ListIterator orderedAddMethodChoices(MWClassAttribute mWClassAttribute) {
        return CollectionTools.sort((Iterator)mWClassAttribute.candidateAddMethods()).listIterator();
    }

    private DefaultListChooserDialog.Builder buildAddMethodChooserDialogBuilder() {
        DefaultListChooserDialog.Builder builder = new DefaultListChooserDialog.Builder();
        builder.setTitleKey("ADD_METHOD_LIST_BROWSER_DIALOG.title");
        builder.setListBoxLabelKey("ADD_METHOD_LIST_BROWSER_DIALOG.listLabel");
        builder.setStringConverter(this.buildMethodStringConverter());
        return builder;
    }

    private ListChooser buildRemoveMethodListChooser() {
        DefaultListChooser defaultListChooser = new DefaultListChooser(this.buildRemoveMethodComboBoxModel(), this.getWorkbenchContextHolder(), this.buildRemoveMethodChooserDialogBuilder());
        defaultListChooser.setRenderer(this.getMethodListCellRenderer());
        return defaultListChooser;
    }

    private CachingComboBoxModel buildRemoveMethodComboBoxModel() {
        return new ExtendedComboBoxModel(new IndirectComboBoxModel(this.buildRemoveMethodHolder(), this.attributeHolder){

            protected ListIterator listValueFromSubject(Object object) {
                return ClassAttributeAccessorsPanel.this.orderedRemoveMethodChoices((MWClassAttribute)object);
            }
        });
    }

    private PropertyValueModel buildRemoveMethodHolder() {
        return new PropertyAspectAdapter(this.attributeHolder, "removeMethod"){

            protected Object getValueFromSubject() {
                return ((MWClassAttribute)this.subject).getRemoveMethod();
            }

            protected void setValueOnSubject(Object object) {
                ((MWClassAttribute)this.subject).setRemoveMethod((MWMethod)object);
            }
        };
    }

    ListIterator orderedRemoveMethodChoices(MWClassAttribute mWClassAttribute) {
        return CollectionTools.sort((Iterator)mWClassAttribute.candidateRemoveMethods()).listIterator();
    }

    private DefaultListChooserDialog.Builder buildRemoveMethodChooserDialogBuilder() {
        DefaultListChooserDialog.Builder builder = new DefaultListChooserDialog.Builder();
        builder.setTitleKey("REMOVE_METHOD_LIST_BROWSER_DIALOG.title");
        builder.setListBoxLabelKey("REMOVE_METHOD_LIST_BROWSER_DIALOG.listLabel");
        builder.setStringConverter(this.buildMethodStringConverter());
        return builder;
    }

    private StringConverter buildMethodStringConverter() {
        return new StringConverter(){

            public String convertToString(Object object) {
                return object == null ? "" : ((MWMethod)object).getName();
            }
        };
    }

    private ListCellRenderer getMethodListCellRenderer() {
        if (this.methodListCellRenderer == null) {
            this.methodListCellRenderer = new AdaptableListCellRenderer(new MethodCellRendererAdapter(this.resourceRepository()));
        }
        return this.methodListCellRenderer;
    }

    void updateGetAndSetMethodLabels() {
        if (this.getAttribute() != null && this.getAttribute().isValueHolder()) {
            this.getMethodLabel.setText(this.resourceRepository().getString("VALUE_HOLDER_GET_METHOD_LABEL"));
            this.setMethodLabel.setText(this.resourceRepository().getString("VALUE_HOLDER_SET_METHOD_LABEL"));
        } else {
            this.getMethodLabel.setText(this.resourceRepository().getString("GET_METHOD_LABEL"));
            this.setMethodLabel.setText(this.resourceRepository().getString("SET_METHOD_LABEL"));
        }
    }

    void updateAccessorPanelVisibility() {
        this.setPanelVisible(this.valueGetSetMethodsPanel, this.getAttribute() != null && this.getAttribute().canHaveValueGetAndSetMethods());
        this.setPanelVisible(this.addRemoveMethodsPanel, this.getAttribute() != null && this.getAttribute().canHaveAddAndRemoveMethods());
    }

    private void setPanelVisible(JPanel jPanel, boolean bl) {
        jPanel.setVisible(bl);
        this.revalidate();
        this.repaint();
    }

    MWClassAttribute getAttribute() {
        return (MWClassAttribute)this.attributeHolder.getValue();
    }
}

