/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor;

import java.util.Iterator;
import javax.swing.text.Document;
import org.eclipse.persistence.tools.workbench.framework.action.AbstractFrameworkAction;
import org.eclipse.persistence.tools.workbench.framework.app.ApplicationNode;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.ui.dialog.NewNameDialog;
import org.eclipse.persistence.tools.workbench.framework.uitools.RegexpDocument;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClass;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.MWProject;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.DescriptorNode;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.DescriptorPackageNode;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.project.ProjectNode;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.NameTools;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public class RenamePackageAction
extends AbstractFrameworkAction {
    public RenamePackageAction(WorkbenchContext workbenchContext) {
        super(workbenchContext);
    }

    protected void initialize() {
        super.initialize();
        this.setIcon(EMPTY_ICON);
        this.initializeTextAndMnemonic("RENAME_PACKAGE_ACTION");
        this.initializeToolTipText("RENAME_PACKAGE_ACTION.tooltip");
    }

    protected void execute(ApplicationNode applicationNode) {
        String string = this.promptForPackageName(applicationNode);
        if (string == null) {
            return;
        }
        this.navigatorSelectionModel().pushExpansionState();
        Iterator iterator = CollectionTools.collection((Iterator)((DescriptorPackageNode)applicationNode).descriptorNodes()).iterator();
        while (iterator.hasNext()) {
            this.navigatorSelectionModel().pushExpansionState();
            DescriptorNode descriptorNode = (DescriptorNode)iterator.next();
            MWDescriptor mWDescriptor = descriptorNode.getDescriptor();
            MWClass mWClass = mWDescriptor.getMWClass();
            mWClass.setName(string + "." + mWClass.shortName());
            mWDescriptor.setName(string + "." + mWClass.shortName());
            this.navigatorSelectionModel().popAndRestoreExpansionState(descriptorNode, ((ProjectNode)applicationNode.getProjectRoot()).descriptorPackageNodeNamed(string).descendantNodeForValue((Node)mWDescriptor));
        }
        this.navigatorSelectionModel().popAndRestoreExpansionState(applicationNode, ((ProjectNode)applicationNode.getProjectRoot()).descriptorPackageNodeNamed(string));
        this.navigatorSelectionModel().setSelectedNode(((ProjectNode)applicationNode.getProjectRoot()).descriptorPackageNodeNamed(string));
    }

    private String promptForPackageName(ApplicationNode applicationNode) {
        LocalNewNameDialog.LocalBuilder localBuilder = new LocalNewNameDialog.LocalBuilder();
        localBuilder.addExistingNames(this.packageNames(applicationNode));
        localBuilder.setTitle(this.resourceRepository().getString("RENAME_PACKAGE_ACTION_DIALOG.title"));
        localBuilder.setTextFieldDescription(this.resourceRepository().getString("RENAME_PACKAGE_ACTION_DIALOG.textField"));
        localBuilder.setOriginalName(applicationNode.displayString());
        LocalNewNameDialog localNewNameDialog = (LocalNewNameDialog)localBuilder.buildDialog(this.getWorkbenchContext());
        localNewNameDialog.show();
        return localNewNameDialog.wasConfirmed() ? localNewNameDialog.getNewName() : null;
    }

    private Iterator packageNames(ApplicationNode applicationNode) {
        return ((MWProject)applicationNode.getProjectRoot().getValue()).packageNames();
    }

    private static class LocalNewNameDialog
    extends NewNameDialog {
        LocalNewNameDialog(WorkbenchContext workbenchContext, NewNameDialog.Builder builder) {
            super(workbenchContext, builder);
        }

        protected boolean nameIsIllegal(String string) {
            String[] stringArray = string.split("\\.");
            for (int i = 0; i < stringArray.length; ++i) {
                if (!NameTools.javaReservedWordsContains((String)stringArray[i])) continue;
                return true;
            }
            return false;
        }

        private static class LocalBuilder
        extends NewNameDialog.Builder {
            LocalBuilder() {
            }

            protected NewNameDialog.DocumentFactory buildDefaultDocumentFactory() {
                return new NewNameDialog.DocumentFactory(){

                    public Document buildDocument() {
                        return RegexpDocument.buildDocument(1);
                    }
                };
            }

            protected NewNameDialog buildDialog(WorkbenchContext workbenchContext, NewNameDialog.Builder builder) {
                return new LocalNewNameDialog(workbenchContext, builder);
            }
        }
    }
}

