/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.mapping;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.ListIterator;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.resources.ResourceRepository;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractSubjectPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWDataField;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWFieldTransformerAssociation;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWTransformationMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWTransformer;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.mapping.TransformerCellRendererAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.ListAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValuePropertyPropertyValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ColumnAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ListModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ObjectListSelectionModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.TableModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.cell.AdaptableTableCellRenderer;
import org.eclipse.persistence.tools.workbench.uitools.cell.SimpleTableCellRenderer;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.Model;

public abstract class FieldTransformerAssociationsPanel
extends AbstractSubjectPanel {
    private ObjectListSelectionModel fieldTransformerAssociationsSelectionModel;

    public FieldTransformerAssociationsPanel(ValueModel valueModel, WorkbenchContextHolder workbenchContextHolder) {
        super(valueModel, workbenchContextHolder);
    }

    protected void initializeLayout() {
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createTitledBorder(this.resourceRepository().getString("TRANSFORMATION_MAPPING_FIELD_TRANSFORMER_ASSOCIATIONS_PANEL")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JComponent jComponent = this.buildFieldTransformerAssociationsTablePanel();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 4;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 5, 5, 0);
        this.add((Component)jComponent, gridBagConstraints);
        JButton jButton = this.buildAddFieldTransformerAssociationButton();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.add((Component)jButton, gridBagConstraints);
        this.addAlignRight(jButton);
        JButton jButton2 = this.buildEditFieldTransformerAssociationButton();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.add((Component)jButton2, gridBagConstraints);
        this.addAlignRight(jButton2);
        JButton jButton3 = this.buildRemoveFieldTransformerAssociationsButton();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 19;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.add((Component)jButton3, gridBagConstraints);
        this.addAlignRight(jButton3);
        this.addHelpTopicId(this, "mapping.transformation.fieldTransformerAssociations");
    }

    private JComponent buildFieldTransformerAssociationsTablePanel() {
        JTable jTable = this.buildFieldTransformerAssociationsTable();
        TableColumn tableColumn = jTable.getColumnModel().getColumn(0);
        TableColumn tableColumn2 = jTable.getColumnModel().getColumn(1);
        tableColumn2.setPreferredWidth(tableColumn.getPreferredWidth() * 2);
        JScrollPane jScrollPane = new JScrollPane(jTable, 20, 31);
        jScrollPane.getViewport().setBackground(jTable.getBackground());
        jScrollPane.setPreferredSize(new Dimension(10, 10));
        return jScrollPane;
    }

    private JTable buildFieldTransformerAssociationsTable() {
        ListValueModel listValueModel = this.buildFieldTransformerAssociationsValue();
        TableModel tableModel = this.buildFieldTransformerAssociationsTableModel(listValueModel);
        this.fieldTransformerAssociationsSelectionModel = this.buildFieldTransformerAssociationsSelectionModel(listValueModel);
        JTable jTable = SwingComponentFactory.buildTable(tableModel, this.fieldTransformerAssociationsSelectionModel);
        TableColumn tableColumn = jTable.getColumnModel().getColumn(0);
        tableColumn.setCellRenderer(this.buildFieldColumnCellRenderer());
        tableColumn = jTable.getColumnModel().getColumn(1);
        tableColumn.setCellRenderer(this.buildTransformerTableCellRenderer());
        return jTable;
    }

    private ListValueModel buildFieldTransformerAssociationsValue() {
        return new ListAspectAdapter(this.getSubjectHolder(), "fieldTransformerAssociations"){

            protected ListIterator getValueFromSubject() {
                return ((MWTransformationMapping)this.subject).fieldTransformerAssociations();
            }
        };
    }

    private TableModel buildFieldTransformerAssociationsTableModel(ListValueModel listValueModel) {
        return new TableModelAdapter(listValueModel, this.buildFieldTransformerAssociationsColumnAdapter());
    }

    protected ColumnAdapter buildFieldTransformerAssociationsColumnAdapter() {
        return new FieldTransformationAssociationsColumnAdapter(this.resourceRepository());
    }

    private ObjectListSelectionModel buildFieldTransformerAssociationsSelectionModel(ListValueModel listValueModel) {
        ObjectListSelectionModel objectListSelectionModel = new ObjectListSelectionModel(new ListModelAdapter(listValueModel));
        objectListSelectionModel.setSelectionMode(2);
        return objectListSelectionModel;
    }

    protected TableCellRenderer buildFieldColumnCellRenderer() {
        return new SimpleTableCellRenderer(){

            protected String buildText(Object object) {
                return object == null ? null : ((MWDataField)object).fieldName();
            }
        };
    }

    private TableCellRenderer buildTransformerTableCellRenderer() {
        return new AdaptableTableCellRenderer(new TransformerCellRendererAdapter(this.resourceRepository()));
    }

    private JButton buildAddFieldTransformerAssociationButton() {
        JButton jButton = new JButton(this.resourceRepository().getString("TRANSFORMATION_MAPPING_FIELD_TRANSFORMER_ADD_BUTTON"));
        jButton.addActionListener(this.buildAddFieldTransformerAssociationAction());
        return jButton;
    }

    protected abstract ActionListener buildAddFieldTransformerAssociationAction();

    private JButton buildEditFieldTransformerAssociationButton() {
        JButton jButton = new JButton(this.resourceRepository().getString("TRANSFORMATION_MAPPING_FIELD_TRANSFORMER_EDIT_BUTTON"));
        jButton.addActionListener(this.buildEditFieldTransformerAssociationAction());
        this.fieldTransformerAssociationsSelectionModel.addListSelectionListener(this.buildListenerForEditFieldTransformerAssociation(jButton));
        jButton.setEnabled(false);
        return jButton;
    }

    protected abstract ActionListener buildEditFieldTransformerAssociationAction();

    private ListSelectionListener buildListenerForEditFieldTransformerAssociation(final JButton jButton) {
        return new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    boolean bl = FieldTransformerAssociationsPanel.this.fieldTransformerAssociationsSelectionModel.getSelectedValues().length == 1;
                    jButton.setEnabled(bl);
                }
            }
        };
    }

    private JButton buildRemoveFieldTransformerAssociationsButton() {
        JButton jButton = new JButton(this.resourceRepository().getString("TRANSFORMATION_MAPPING_FIELD_TRANSFORMERS_REMOVE_BUTTON"));
        jButton.addActionListener(this.buildRemoveFieldTransformerAssociationsAction());
        this.fieldTransformerAssociationsSelectionModel.addListSelectionListener(this.buildListenerForRemoveFieldTransformerAssociations(jButton));
        jButton.setEnabled(false);
        return jButton;
    }

    private ActionListener buildRemoveFieldTransformerAssociationsAction() {
        return new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                FieldTransformerAssociationsPanel.this.removeSelectedFieldTransformerAssociations();
            }
        };
    }

    private ListSelectionListener buildListenerForRemoveFieldTransformerAssociations(final JButton jButton) {
        return new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    boolean bl = !FieldTransformerAssociationsPanel.this.fieldTransformerAssociationsSelectionModel.isSelectionEmpty();
                    jButton.setEnabled(bl);
                }
            }
        };
    }

    private void removeSelectedFieldTransformerAssociations() {
        Iterator iterator = CollectionTools.iterator((Object[])this.fieldTransformerAssociationsSelectionModel.getSelectedValues());
        while (iterator.hasNext()) {
            ((MWTransformationMapping)this.subject()).removeFieldTransformerAssociation((MWFieldTransformerAssociation)iterator.next());
        }
    }

    protected MWFieldTransformerAssociation selectedFieldTransformerAssociation() {
        return (MWFieldTransformerAssociation)this.fieldTransformerAssociationsSelectionModel.getSelectedValue();
    }

    protected static class FieldTransformationAssociationsColumnAdapter
    implements ColumnAdapter {
        protected ResourceRepository resourceRepository;
        public static final int COLUMN_COUNT = 2;
        public static final int FIELD_COLUMN = 0;
        public static final int TRANSFORMER_COLUMN = 1;

        public int getColumnCount() {
            return 2;
        }

        protected FieldTransformationAssociationsColumnAdapter(ResourceRepository resourceRepository) {
            this.resourceRepository = resourceRepository;
        }

        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return this.resourceRepository.getString("TRANSFORMATION_MAPPING_FIELD_COLUMN_LABEL");
                }
                case 1: {
                    return this.resourceRepository.getString("TRANSFORMATION_MAPPING_TRANSFORMER_COLUMN_LABEL");
                }
            }
            return "";
        }

        public Class getColumnClass(int n) {
            switch (n) {
                case 0: {
                    return MWDataField.class;
                }
                case 1: {
                    return MWTransformer.class;
                }
            }
            return null;
        }

        public boolean isColumnEditable(int n) {
            return false;
        }

        public PropertyValueModel[] cellModels(Object object) {
            MWFieldTransformerAssociation mWFieldTransformerAssociation = (MWFieldTransformerAssociation)object;
            PropertyValueModel[] propertyValueModelArray = new PropertyValueModel[]{this.buildFieldAdapter(mWFieldTransformerAssociation), this.buildTransformerAdapter(mWFieldTransformerAssociation)};
            return propertyValueModelArray;
        }

        protected PropertyValueModel buildFieldAdapter(MWFieldTransformerAssociation mWFieldTransformerAssociation) {
            PropertyAspectAdapter propertyAspectAdapter = new PropertyAspectAdapter("field", (Model)mWFieldTransformerAssociation){

                protected Object getValueFromSubject() {
                    return ((MWFieldTransformerAssociation)this.subject).getField();
                }
            };
            return new ValuePropertyPropertyValueModelAdapter((PropertyValueModel)propertyAspectAdapter, "fieldName");
        }

        private PropertyValueModel buildTransformerAdapter(MWFieldTransformerAssociation mWFieldTransformerAssociation) {
            PropertyAspectAdapter propertyAspectAdapter = new PropertyAspectAdapter("fieldTransformer", (Model)mWFieldTransformerAssociation){

                protected Object getValueFromSubject() {
                    return ((MWFieldTransformerAssociation)this.subject).getFieldTransformer();
                }
            };
            return new ValuePropertyPropertyValueModelAdapter((PropertyValueModel)propertyAspectAdapter, "transformer");
        }
    }
}

