/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.mapping;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Comparator;
import java.util.Iterator;
import javax.swing.ButtonModel;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.eclipse.persistence.tools.workbench.framework.context.ApplicationContext;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.help.HelpManager;
import org.eclipse.persistence.tools.workbench.framework.resources.ResourceRepository;
import org.eclipse.persistence.tools.workbench.framework.ui.chooser.DefaultListChooser;
import org.eclipse.persistence.tools.workbench.framework.ui.chooser.DefaultListChooserDialog;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWIndirectableMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWReferenceMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWReferenceObjectMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWTransformationMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.MWProject;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.common.cell.DescriptorCellRendererAdapter;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.mapping.CollectionContainerPolicyPanel;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.mapping.ContainerPolicyPanel;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.mapping.DirectMapContainerPolicyPanel;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.project.ProjectNode;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.FilteringCollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ItemPropertyListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SortedListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.CheckBoxModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ComboBoxModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.cell.AdaptableListCellRenderer;
import org.eclipse.persistence.tools.workbench.uitools.chooser.ListChooser;
import org.eclipse.persistence.tools.workbench.uitools.chooser.NodeSelector;
import org.eclipse.persistence.tools.workbench.uitools.swing.ExtendedComboBoxModel;
import org.eclipse.persistence.tools.workbench.utility.string.StringConverter;

public class MappingComponentFactory
extends SwingComponentFactory {
    public static JCheckBox buildReadOnlyCheckBox(ValueModel valueModel, ApplicationContext applicationContext) {
        JCheckBox jCheckBox = MappingComponentFactory.buildCheckBox("MAPPING_READ_ONLY_CHECK_BOX", new CheckBoxModelAdapter(MappingComponentFactory.buildReadOnlyHolder(valueModel)), applicationContext.getResourceRepository());
        applicationContext.getHelpManager().addTopicID(jCheckBox, "mapping.readOnly");
        return jCheckBox;
    }

    private static PropertyValueModel buildReadOnlyHolder(ValueModel valueModel) {
        return new PropertyAspectAdapter(valueModel, "readOnly"){

            protected Object getValueFromSubject() {
                return ((MWMapping)this.subject).isReadOnly();
            }

            protected void setValueOnSubject(Object object) {
                ((MWMapping)this.subject).setReadOnly(((Boolean)object).booleanValue());
            }
        };
    }

    public static ListChooser buildReferenceDescriptorChooser(ValueModel valueModel, WorkbenchContextHolder workbenchContextHolder) {
        DefaultListChooser defaultListChooser = new DefaultListChooser(MappingComponentFactory.buildExtendedReferenceDescriptorComboBoxModel(valueModel), workbenchContextHolder, MappingComponentFactory.buildDescriptorNodeSelector(workbenchContextHolder), MappingComponentFactory.buildReferenceChooserDialogBuilder(workbenchContextHolder.getWorkbenchContext().getApplicationContext().getResourceRepository()));
        defaultListChooser.setRenderer(MappingComponentFactory.buildDescriptorListRenderer(workbenchContextHolder.getWorkbenchContext().getApplicationContext().getResourceRepository()));
        return defaultListChooser;
    }

    public static NodeSelector buildDescriptorNodeSelector(final WorkbenchContextHolder workbenchContextHolder) {
        return new NodeSelector(){

            public void selectNodeFor(Object object) {
                ProjectNode projectNode = (ProjectNode)workbenchContextHolder.getWorkbenchContext().getNavigatorSelectionModel().getSelectedProjectNodes()[0];
                projectNode.selectDescriptorNodeFor((MWDescriptor)object, workbenchContextHolder.getWorkbenchContext().getNavigatorSelectionModel());
            }
        };
    }

    private static ComboBoxModel buildExtendedReferenceDescriptorComboBoxModel(ValueModel valueModel) {
        return new ExtendedComboBoxModel(MappingComponentFactory.buildReferenceDescriptorComboBoxModel(valueModel));
    }

    private static ComboBoxModel buildReferenceDescriptorComboBoxModel(ValueModel valueModel) {
        return new ComboBoxModelAdapter(MappingComponentFactory.buildSortedCandidateReferenceDescriptorsListValue(valueModel), MappingComponentFactory.buildReferenceDescriptorValue(valueModel));
    }

    private static ListValueModel buildSortedCandidateReferenceDescriptorsListValue(ValueModel valueModel) {
        return new SortedListValueModelAdapter(MappingComponentFactory.buildNotifyingCandidateReferenceDescriptorsListValue(valueModel), MappingComponentFactory.buildDescriptorComparator());
    }

    private static ListValueModel buildNotifyingCandidateReferenceDescriptorsListValue(ValueModel valueModel) {
        return new ItemPropertyListValueModelAdapter(MappingComponentFactory.buildCandidateReferenceDescriptorsCollectionValue(valueModel), "name");
    }

    private static CollectionValueModel buildCandidateReferenceDescriptorsCollectionValue(final ValueModel valueModel) {
        return new FilteringCollectionValueModel(MappingComponentFactory.buildDescriptorsCollectionValue(valueModel)){

            protected boolean accept(Object object) {
                MWReferenceObjectMapping mWReferenceObjectMapping = (MWReferenceObjectMapping)valueModel.getValue();
                return mWReferenceObjectMapping == null ? false : mWReferenceObjectMapping.descriptorIsValidReferenceDescriptor((MWDescriptor)object);
            }
        };
    }

    private static CollectionValueModel buildDescriptorsCollectionValue(ValueModel valueModel) {
        return new CollectionAspectAdapter(MappingComponentFactory.buildProjectValue(valueModel), "descriptors"){

            protected Iterator getValueFromSubject() {
                return ((MWProject)this.subject).descriptors();
            }

            protected int sizeFromSubject() {
                return ((MWProject)this.subject).descriptorsSize();
            }
        };
    }

    private static PropertyValueModel buildProjectValue(ValueModel valueModel) {
        return new PropertyAspectAdapter(valueModel){

            protected Object getValueFromSubject() {
                return ((MWMapping)this.subject).getProject();
            }
        };
    }

    private static PropertyValueModel buildReferenceDescriptorValue(ValueModel valueModel) {
        return new PropertyAspectAdapter(valueModel, "referenceDescriptor"){

            protected Object getValueFromSubject() {
                return ((MWReferenceObjectMapping)this.subject).getReferenceDescriptor();
            }

            protected void setValueOnSubject(Object object) {
                ((MWReferenceObjectMapping)this.subject).setReferenceDescriptor((MWDescriptor)object);
            }
        };
    }

    private static Comparator buildDescriptorComparator() {
        return new Comparator(){

            public int compare(Object object, Object object2) {
                return ((MWDescriptor)object).displayStringWithPackage().compareTo(((MWDescriptor)object2).displayStringWithPackage());
            }
        };
    }

    private static DefaultListChooserDialog.Builder buildReferenceChooserDialogBuilder(ResourceRepository resourceRepository) {
        DefaultListChooserDialog.Builder builder = new DefaultListChooserDialog.Builder();
        builder.setTitleKey("REFERENCE_DESCRIPTOR_LIST_BROWSER_DIALOG.title");
        builder.setListBoxLabelKey("REFERENCE_DESCRIPTOR_LIST_BROWSER_DIALOG.listLabel");
        builder.setStringConverter(MappingComponentFactory.buildDescriptorStringConverter(resourceRepository));
        return builder;
    }

    private static ListCellRenderer buildDescriptorListRenderer(ResourceRepository resourceRepository) {
        return new AdaptableListCellRenderer(new DescriptorCellRendererAdapter(resourceRepository));
    }

    private static StringConverter buildDescriptorStringConverter(ResourceRepository resourceRepository) {
        return new StringConverter(){

            public String convertToString(Object object) {
                return object == null ? "" : ((MWDescriptor)object).displayStringWithPackage();
            }
        };
    }

    public static JCheckBox buildPrivateOwnedCheckBox(ValueModel valueModel, ResourceRepository resourceRepository, HelpManager helpManager) {
        JCheckBox jCheckBox = MappingComponentFactory.buildCheckBox("MAPPING_PRIVATE_OWNED_CHECK_BOX", MappingComponentFactory.buildPrivateOwnedCheckBoxAdapter(valueModel), resourceRepository);
        helpManager.addTopicID(jCheckBox, "mapping.privateOwned");
        return jCheckBox;
    }

    private static ButtonModel buildPrivateOwnedCheckBoxAdapter(ValueModel valueModel) {
        return new CheckBoxModelAdapter(MappingComponentFactory.buildPrivateOwnedHolder(valueModel));
    }

    private static PropertyValueModel buildPrivateOwnedHolder(ValueModel valueModel) {
        return new PropertyAspectAdapter(valueModel, "privateOwned"){

            protected Object getValueFromSubject() {
                MWReferenceMapping mWReferenceMapping = (MWReferenceMapping)this.subject;
                return mWReferenceMapping.isPrivateOwned();
            }

            protected void setValueOnSubject(Object object) {
                MWReferenceMapping mWReferenceMapping = (MWReferenceMapping)this.subject;
                mWReferenceMapping.setPrivateOwned(((Boolean)object).booleanValue());
            }
        };
    }

    public static JCheckBox buildUsesIndirectionCheckBox(ValueModel valueModel, ResourceRepository resourceRepository, HelpManager helpManager) {
        JCheckBox jCheckBox = MappingComponentFactory.buildCheckBox("MAPPING_USE_INDIRECTION_CHECK_BOX", MappingComponentFactory.buildUsesIndirectionCheckBoxModel(valueModel), resourceRepository);
        helpManager.addTopicID(jCheckBox, "mapping.indirection");
        return jCheckBox;
    }

    private static ButtonModel buildUsesIndirectionCheckBoxModel(ValueModel valueModel) {
        return new CheckBoxModelAdapter(MappingComponentFactory.buildUsesIndirectionValue(valueModel));
    }

    private static PropertyValueModel buildUsesIndirectionValue(ValueModel valueModel) {
        return new PropertyAspectAdapter(valueModel, "indirection"){

            protected Object getValueFromSubject() {
                return ((MWIndirectableMapping)this.subject).usesValueHolderIndirection();
            }

            protected void setValueOnSubject(Object object) {
                boolean bl = (Boolean)object;
                if (bl) {
                    ((MWIndirectableMapping)this.subject).setUseValueHolderIndirection();
                } else {
                    ((MWIndirectableMapping)this.subject).setUseNoIndirection();
                }
            }
        };
    }

    public static JCheckBox buildMutableCheckBox(ValueModel valueModel, ResourceRepository resourceRepository, HelpManager helpManager) {
        JCheckBox jCheckBox = MappingComponentFactory.buildCheckBox("TRANSFORMATION_MAPPING_IS_MUTABLE", MappingComponentFactory.buildMutableCheckBoxModel(valueModel), resourceRepository);
        helpManager.addTopicID(jCheckBox, "mapping.transformation.mutable");
        return jCheckBox;
    }

    private static ButtonModel buildMutableCheckBoxModel(ValueModel valueModel) {
        return new CheckBoxModelAdapter(MappingComponentFactory.buildMutableValue(valueModel));
    }

    private static PropertyValueModel buildMutableValue(ValueModel valueModel) {
        return new PropertyAspectAdapter(valueModel, "mutable"){

            protected Object getValueFromSubject() {
                return ((MWTransformationMapping)this.subject).isMutable();
            }

            protected void setValueOnSubject(Object object) {
                ((MWTransformationMapping)this.subject).setMutable(((Boolean)object).booleanValue());
            }
        };
    }

    public static JPanel buildContainerPolicyOptionsBrowser(WorkbenchContextHolder workbenchContextHolder, PropertyValueModel propertyValueModel, String string) {
        ContainerPolicyPanel containerPolicyPanel = new ContainerPolicyPanel((ValueModel)propertyValueModel, workbenchContextHolder);
        return MappingComponentFactory.buildContainerOptionsBrowser(workbenchContextHolder, propertyValueModel, containerPolicyPanel, string);
    }

    public static JPanel buildDirectMapContainerPolicyOptionsBrowser(WorkbenchContextHolder workbenchContextHolder, PropertyValueModel propertyValueModel, String string) {
        DirectMapContainerPolicyPanel directMapContainerPolicyPanel = new DirectMapContainerPolicyPanel(propertyValueModel, workbenchContextHolder);
        return MappingComponentFactory.buildContainerOptionsBrowser(workbenchContextHolder, propertyValueModel, directMapContainerPolicyPanel, string);
    }

    public static JPanel buildCollectionContainerPolicyOptionsBrowser(WorkbenchContextHolder workbenchContextHolder, PropertyValueModel propertyValueModel, String string) {
        CollectionContainerPolicyPanel collectionContainerPolicyPanel = new CollectionContainerPolicyPanel(propertyValueModel, workbenchContextHolder);
        return MappingComponentFactory.buildContainerOptionsBrowser(workbenchContextHolder, propertyValueModel, collectionContainerPolicyPanel, string);
    }

    private static JPanel buildContainerOptionsBrowser(WorkbenchContextHolder workbenchContextHolder, PropertyValueModel propertyValueModel, JPanel jPanel, String string) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        HelpManager helpManager = workbenchContextHolder.getWorkbenchContext().getApplicationContext().getHelpManager();
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        String string2 = workbenchContextHolder.getWorkbenchContext().getApplicationContext().getResourceRepository().getString("COLLECTION_OPTIONS_ADVANCED_BUTTON");
        jPanel.setVisible(false);
        jPanel.setBorder(MappingComponentFactory.buildTitledBorder(workbenchContextHolder.getWorkbenchContext().getApplicationContext().getResourceRepository(), "COLLECTION_OPTIONS_ADVANCED_BUTTON"));
        JButton jButton = MappingComponentFactory.buildButton("COLLECTION_OPTIONS_ADVANCED_BUTTON", workbenchContextHolder.getWorkbenchContext().getApplicationContext().getResourceRepository());
        String string3 = jButton.getText();
        string3 = string3 + " >>";
        jButton.setText(string3);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        helpManager.addTopicID(jButton, string + ".advancedContainerOptions");
        jPanel2.add((Component)jButton, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        helpManager.addTopicID(jPanel, string + ".advancedContainerOptions");
        jPanel2.add((Component)jPanel, gridBagConstraints);
        jButton.addActionListener(MappingComponentFactory.buildAdvancedCollectionOptionsButtonActionListener(jButton, jPanel, string2));
        return jPanel2;
    }

    private static ActionListener buildAdvancedCollectionOptionsButtonActionListener(final JButton jButton, final JPanel jPanel, final String string) {
        return new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (jPanel.isVisible()) {
                    jPanel.setVisible(false);
                    jButton.setText(string + " >>");
                } else {
                    jPanel.setVisible(true);
                    jButton.setText("<<");
                }
            }
        };
    }
}

