/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.mapping;

import javax.swing.Icon;
import javax.swing.JOptionPane;
import org.eclipse.persistence.tools.workbench.framework.action.AbstractEnablableFrameworkAction;
import org.eclipse.persistence.tools.workbench.framework.action.FrameworkAction;
import org.eclipse.persistence.tools.workbench.framework.action.ToggleFrameworkAction;
import org.eclipse.persistence.tools.workbench.framework.app.ApplicationNode;
import org.eclipse.persistence.tools.workbench.framework.app.GroupContainerDescription;
import org.eclipse.persistence.tools.workbench.framework.app.MenuDescription;
import org.eclipse.persistence.tools.workbench.framework.app.MenuGroupDescription;
import org.eclipse.persistence.tools.workbench.framework.app.RootMenuDescription;
import org.eclipse.persistence.tools.workbench.framework.app.SelectionActionsPolicy;
import org.eclipse.persistence.tools.workbench.framework.app.ToggleMenuItemDescription;
import org.eclipse.persistence.tools.workbench.framework.app.ToggleToolBarButtonDescription;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.mappingsplugin.MappingsPlugin;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.mapping.MapAsUnmappedAction;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.mapping.MappingNode;
import org.eclipse.persistence.tools.workbench.uitools.LabelArea;
import org.eclipse.persistence.tools.workbench.uitools.swing.EmptyIcon;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

public abstract class MappingSelectionActionsPolicy
implements SelectionActionsPolicy {
    protected static final Icon EMPTY_ICON = new EmptyIcon(16);
    private MappingsPlugin mwPlugin;

    public MappingSelectionActionsPolicy(MappingsPlugin mappingsPlugin) {
        this.mwPlugin = mappingsPlugin;
    }

    protected MappingsPlugin getMappingsPlugin() {
        return this.mwPlugin;
    }

    public GroupContainerDescription buildMenuDescription(WorkbenchContext workbenchContext) {
        RootMenuDescription rootMenuDescription = new RootMenuDescription();
        MenuGroupDescription menuGroupDescription = new MenuGroupDescription();
        menuGroupDescription.add(this.mwPlugin.getRefreshClassesAction(workbenchContext));
        menuGroupDescription.add(this.mwPlugin.getAddOrRefreshClassesAction(workbenchContext));
        menuGroupDescription.add(this.mwPlugin.getCreateNewClassAction(workbenchContext));
        rootMenuDescription.add(menuGroupDescription);
        MenuGroupDescription menuGroupDescription2 = new MenuGroupDescription();
        menuGroupDescription2.add(this.getRemoveAction(workbenchContext));
        rootMenuDescription.add(menuGroupDescription2);
        MenuGroupDescription menuGroupDescription3 = new MenuGroupDescription();
        menuGroupDescription3.add(this.buildMapAsMenuDescription(workbenchContext));
        rootMenuDescription.add(menuGroupDescription3);
        return rootMenuDescription;
    }

    public final MenuDescription buildMapAsMenuDescription(WorkbenchContext workbenchContext) {
        MenuDescription menuDescription = new MenuDescription(workbenchContext.getApplicationContext().getResourceRepository().getString("CHANGE_MAPPING_TYPE_MENU"), workbenchContext.getApplicationContext().getResourceRepository().getString("CHANGE_MAPPING_TYPE_MENU"), workbenchContext.getApplicationContext().getResourceRepository().getMnemonic("CHANGE_MAPPING_TYPE_MENU"), EMPTY_ICON);
        this.addToMapAsMenuDescription(menuDescription, workbenchContext);
        return menuDescription;
    }

    protected abstract void addToMapAsMenuDescription(MenuDescription var1, WorkbenchContext var2);

    protected ToggleFrameworkAction getMapAsUnmappedAction(WorkbenchContext workbenchContext) {
        return new MapAsUnmappedAction(workbenchContext);
    }

    protected final ToggleMenuItemDescription buildUnmappedMenuItem(WorkbenchContext workbenchContext) {
        return new ToggleMenuItemDescription(this.getMapAsUnmappedAction(workbenchContext));
    }

    protected final ToggleToolBarButtonDescription buildUnmappedToolBarButton(WorkbenchContext workbenchContext) {
        return new ToggleToolBarButtonDescription(this.getMapAsUnmappedAction(workbenchContext));
    }

    private FrameworkAction getRemoveAction(WorkbenchContext workbenchContext) {
        return new RemoveAction(workbenchContext);
    }

    private static class RemoveAction
    extends AbstractEnablableFrameworkAction {
        RemoveAction(WorkbenchContext workbenchContext) {
            super(workbenchContext);
        }

        protected void initialize() {
            super.initialize();
            this.initializeIcon("remove");
            this.initializeTextAndMnemonic("REMOVE_ACTION");
            this.initializeToolTipText("REMOVE_ACTION.toolTipText");
        }

        protected void execute() {
            if (!this.confirmRemoval()) {
                return;
            }
            ApplicationNode[] applicationNodeArray = this.selectedNodes();
            for (int i = 0; i < applicationNodeArray.length; ++i) {
                ((MappingNode)applicationNodeArray[i]).remove();
            }
        }

        private boolean confirmRemoval() {
            return 0 == JOptionPane.showConfirmDialog(this.getWorkbenchContext().getCurrentWindow(), new LabelArea(this.resourceRepository().getString("REMOVE_MAPPING_ACTION_DIALOG.message", StringTools.CR)), this.resourceRepository().getString("REMOVE_MAPPING_ACTION_DIALOG.title"), 0);
        }

        protected boolean shouldBeEnabled(ApplicationNode applicationNode) {
            return true;
        }
    }
}

