/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.mapping.relational;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.Iterator;
import javax.swing.Action;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.eclipse.persistence.tools.workbench.framework.action.AbstractFrameworkAction;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.resources.ResourceRepository;
import org.eclipse.persistence.tools.workbench.framework.ui.view.ScrollablePropertiesPage;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWColumn;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWRelationalClassDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWRelationalDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational.MWColumnQueryKeyPair;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational.MWVariableOneToOneMapping;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.common.cell.ColumnCellRendererAdapter;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.mapping.relational.RelationalMappingComponentFactory;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SimplePropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SortedListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValuePropertyPropertyValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ColumnAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ComboBoxModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ListModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ObjectListSelectionModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.TableModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.cell.AdaptableListCellRenderer;
import org.eclipse.persistence.tools.workbench.uitools.cell.ComboBoxTableCellRenderer;
import org.eclipse.persistence.tools.workbench.uitools.cell.TableCellEditorAdapter;
import org.eclipse.persistence.tools.workbench.utility.Model;

final class VariableOneToOneQueryKeyAssociationsPanel
extends ScrollablePropertiesPage {
    private PropertyValueModel selectedFieldAssociationHolder;
    private ValueModel parentDescriptorHolder;
    private CollectionValueModel fieldQueryKeyAssociationsAdapter;
    private ObjectListSelectionModel rowSelectionModel;
    private ListValueModel queryKeyNamesHolder;
    private Action removeAction;

    VariableOneToOneQueryKeyAssociationsPanel(PropertyValueModel propertyValueModel, WorkbenchContextHolder workbenchContextHolder) {
        super(propertyValueModel, workbenchContextHolder);
    }

    protected void initialize(PropertyValueModel propertyValueModel) {
        super.initialize(propertyValueModel);
        this.parentDescriptorHolder = this.buildParentDescriptorHolder();
        this.queryKeyNamesHolder = this.buildSortedQueryKeyNamesHolder();
        this.fieldQueryKeyAssociationsAdapter = this.buildFieldQueryKeyAssociationsAdapter();
        this.selectedFieldAssociationHolder = new SimplePropertyValueModel(null);
        this.rowSelectionModel = this.buildRowSelectionModel();
    }

    private PropertyValueModel buildParentDescriptorHolder() {
        return new PropertyAspectAdapter(this.getSelectionHolder()){

            protected Object getValueFromSubject() {
                return ((MWVariableOneToOneMapping)this.subject).getParentDescriptor();
            }
        };
    }

    private ListValueModel buildSortedQueryKeyNamesHolder() {
        return new SortedListValueModelAdapter(this.buildQueryKeyNamesHolder());
    }

    private CollectionValueModel buildQueryKeyNamesHolder() {
        return new CollectionAspectAdapter(this.buildReferenceDescriptorHolder()){

            protected Iterator getValueFromSubject() {
                return ((MWRelationalDescriptor)this.subject).allQueryKeyNames();
            }
        };
    }

    private PropertyValueModel buildReferenceDescriptorHolder() {
        return new PropertyAspectAdapter(this.getSelectionHolder(), "referenceDescriptor"){

            protected Object getValueFromSubject() {
                return ((MWVariableOneToOneMapping)this.subject).getReferenceDescriptor();
            }
        };
    }

    private CollectionValueModel buildFieldQueryKeyAssociationsAdapter() {
        return new CollectionAspectAdapter(this.getSelectionHolder(), "columnQueryKeyPairs"){

            protected Iterator getValueFromSubject() {
                return ((MWVariableOneToOneMapping)this.subject).columnQueryKeyPairs();
            }

            protected int sizeFromSubject() {
                return ((MWVariableOneToOneMapping)this.subject).columnQueryKeyPairsSize();
            }
        };
    }

    private ObjectListSelectionModel buildRowSelectionModel() {
        ObjectListSelectionModel objectListSelectionModel = new ObjectListSelectionModel(new ListModelAdapter(this.fieldQueryKeyAssociationsAdapter));
        objectListSelectionModel.addListSelectionListener(this.buildRowSelectionListener());
        objectListSelectionModel.setSelectionMode(0);
        return objectListSelectionModel;
    }

    private ListSelectionListener buildRowSelectionListener() {
        return new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    VariableOneToOneQueryKeyAssociationsPanel.this.rowSelectionChanged();
                }
            }
        };
    }

    private void rowSelectionChanged() {
        Object object = this.rowSelectionModel.getSelectedValue();
        this.selectedFieldAssociationHolder.setValue(object);
        boolean bl = object != null;
        this.removeAction.setEnabled(bl);
    }

    protected Component buildPage() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel2 = this.buildButtonPanel();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 19;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        jPanel.add((Component)jPanel2, gridBagConstraints);
        JTable jTable = this.buildTable();
        JScrollPane jScrollPane = new JScrollPane(jTable);
        jScrollPane.getViewport().setPreferredSize(new Dimension(50, 50));
        jScrollPane.getViewport().setBackground(jTable.getBackground());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(5, 5, 5, 0);
        jPanel.add((Component)jScrollPane, gridBagConstraints);
        this.addHelpTopicId(jPanel, this.helpTopicId());
        return jPanel;
    }

    private JTable buildTable() {
        JTable jTable = SwingComponentFactory.buildTable(this.buildTableModel(), this.rowSelectionModel);
        int n = 20;
        TableColumn tableColumn = jTable.getColumnModel().getColumn(0);
        ComboBoxTableCellRenderer comboBoxTableCellRenderer = this.buildFieldComboBoxRenderer();
        tableColumn.setCellRenderer(comboBoxTableCellRenderer);
        tableColumn.setCellEditor(new TableCellEditorAdapter(this.buildFieldComboBoxRenderer()));
        n = Math.max(n, comboBoxTableCellRenderer.getPreferredHeight());
        TableColumn tableColumn2 = jTable.getColumnModel().getColumn(1);
        ComboBoxTableCellRenderer comboBoxTableCellRenderer2 = this.buildQueryKeyNameComboBoxRenderer();
        tableColumn2.setCellRenderer(comboBoxTableCellRenderer2);
        tableColumn2.setCellEditor(new TableCellEditorAdapter(this.buildQueryKeyNameComboBoxRenderer()));
        n = Math.max(n, comboBoxTableCellRenderer2.getPreferredHeight());
        jTable.setRowHeight(n);
        return jTable;
    }

    private TableModel buildTableModel() {
        return new TableModelAdapter(this.buildFieldQueryKeyAssociationsAdapter(), this.buildColumnAdapter());
    }

    private ColumnAdapter buildColumnAdapter() {
        return new FieldAssociationsColumnAdapter(this.getSelectionHolder(), this.resourceRepository());
    }

    private ListCellRenderer buildDatabaseFieldListCellRenderer() {
        return new AdaptableListCellRenderer(new ColumnCellRendererAdapter(this.resourceRepository()));
    }

    private ComboBoxTableCellRenderer buildFieldComboBoxRenderer() {
        return new ComboBoxTableCellRenderer(this.buildFieldComboBoxModel(), this.buildDatabaseFieldListCellRenderer());
    }

    private ComboBoxModel buildFieldComboBoxModel() {
        return RelationalMappingComponentFactory.buildExtendedColumnComboBoxModel(new SimplePropertyValueModel(), this.parentDescriptorHolder);
    }

    private ComboBoxTableCellRenderer buildQueryKeyNameComboBoxRenderer() {
        return new ComboBoxTableCellRenderer(this.buildQueryKeyNameComboBoxModel());
    }

    private ComboBoxModel buildQueryKeyNameComboBoxModel() {
        return new ComboBoxModelAdapter(this.queryKeyNamesHolder, (PropertyValueModel)new SimplePropertyValueModel());
    }

    private JPanel buildButtonPanel() {
        JPanel jPanel = new JPanel(new GridLayout(0, 1, 5, 5));
        jPanel.add(this.buildAddButton());
        jPanel.add(this.buildRemoveButton());
        return jPanel;
    }

    private JButton buildAddButton() {
        return new JButton(this.buildAddAction());
    }

    private Action buildAddAction() {
        AbstractFrameworkAction abstractFrameworkAction = new AbstractFrameworkAction(this.getApplicationContext()){

            protected void initialize() {
                this.initializeText("ADD_ASSOCIATION_BUTTON_TEXT");
                this.initializeMnemonic("ADD_ASSOCIATION_BUTTON_TEXT");
            }

            public void actionPerformed(ActionEvent actionEvent) {
                VariableOneToOneQueryKeyAssociationsPanel.this.addFieldQueryKeyNameAssociation();
            }
        };
        return abstractFrameworkAction;
    }

    private void addFieldQueryKeyNameAssociation() {
        MWColumn mWColumn = null;
        MWRelationalClassDescriptor mWRelationalClassDescriptor = (MWRelationalClassDescriptor)this.getParentDescriptor();
        if (!mWRelationalClassDescriptor.isAggregateDescriptor() && mWRelationalClassDescriptor.allAssociatedColumns().hasNext()) {
            mWColumn = (MWColumn)mWRelationalClassDescriptor.allAssociatedColumns().next();
        }
        String string = "";
        if (this.queryKeyNamesHolder.size() > 0) {
            string = (String)this.queryKeyNamesHolder.getItem(0);
        }
        this.getVariableOneToOneMapping().addColumnQueryKeyPair(mWColumn, string);
    }

    private MWVariableOneToOneMapping getVariableOneToOneMapping() {
        return (MWVariableOneToOneMapping)this.selection();
    }

    private JButton buildRemoveButton() {
        return new JButton(this.buildRemoveAction());
    }

    private Action buildRemoveAction() {
        this.removeAction = new AbstractFrameworkAction(this.getApplicationContext()){

            protected void initialize() {
                this.initializeTextAndMnemonic("REMOVE_ASSOCIATION_BUTTON_TEXT");
            }

            public void actionPerformed(ActionEvent actionEvent) {
                VariableOneToOneQueryKeyAssociationsPanel.this.removeFieldQueryKeyNameAssociation();
            }
        };
        this.removeAction.setEnabled(false);
        return this.removeAction;
    }

    private void removeFieldQueryKeyNameAssociation() {
        MWColumnQueryKeyPair mWColumnQueryKeyPair;
        int n = JOptionPane.showConfirmDialog(this.getWorkbenchContext().getCurrentWindow(), this.resourceRepository().getString("REMOVE_FIELD_ASSOCIATIONS_WARNING_DIALOG.message"), this.resourceRepository().getString("REMOVE_FIELD_ASSOCIATIONS_WARNING_DIALOG.title"), 0, 3);
        if (n == 0 && (mWColumnQueryKeyPair = this.selectedAssociation()) != null) {
            this.getVariableOneToOneMapping().removeColumnQueryKeyPair(mWColumnQueryKeyPair);
        }
    }

    private MWColumnQueryKeyPair selectedAssociation() {
        if (this.rowSelectionModel.isSelectionEmpty()) {
            return null;
        }
        return (MWColumnQueryKeyPair)this.rowSelectionModel.getSelectedValue();
    }

    protected String helpTopicId() {
        return "mapping.variableOneToOne.queryKeyAssociations";
    }

    private MWRelationalDescriptor getParentDescriptor() {
        return (MWRelationalDescriptor)((MWVariableOneToOneMapping)this.selection()).getParentDescriptor();
    }

    public static class FieldAssociationsColumnAdapter
    implements ColumnAdapter {
        private PropertyValueModel selectionHolder;
        private ResourceRepository resourceRepository;
        public static final int COLUMN_COUNT = 2;
        public static final int FIELD_COLUMN = 0;
        public static final int QUERY_KEY_NAME_COLUMN = 1;
        private final String[] COLUMN_NAME_KEYS = new String[]{"FIELD_COLUMN_HEADER", "QUERY_KEY_NAME_COLUMN_HEADER"};

        protected FieldAssociationsColumnAdapter(PropertyValueModel propertyValueModel, ResourceRepository resourceRepository) {
            this.selectionHolder = propertyValueModel;
            this.resourceRepository = resourceRepository;
        }

        private MWVariableOneToOneMapping mapping() {
            return (MWVariableOneToOneMapping)this.selectionHolder.getValue();
        }

        public int getColumnCount() {
            return 2;
        }

        public String getColumnName(int n) {
            return this.resourceRepository.getString(this.COLUMN_NAME_KEYS[n]);
        }

        public Class getColumnClass(int n) {
            switch (n) {
                case 0: {
                    return Object.class;
                }
                case 1: {
                    return Object.class;
                }
            }
            return Object.class;
        }

        public boolean isColumnEditable(int n) {
            return n != 0 || !this.mapping().parentDescriptorIsAggregate();
        }

        public PropertyValueModel[] cellModels(Object object) {
            MWColumnQueryKeyPair mWColumnQueryKeyPair = (MWColumnQueryKeyPair)object;
            PropertyValueModel[] propertyValueModelArray = new PropertyValueModel[]{this.buildFieldAdapter(mWColumnQueryKeyPair), this.buildTargetFieldAdapter(mWColumnQueryKeyPair)};
            return propertyValueModelArray;
        }

        private PropertyValueModel buildFieldAdapter(MWColumnQueryKeyPair mWColumnQueryKeyPair) {
            PropertyAspectAdapter propertyAspectAdapter = new PropertyAspectAdapter("column", (Model)mWColumnQueryKeyPair){

                protected Object getValueFromSubject() {
                    return ((MWColumnQueryKeyPair)this.subject).getColumn();
                }

                protected void setValueOnSubject(Object object) {
                    ((MWColumnQueryKeyPair)this.subject).setColumn((MWColumn)object);
                }
            };
            return new ValuePropertyPropertyValueModelAdapter((PropertyValueModel)propertyAspectAdapter, "name");
        }

        private PropertyValueModel buildTargetFieldAdapter(MWColumnQueryKeyPair mWColumnQueryKeyPair) {
            return new PropertyAspectAdapter("queryKeyName", (Model)mWColumnQueryKeyPair){

                protected Object getValueFromSubject() {
                    return ((MWColumnQueryKeyPair)this.subject).getQueryKeyName();
                }

                protected void setValueOnSubject(Object object) {
                    ((MWColumnQueryKeyPair)this.subject).setQueryKeyName((String)object);
                }
            };
        }
    }
}

