/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.mapping.xml;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonModel;
import javax.swing.ComboBoxModel;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.ListCellRenderer;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.chooser.DefaultListChooser;
import org.eclipse.persistence.tools.workbench.framework.ui.chooser.DefaultListChooserDialog;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.AccessibleTitledBorder;
import org.eclipse.persistence.tools.workbench.framework.uitools.AccessibleTitledPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingTools;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClassAttribute;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWMethod;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.common.cell.ClassAttributeCellRendererAdapter;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.common.cell.MethodCellRendererAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ReadOnlyCollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SortedListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ComboBoxModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.RadioButtonModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.cell.AdaptableListCellRenderer;
import org.eclipse.persistence.tools.workbench.uitools.chooser.ListChooser;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.string.StringConverter;

public class AccessorEditingPanel
extends AbstractPanel {
    private AccessorSpec accessorSpec;

    public AccessorEditingPanel(AccessorSpec accessorSpec, WorkbenchContextHolder workbenchContextHolder) {
        super(workbenchContextHolder);
        this.accessorSpec = accessorSpec;
        this.initializeLayout();
    }

    private void initializeLayout() {
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JRadioButton jRadioButton = this.buildMethodsButton();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)jRadioButton, gridBagConstraints);
        JPanel jPanel = this.buildMethodsChooserPanel();
        jPanel.setBorder(new AccessibleTitledBorder(jRadioButton.getText()));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(5, SwingTools.checkBoxIconWidth(), 0, 0);
        this.add((Component)jPanel, gridBagConstraints);
        JRadioButton jRadioButton2 = this.buildAttributeButton();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.add((Component)jRadioButton2, gridBagConstraints);
        JPanel jPanel2 = this.buildAttributeChooserPanel();
        jPanel2.setBorder(new AccessibleTitledBorder(jRadioButton2.getText()));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 19;
        gridBagConstraints.insets = new Insets(5, SwingTools.checkBoxIconWidth(), 0, 0);
        this.add((Component)jPanel2, gridBagConstraints);
    }

    private JRadioButton buildMethodsButton() {
        JRadioButton jRadioButton = new JRadioButton();
        jRadioButton.setModel(this.buildMethodsButtonModel());
        jRadioButton.setText(this.resourceRepository().getString("ACCESSOR_PANEL_METHODS_BUTTON"));
        jRadioButton.setMnemonic(this.resourceRepository().getMnemonic("ACCESSOR_PANEL_METHODS_BUTTON"));
        return jRadioButton;
    }

    private JRadioButton buildAttributeButton() {
        JRadioButton jRadioButton = new JRadioButton();
        jRadioButton.setModel(this.buildAttributeButtonModel());
        jRadioButton.setText(this.resourceRepository().getString("ACCESSOR_PANEL_ATTRIBUTE_BUTTON"));
        jRadioButton.setMnemonic(this.resourceRepository().getMnemonic("ACCESSOR_PANEL_ATTRIBUTE_BUTTON"));
        return jRadioButton;
    }

    private ButtonModel buildAttributeButtonModel() {
        return new RadioButtonModelAdapter(this.accessorSpec.accessorTypeHolder(), "accessorAttribute");
    }

    private ButtonModel buildMethodsButtonModel() {
        return new RadioButtonModelAdapter(this.accessorSpec.accessorTypeHolder(), "accessorMethods");
    }

    private JPanel buildMethodsChooserPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 2));
        JLabel jLabel = this.buildGetMethodChooserLabel();
        jPanel.add(jLabel);
        this.addAlignLeft(jLabel);
        ListChooser listChooser = this.buildGetMethodChooser();
        jLabel.setLabelFor(listChooser);
        jPanel.add(listChooser);
        jPanel.add(Box.createRigidArea(new Dimension(10, 0)));
        JLabel jLabel2 = this.buildSetMethodChooserLabel();
        jPanel.add(jLabel2);
        this.addAlignLeft(jLabel2);
        ListChooser listChooser2 = this.buildSetMethodChooser();
        jLabel2.setLabelFor(listChooser2);
        jPanel.add(listChooser2);
        return jPanel;
    }

    private JLabel buildGetMethodChooserLabel() {
        JLabel jLabel = this.buildLabel("ACCESSOR_PANEL_GET_METHOD_CHOOSER");
        this.accessorSpec.accessorTypeHolder().addPropertyChangeListener("value", this.buildComponentEnablingListener(jLabel, "accessorMethods"));
        jLabel.setEnabled(this.accessorSpec.accessorTypeHolder().getValue() == "accessorMethods");
        return jLabel;
    }

    private ListChooser buildGetMethodChooser() {
        DefaultListChooser defaultListChooser = new DefaultListChooser(this.buildGetMethodChooserModel(), this.getWorkbenchContextHolder(), this.buildMethodChooserDialogBuilder());
        defaultListChooser.setRenderer(this.buildMethodRenderer());
        this.accessorSpec.accessorTypeHolder().addPropertyChangeListener("value", this.buildComponentEnablingListener(defaultListChooser, "accessorMethods"));
        defaultListChooser.setEnabled(this.accessorSpec.accessorTypeHolder().getValue() == "accessorMethods");
        return defaultListChooser;
    }

    private ComboBoxModel buildGetMethodChooserModel() {
        return new ComboBoxModelAdapter(this.buildMethodChoicesValue(), this.accessorSpec.accessorGetMethodHolder());
    }

    private ListValueModel buildMethodChoicesValue() {
        return new SortedListValueModelAdapter(new ReadOnlyCollectionValueModel(CollectionTools.collection((Iterator)this.accessorSpec.candidateAccessorMethods())));
    }

    private DefaultListChooserDialog.Builder buildMethodChooserDialogBuilder() {
        DefaultListChooserDialog.Builder builder = new DefaultListChooserDialog.Builder();
        builder.setStringConverter(this.buildMWMethodStringConverter());
        return builder;
    }

    private StringConverter buildMWMethodStringConverter() {
        return new StringConverter(){

            public String convertToString(Object object) {
                return object == null ? "" : ((MWMethod)object).shortSignatureWithReturnType();
            }
        };
    }

    private ListCellRenderer buildMethodRenderer() {
        return new AdaptableListCellRenderer(new MethodCellRendererAdapter(this.resourceRepository()){

            protected Icon buildNonNullValueIcon(Object object) {
                return null;
            }
        });
    }

    private JLabel buildSetMethodChooserLabel() {
        JLabel jLabel = this.buildLabel("ACCESSOR_PANEL_SET_METHOD_CHOOSER");
        this.accessorSpec.accessorTypeHolder().addPropertyChangeListener("value", this.buildComponentEnablingListener(jLabel, "accessorMethods"));
        jLabel.setEnabled(this.accessorSpec.accessorTypeHolder().getValue() == "accessorMethods");
        return jLabel;
    }

    private ListChooser buildSetMethodChooser() {
        DefaultListChooser defaultListChooser = new DefaultListChooser(this.buildSetMethodChooserModel(), this.getWorkbenchContextHolder(), this.buildMethodChooserDialogBuilder());
        defaultListChooser.setRenderer(this.buildMethodRenderer());
        this.accessorSpec.accessorTypeHolder().addPropertyChangeListener("value", this.buildComponentEnablingListener(defaultListChooser, "accessorMethods"));
        defaultListChooser.setEnabled(this.accessorSpec.accessorTypeHolder().getValue() == "accessorMethods");
        return defaultListChooser;
    }

    private ComboBoxModel buildSetMethodChooserModel() {
        return new ComboBoxModelAdapter(this.buildMethodChoicesValue(), this.accessorSpec.accessorSetMethodHolder());
    }

    private PropertyChangeListener buildComponentEnablingListener(final Component component, final String string) {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                component.setEnabled(propertyChangeEvent.getNewValue() == string);
            }
        };
    }

    private JPanel buildAttributeChooserPanel() {
        AccessibleTitledPanel accessibleTitledPanel = new AccessibleTitledPanel(new BorderLayout(5, 0));
        JLabel jLabel = this.buildAttributeChooserLabel();
        accessibleTitledPanel.add((Component)jLabel, "Before");
        this.addAlignLeft(jLabel);
        ListChooser listChooser = this.buildAttributeChooser();
        jLabel.setLabelFor(listChooser);
        accessibleTitledPanel.add((Component)listChooser, "Center");
        return accessibleTitledPanel;
    }

    private JLabel buildAttributeChooserLabel() {
        JLabel jLabel = new JLabel(this.resourceRepository().getString("ACCESSOR_PANEL_ATTRIBUTE_CHOOSER"));
        jLabel.setDisplayedMnemonic(this.resourceRepository().getMnemonic("ACCESSOR_PANEL_ATTRIBUTE_CHOOSER"));
        this.accessorSpec.accessorTypeHolder().addPropertyChangeListener("value", this.buildComponentEnablingListener(jLabel, "accessorAttribute"));
        jLabel.setEnabled(this.accessorSpec.accessorTypeHolder().getValue() == "accessorAttribute");
        return jLabel;
    }

    private ListChooser buildAttributeChooser() {
        DefaultListChooser defaultListChooser = new DefaultListChooser(this.buildAttributeChooserModel(), this.getWorkbenchContextHolder(), this.buildAttributeChooserDialogBuilder());
        defaultListChooser.setRenderer(this.buildAttributeRenderer());
        this.accessorSpec.accessorTypeHolder().addPropertyChangeListener("value", this.buildComponentEnablingListener(defaultListChooser, "accessorAttribute"));
        defaultListChooser.setEnabled(this.accessorSpec.accessorTypeHolder().getValue() == "accessorAttribute");
        return defaultListChooser;
    }

    private ComboBoxModel buildAttributeChooserModel() {
        return new ComboBoxModelAdapter(this.buildAttributeChoicesValue(), this.accessorSpec.accessorAttributeHolder());
    }

    private ListValueModel buildAttributeChoicesValue() {
        return new SortedListValueModelAdapter(new ReadOnlyCollectionValueModel(CollectionTools.collection((Iterator)this.accessorSpec.candidateAccessorAttributes())));
    }

    private DefaultListChooserDialog.Builder buildAttributeChooserDialogBuilder() {
        DefaultListChooserDialog.Builder builder = new DefaultListChooserDialog.Builder();
        builder.setStringConverter(this.buildMWClassAttributeStringConverter());
        return builder;
    }

    private StringConverter buildMWClassAttributeStringConverter() {
        return new StringConverter(){

            public String convertToString(Object object) {
                return object == null ? "" : ((MWClassAttribute)object).getName();
            }
        };
    }

    private ListCellRenderer buildAttributeRenderer() {
        return new AdaptableListCellRenderer(new ClassAttributeCellRendererAdapter(this.resourceRepository()){

            protected Icon buildNonNullValueIcon(Object object) {
                return null;
            }
        });
    }

    public static interface AccessorSpec {
        public static final String ACCESSOR_METHODS = "accessorMethods";
        public static final String ACCESSOR_ATTRIBUTE = "accessorAttribute";
        public static final String NULL_ACCESSOR = "nullAccessor";

        public PropertyValueModel accessorTypeHolder();

        public String accessorType();

        public PropertyValueModel accessorGetMethodHolder();

        public MWMethod accessorGetMethod();

        public PropertyValueModel accessorSetMethodHolder();

        public MWMethod accessorSetMethod();

        public Iterator candidateAccessorMethods();

        public Iterator candidateAccessorAttributes();

        public PropertyValueModel accessorAttributeHolder();

        public MWClassAttribute accessorAttribute();
    }
}

