/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.mapping.xml;

import javax.swing.JCheckBox;
import javax.swing.JLabel;
import org.eclipse.persistence.tools.workbench.framework.context.ApplicationContext;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.resources.ResourceRepository;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.xml.MWAbstractAnyMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.xml.MWXmlElementTypeableMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.xml.MWXmlMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWComplexTypeDefinition;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWXmlSchema;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.mapping.MappingComponentFactory;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.xml.SchemaComplexTypeChooser;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.xml.SchemaValue;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.CheckBoxModelAdapter;

public class XmlMappingComponentFactory
extends MappingComponentFactory {
    public static JCheckBox buildWildcardCheckBox(ValueModel valueModel, ApplicationContext applicationContext) {
        JCheckBox jCheckBox = XmlMappingComponentFactory.buildCheckBox("WILDCARD_CHECK_BOX", new CheckBoxModelAdapter(XmlMappingComponentFactory.buildWildcardHolder(valueModel)), applicationContext.getResourceRepository());
        applicationContext.getHelpManager().addTopicID(jCheckBox, "mapping.wildcard");
        return jCheckBox;
    }

    private static PropertyValueModel buildWildcardHolder(ValueModel valueModel) {
        return new PropertyAspectAdapter(valueModel, "wildcardMapping"){

            protected Object getValueFromSubject() {
                return ((MWAbstractAnyMapping)this.subject).isWildcardMapping();
            }

            protected void setValueOnSubject(Object object) {
                ((MWAbstractAnyMapping)this.subject).setWildcardMapping(((Boolean)object).booleanValue());
            }
        };
    }

    static JLabel buildElementTypeLabel(ResourceRepository resourceRepository) {
        return XmlMappingComponentFactory.buildLabel("ELEMENT_TYPE_LABEL", resourceRepository);
    }

    static SchemaComplexTypeChooser buildElementTypeChooser(ValueModel valueModel, WorkbenchContextHolder workbenchContextHolder, JLabel jLabel, String string) {
        return new SchemaComplexTypeChooser(workbenchContextHolder, XmlMappingComponentFactory.buildSchemaValue(valueModel), XmlMappingComponentFactory.buildElementTypeHolder(valueModel, string), jLabel);
    }

    private static SchemaValue buildSchemaValue(final ValueModel valueModel) {
        return new SchemaValue(){

            public MWXmlSchema schema() {
                return XmlMappingComponentFactory.schemaContextSchema(valueModel);
            }
        };
    }

    private static MWXmlSchema schemaContextSchema(ValueModel valueModel) {
        return ((MWXmlMapping)valueModel.getValue()).schemaContext() == null ? null : ((MWXmlMapping)valueModel.getValue()).schemaContext().getSchema();
    }

    private static PropertyValueModel buildElementTypeHolder(ValueModel valueModel, String string) {
        return new PropertyAspectAdapter(valueModel, string){

            protected Object getValueFromSubject() {
                return ((MWXmlElementTypeableMapping)this.subject).getElementType();
            }

            protected void setValueOnSubject(Object object) {
                ((MWXmlElementTypeableMapping)this.subject).setElementType((MWComplexTypeDefinition)object);
            }
        };
    }
}

