/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.meta;

import javax.swing.JLabel;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.chooser.ClassChooserDialog;
import org.eclipse.persistence.tools.workbench.framework.ui.chooser.ClassChooserPanel;
import org.eclipse.persistence.tools.workbench.framework.ui.chooser.ClassDescriptionAdapter;
import org.eclipse.persistence.tools.workbench.framework.ui.chooser.ClassDescriptionRepository;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClass;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClassRepository;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.meta.ClassDescription;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.meta.ClassDescriptionClassDescriptionAdapter;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.meta.ClassRepositoryHolder;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.meta.CombinedClassDescriptionRepository;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.meta.CombinedClassDescriptionRepositoryFactory;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.TransformationPropertyValueModel;
import org.eclipse.persistence.tools.workbench.utility.BidiTransformer;
import org.eclipse.persistence.tools.workbench.utility.ClassTools;
import org.eclipse.persistence.tools.workbench.utility.filters.ANDFilter;
import org.eclipse.persistence.tools.workbench.utility.filters.Filter;

public class ClassChooserTools {
    public static MWClass promptForType(MWClassRepository mWClassRepository, Filter filter, WorkbenchContext workbenchContext) {
        CombinedClassDescriptionRepository combinedClassDescriptionRepository = new CombinedClassDescriptionRepository(mWClassRepository, filter);
        ClassDescriptionAdapter classDescriptionAdapter = ClassDescriptionClassDescriptionAdapter.instance();
        String string = ClassChooserTools.promptForType(combinedClassDescriptionRepository, classDescriptionAdapter, workbenchContext);
        if (string == null) {
            return null;
        }
        return mWClassRepository.typeNamed(string);
    }

    public static String promptForType(ClassDescriptionRepository classDescriptionRepository, ClassDescriptionAdapter classDescriptionAdapter, WorkbenchContext workbenchContext) {
        ClassChooserDialog classChooserDialog = ClassChooserDialog.createDialog(classDescriptionRepository, classDescriptionAdapter, workbenchContext);
        classChooserDialog.show();
        if (classChooserDialog.wasCanceled()) {
            classChooserDialog = null;
            ClassChooserDialog.gc();
            return null;
        }
        Object object = classChooserDialog.selection();
        classChooserDialog = null;
        ClassChooserDialog.gc();
        return object == null ? null : classDescriptionAdapter.className(object);
    }

    public static ClassChooserPanel buildPanel(PropertyValueModel propertyValueModel, ClassRepositoryHolder classRepositoryHolder, Filter filter, WorkbenchContextHolder workbenchContextHolder) {
        TransformationPropertyValueModel transformationPropertyValueModel = new TransformationPropertyValueModel(propertyValueModel, new ClassDescriptionTransformer(classRepositoryHolder));
        CombinedClassDescriptionRepositoryFactory combinedClassDescriptionRepositoryFactory = new CombinedClassDescriptionRepositoryFactory(classRepositoryHolder, filter);
        ClassDescriptionAdapter classDescriptionAdapter = ClassDescriptionClassDescriptionAdapter.instance();
        return new ClassChooserPanel(transformationPropertyValueModel, combinedClassDescriptionRepositoryFactory, classDescriptionAdapter, workbenchContextHolder);
    }

    public static ClassChooserPanel buildPanel(PropertyValueModel propertyValueModel, ClassRepositoryHolder classRepositoryHolder, Filter filter, JLabel jLabel, WorkbenchContextHolder workbenchContextHolder) {
        TransformationPropertyValueModel transformationPropertyValueModel = new TransformationPropertyValueModel(propertyValueModel, new ClassDescriptionTransformer(classRepositoryHolder));
        CombinedClassDescriptionRepositoryFactory combinedClassDescriptionRepositoryFactory = new CombinedClassDescriptionRepositoryFactory(classRepositoryHolder, filter);
        ClassDescriptionAdapter classDescriptionAdapter = ClassDescriptionClassDescriptionAdapter.instance();
        return new ClassChooserPanel(transformationPropertyValueModel, combinedClassDescriptionRepositoryFactory, classDescriptionAdapter, jLabel, workbenchContextHolder);
    }

    public static ClassChooserPanel buildPanel(PropertyValueModel propertyValueModel, ClassRepositoryHolder classRepositoryHolder, Filter filter, JLabel jLabel, WorkbenchContextHolder workbenchContextHolder, String string) {
        TransformationPropertyValueModel transformationPropertyValueModel = new TransformationPropertyValueModel(propertyValueModel, new ClassDescriptionTransformer(classRepositoryHolder));
        CombinedClassDescriptionRepositoryFactory combinedClassDescriptionRepositoryFactory = new CombinedClassDescriptionRepositoryFactory(classRepositoryHolder, filter);
        ClassDescriptionAdapter classDescriptionAdapter = ClassDescriptionClassDescriptionAdapter.instance();
        return new ClassChooserPanel(transformationPropertyValueModel, combinedClassDescriptionRepositoryFactory, classDescriptionAdapter, jLabel, workbenchContextHolder, string);
    }

    public static Filter buildDeclarableReferenceFilter() {
        Filter filter = ClassChooserTools.buildDeclarableFilter();
        Filter filter2 = ClassChooserTools.buildReferenceFilter();
        return new ANDFilter(filter, filter2);
    }

    public static Filter buildDeclarableNonVoidFilter() {
        Filter filter = ClassChooserTools.buildDeclarableFilter();
        Filter filter2 = ClassChooserTools.buildNonVoidFilter();
        return new ANDFilter(filter, filter2);
    }

    public static Filter buildDeclarableFilter() {
        return new Filter(){

            public boolean accept(Object object) {
                return ClassTools.classNamedIsDeclarable((String)((String)object));
            }

            public String toString() {
                return "declarable filter";
            }
        };
    }

    public static Filter buildReferenceFilter() {
        return new Filter(){

            public boolean accept(Object object) {
                return ClassTools.classNamedIsReference((String)((String)object));
            }

            public String toString() {
                return "reference filter";
            }
        };
    }

    public static Filter buildNonVoidFilter() {
        return new Filter(){

            public boolean accept(Object object) {
                return !object.equals("void");
            }

            public String toString() {
                return "non-void filter";
            }
        };
    }

    public static class ClassDescriptionTransformer
    implements BidiTransformer {
        private ClassRepositoryHolder classRepositoryHolder;

        public ClassDescriptionTransformer(ClassRepositoryHolder classRepositoryHolder) {
            this.classRepositoryHolder = classRepositoryHolder;
        }

        public Object transform(Object object) {
            return object;
        }

        public Object reverseTransform(Object object) {
            return object == null ? null : this.classRepositoryHolder.getClassRepository().typeNamed(((ClassDescription)object).getName());
        }
    }
}

