/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWQueryParameter;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.QueryParametersPanel;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SimplePropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ComboBoxModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ObjectListSelectionModel;
import org.eclipse.persistence.tools.workbench.utility.TriStateBoolean;
import org.eclipse.persistence.tools.workbench.utility.iterators.TransformationIterator;

public final class QueryGeneralPanel
extends AbstractPanel {
    private PropertyValueModel queryHolder;
    private QueryParametersPanel queryParametersPanel;

    public QueryGeneralPanel(PropertyValueModel propertyValueModel, ObjectListSelectionModel objectListSelectionModel, WorkbenchContextHolder workbenchContextHolder) {
        super(workbenchContextHolder);
        this.queryHolder = propertyValueModel;
        this.initializeLayout(objectListSelectionModel);
    }

    private MWQuery getQuery() {
        return (MWQuery)this.queryHolder.getValue();
    }

    public String helpTopicId() {
        return "descriptor.queries.general";
    }

    private void initializeLayout(ObjectListSelectionModel objectListSelectionModel) {
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.initializeQueryTypePanel(objectListSelectionModel);
        this.initializeParametersPanel();
        this.addHelpTopicId(this, this.helpTopicId());
    }

    private void initializeParametersPanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.queryParametersPanel = new QueryParametersPanel(this.queryHolder, this.getWorkbenchContextHolder());
        this.queryParametersPanel.setBorder(this.buildTitledBorder("QUERY_PARAMETERS_TABLE_TITLE"));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.add((Component)this.queryParametersPanel, gridBagConstraints);
    }

    private void initializeQueryTypePanel(ObjectListSelectionModel objectListSelectionModel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel(new GridBagLayout());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)jPanel, gridBagConstraints);
        JLabel jLabel = this.buildQueryTypeLabel();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)jLabel, gridBagConstraints);
        JComboBox jComboBox = this.buildQueryTypeComboBox(objectListSelectionModel);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        jPanel.add((Component)jComboBox, gridBagConstraints);
        jLabel.setLabelFor(jComboBox);
        this.addHelpTopicId(jPanel, this.helpTopicId() + ".type");
    }

    private JLabel buildQueryTypeLabel() {
        JLabel jLabel = this.buildLabel("QUERY_TYPE_COMBO_BOX_LABEL");
        this.queryHolder.addPropertyChangeListener("value", this.buildQueryTypeLabelListener(jLabel));
        return jLabel;
    }

    private PropertyChangeListener buildQueryTypeLabelListener(final JLabel jLabel) {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                jLabel.setEnabled(QueryGeneralPanel.this.getQuery() != null);
            }
        };
    }

    private JComboBox buildQueryTypeComboBox(ObjectListSelectionModel objectListSelectionModel) {
        JComboBox jComboBox = new JComboBox(new ComboBoxModelAdapter(this.buildQueryTypeValueModel(), this.buildQueryTypePropertyAdapter(objectListSelectionModel)));
        jComboBox.setEnabled(false);
        jComboBox.setEditable(false);
        this.queryHolder.addPropertyChangeListener(this.buildQueryTypeChooserListener(jComboBox));
        return jComboBox;
    }

    private CollectionValueModel buildQueryTypeValueModel() {
        return new CollectionAspectAdapter(this.queryHolder){

            protected Iterator getValueFromSubject() {
                return new TransformationIterator(((MWQuery)this.subject).queryTypes()){

                    protected Object transform(Object object) {
                        return QueryGeneralPanel.this.resourceRepository().getString((String)object);
                    }
                };
            }
        };
    }

    private boolean queryTypeCanChange() {
        boolean bl;
        String string = TriStateBoolean.UNDEFINED.toString();
        String string2 = this.preferences().get("query change query type", string);
        if (string2.equals(string)) {
            bl = this.promptToChangeQueryType();
        } else {
            bl = TriStateBoolean.TRUE.toString().equals(string2);
            if (!bl) {
                JOptionPane.showMessageDialog(this.getWorkbenchContext().getCurrentWindow(), this.resourceRepository().getString("QUERY_TYPE_CHANGE_DISSALLOWED"));
            }
        }
        return bl;
    }

    private boolean promptToChangeQueryType() {
        if (this.preferences().getBoolean("query change query type", false)) {
            return true;
        }
        String string = this.resourceRepository().getString("QUERY_CHANGE_QUERY_TYPE_TITLE");
        String string2 = this.resourceRepository().getString("QUERY_CHANGE_QUERY_TYPE_MESSAGE");
        SimplePropertyValueModel simplePropertyValueModel = new SimplePropertyValueModel(new Boolean(false));
        JComponent jComponent = SwingComponentFactory.buildDoNotAskAgainPanel(string2, simplePropertyValueModel, this.resourceRepository());
        JOptionPane jOptionPane = new JOptionPane(jComponent, 2, 0);
        JDialog jDialog = jOptionPane.createDialog(this.getWorkbenchContext().getCurrentWindow(), string);
        jDialog.setSize(400, 150);
        jDialog.setResizable(false);
        jDialog.show();
        jDialog.dispose();
        int n = -1;
        Object object = jOptionPane.getValue();
        if (object != null && object instanceof Integer) {
            n = (Integer)object;
        }
        if (simplePropertyValueModel.getValue().equals(Boolean.TRUE)) {
            if (n == 0) {
                this.preferences().putBoolean("query change query type", true);
            } else if (n == 1) {
                this.preferences().putBoolean("query change query type", false);
            }
        }
        return n == 0;
    }

    private PropertyValueModel buildQueryTypePropertyAdapter(final ObjectListSelectionModel objectListSelectionModel) {
        return new PropertyAspectAdapter(this.queryHolder){

            protected Object getValueFromSubject() {
                return QueryGeneralPanel.this.resourceRepository().getString(((MWQuery)this.subject).queryType());
            }

            protected void setValueOnSubject(Object object) {
                if (!QueryGeneralPanel.this.queryTypeCanChange()) {
                    return;
                }
                Object object2 = object == QueryGeneralPanel.this.resourceRepository().getString("REPORT_QUERY") ? QueryGeneralPanel.this.getQuery().asReportQuery() : (object == QueryGeneralPanel.this.resourceRepository().getString("READ_ALL_QUERY") ? QueryGeneralPanel.this.getQuery().asReadAllQuery() : QueryGeneralPanel.this.getQuery().asReadObjectQuery());
                objectListSelectionModel.setSelectedValue(object2);
            }
        };
    }

    private PropertyChangeListener buildQueryTypeChooserListener(final JComboBox jComboBox) {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (QueryGeneralPanel.this.getQuery() == null) {
                    jComboBox.setEnabled(false);
                } else {
                    jComboBox.setEnabled(true);
                }
            }
        };
    }

    protected void selectParameter(MWQueryParameter mWQueryParameter) {
        this.queryParametersPanel.selectParameter(mWQueryParameter);
    }
}

