/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.eclipse.persistence.tools.workbench.framework.context.ApplicationContext;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWAutoGeneratedQueryFormat;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWEJBQLQueryFormat;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWExpressionQueryFormat;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWQueryFormat;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWRelationalQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWSQLQueryFormat;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational.ExpressionQueryFormatSubPanel;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational.QueryFormatSubPanel;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational.StringQueryFormatSubPanel;
import org.eclipse.persistence.tools.workbench.uitools.ComponentEnabler;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ReadOnlyCollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SimplePropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ComboBoxModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.cell.SimpleListCellRenderer;
import org.eclipse.persistence.tools.workbench.utility.TriStateBoolean;

final class QuerySelectionCriteriaPanel
extends AbstractPanel {
    private PropertyValueModel queryHolder;
    private PropertyValueModel relationalOptionsHolder;
    private PropertyValueModel queryFormatHolder;
    private AbstractQueryFormatPanel activeQueryFormatPanel;
    private AutoGeneratedQueryFormatPanel autoGeneratedQueryFormatPanel;
    private NonAutoGeneratedQueryFormatPanel nonAutoGeneratedQueryFormatPanel;
    private Map queryFormatPanelMap;

    QuerySelectionCriteriaPanel(PropertyValueModel propertyValueModel, WorkbenchContextHolder workbenchContextHolder) {
        super(workbenchContextHolder);
        this.queryHolder = propertyValueModel;
        this.relationalOptionsHolder = this.buildRelationalOptionsHolder();
        this.queryFormatHolder = this.buildQueryFormatHolder();
        this.queryFormatHolder.addPropertyChangeListener("value", this.buildQueryFormatListener());
        this.initializeLayout();
        this.initializeMaps();
    }

    private PropertyValueModel buildQueryFormatHolder() {
        return new PropertyAspectAdapter(this.relationalOptionsHolder, "queryFormatType"){

            protected Object getValueFromSubject() {
                return ((MWRelationalQuery)this.subject).getQueryFormat();
            }
        };
    }

    private PropertyValueModel buildRelationalOptionsHolder() {
        return new PropertyAspectAdapter(this.queryHolder){

            protected Object getValueFromSubject() {
                return ((MWRelationalQuery)this.subject).getRelationalOptions();
            }
        };
    }

    private PropertyChangeListener buildQueryFormatListener() {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                MWQueryFormat mWQueryFormat = QuerySelectionCriteriaPanel.this.getQueryFormat();
                if (mWQueryFormat != null) {
                    QuerySelectionCriteriaPanel.this.setActiveQueryFormatPanel((AbstractQueryFormatPanel)QuerySelectionCriteriaPanel.this.queryFormatPanelMap.get(mWQueryFormat.getClass()));
                }
            }
        };
    }

    private void initializeLayout() {
        this.autoGeneratedQueryFormatPanel = new AutoGeneratedQueryFormatPanel(this.getApplicationContext());
        this.nonAutoGeneratedQueryFormatPanel = new NonAutoGeneratedQueryFormatPanel(this.getApplicationContext());
        this.setActiveQueryFormatPanel(this.nonAutoGeneratedQueryFormatPanel);
        this.addHelpTopicId(this, this.helpTopicId());
    }

    private void initializeMaps() {
        this.queryFormatPanelMap = new Hashtable();
        this.queryFormatPanelMap.put(MWAutoGeneratedQueryFormat.class, this.autoGeneratedQueryFormatPanel);
        this.queryFormatPanelMap.put(MWExpressionQueryFormat.class, this.nonAutoGeneratedQueryFormatPanel);
        this.queryFormatPanelMap.put(MWSQLQueryFormat.class, this.nonAutoGeneratedQueryFormatPanel);
        this.queryFormatPanelMap.put(MWEJBQLQueryFormat.class, this.nonAutoGeneratedQueryFormatPanel);
    }

    private String helpTopicId() {
        return "descriptor.queries.format";
    }

    private void setActiveQueryFormatPanel(AbstractQueryFormatPanel abstractQueryFormatPanel) {
        AbstractQueryFormatPanel abstractQueryFormatPanel2 = this.activeQueryFormatPanel;
        if (abstractQueryFormatPanel == abstractQueryFormatPanel2) {
            return;
        }
        this.activeQueryFormatPanel = abstractQueryFormatPanel;
        if (abstractQueryFormatPanel2 != null) {
            this.remove(abstractQueryFormatPanel2);
        }
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)this.activeQueryFormatPanel, gridBagConstraints);
        this.revalidate();
        this.repaint();
    }

    private MWQueryFormat getQueryFormat() {
        return (MWQueryFormat)this.queryFormatHolder.getValue();
    }

    private boolean queryFormatCanChange() {
        boolean bl;
        String string = TriStateBoolean.UNDEFINED.toString();
        String string2 = this.preferences().get("query change query format", string);
        if (string2.equals(string)) {
            bl = this.promptToChangeSelectionCriteriaType();
        } else {
            bl = TriStateBoolean.TRUE.toString().equals(string2);
            if (!bl) {
                JOptionPane.showMessageDialog(this.getWorkbenchContext().getCurrentWindow(), this.resourceRepository().getString("QUERY_FORMAT_CHANGE_DISSALLOWED"));
            }
        }
        return bl;
    }

    private boolean promptToChangeSelectionCriteriaType() {
        if (this.preferences().getBoolean("query change query format", false)) {
            return true;
        }
        String string = this.resourceRepository().getString("QUERY_QUERY_FORMAT_TITLE");
        String string2 = this.resourceRepository().getString("QUERY_QUERY_FORMAT_MESSAGE");
        SimplePropertyValueModel simplePropertyValueModel = new SimplePropertyValueModel(new Boolean(false));
        JComponent jComponent = SwingComponentFactory.buildDoNotAskAgainPanel(string2, simplePropertyValueModel, this.resourceRepository());
        int n = JOptionPane.showConfirmDialog(this.getWorkbenchContext().getCurrentWindow(), jComponent, string, 0, 2);
        if (simplePropertyValueModel.getValue().equals(Boolean.TRUE)) {
            if (n == 0) {
                this.preferences().putBoolean("query change query format", true);
            } else if (n == 1) {
                this.preferences().putBoolean("query change query format", false);
            }
        }
        return n == 0;
    }

    private final class NonAutoGeneratedQueryFormatPanel
    extends AbstractQueryFormatPanel {
        private PropertyValueModel queryFormatTypeHolder;
        private QueryFormatSubPanel activeQueryFormatSubPanel;
        private StringQueryFormatSubPanel stringQueryFormatPanel;
        private ExpressionQueryFormatSubPanel expressionPanel;
        private Map subQueryFormatPanelMap;

        public NonAutoGeneratedQueryFormatPanel(ApplicationContext applicationContext) {
            super(applicationContext);
            QuerySelectionCriteriaPanel.this.queryFormatHolder.addPropertyChangeListener("value", this.buildQueryFormatListener());
            this.queryFormatTypeHolder = this.buildQueryFormatTypeAdapter();
            this.initialize();
            this.initializeMaps();
        }

        private void initializeMaps() {
            this.subQueryFormatPanelMap = new Hashtable();
            this.subQueryFormatPanelMap.put(MWExpressionQueryFormat.class, this.expressionPanel);
            this.subQueryFormatPanelMap.put(MWSQLQueryFormat.class, this.stringQueryFormatPanel);
            this.subQueryFormatPanelMap.put(MWEJBQLQueryFormat.class, this.stringQueryFormatPanel);
        }

        private void initialize() {
            JPanel jPanel = this.initializeQueryFormatTypePanel();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 21;
            gridBagConstraints.insets = new Insets(5, 0, 0, 5);
            this.add((Component)jPanel, gridBagConstraints);
            this.stringQueryFormatPanel = new StringQueryFormatSubPanel(QuerySelectionCriteriaPanel.this.queryHolder, QuerySelectionCriteriaPanel.this.queryFormatHolder, QuerySelectionCriteriaPanel.this.getWorkbenchContextHolder());
            this.expressionPanel = new ExpressionQueryFormatSubPanel(QuerySelectionCriteriaPanel.this.queryHolder, QuerySelectionCriteriaPanel.this.queryFormatHolder, QuerySelectionCriteriaPanel.this.getWorkbenchContextHolder());
            this.setActiveQueryFormatSubPanel(this.stringQueryFormatPanel);
        }

        private JPanel initializeQueryFormatTypePanel() {
            ArrayList<JComponent> arrayList = new ArrayList<JComponent>();
            JPanel jPanel = new JPanel(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            JLabel jLabel = new JLabel(this.resourceRepository().getString("SELECTION_CRITERIA_TYPE_LABEL"));
            arrayList.add(jLabel);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 21;
            gridBagConstraints.insets = new Insets(0, 5, 0, 0);
            jPanel.add((Component)jLabel, gridBagConstraints);
            JComboBox jComboBox = new JComboBox(this.buildSelectionCriteriaComboBoxModel());
            jComboBox.setRenderer(this.buildSelectionCriteraComboBoxRenderer());
            arrayList.add(jComboBox);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 21;
            gridBagConstraints.insets = new Insets(0, 5, 0, 0);
            jPanel.add(jComboBox, gridBagConstraints);
            new ComponentEnabler((ValueModel)this.buildQueryComponentEnableBooleanHolder(), arrayList);
            return jPanel;
        }

        private PropertyChangeListener buildQueryFormatListener() {
            return new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    MWQueryFormat mWQueryFormat = QuerySelectionCriteriaPanel.this.getQueryFormat();
                    if (mWQueryFormat != null) {
                        NonAutoGeneratedQueryFormatPanel.this.setActiveQueryFormatSubPanel((QueryFormatSubPanel)NonAutoGeneratedQueryFormatPanel.this.subQueryFormatPanelMap.get(mWQueryFormat.getClass()));
                    } else {
                        NonAutoGeneratedQueryFormatPanel.this.setActiveQueryFormatSubPanel((QueryFormatSubPanel)NonAutoGeneratedQueryFormatPanel.this.subQueryFormatPanelMap.get(MWSQLQueryFormat.class));
                    }
                }
            };
        }

        private ComboBoxModel buildSelectionCriteriaComboBoxModel() {
            return new ComboBoxModelAdapter(this.selectionCriteriaOptionsModel(), this.queryFormatTypeHolder);
        }

        private CollectionValueModel selectionCriteriaOptionsModel() {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("expressionFormat");
            arrayList.add("sqlFormat");
            arrayList.add("ejbqlFormat");
            return new ReadOnlyCollectionValueModel(arrayList);
        }

        private ListCellRenderer buildSelectionCriteraComboBoxRenderer() {
            return new SimpleListCellRenderer(){

                protected String buildText(Object object) {
                    if ((String)object == "expressionFormat") {
                        return NonAutoGeneratedQueryFormatPanel.this.resourceRepository().getString("EXPRESSION_OPTION");
                    }
                    if ((String)object == "sqlFormat") {
                        return NonAutoGeneratedQueryFormatPanel.this.resourceRepository().getString("SQL_OPTION");
                    }
                    return NonAutoGeneratedQueryFormatPanel.this.resourceRepository().getString("EJBQL_OPTION");
                }
            };
        }

        private PropertyValueModel buildQueryFormatTypeAdapter() {
            return new PropertyAspectAdapter(QuerySelectionCriteriaPanel.this.relationalOptionsHolder, "queryFormatType"){

                protected Object getValueFromSubject() {
                    return ((MWRelationalQuery)this.subject).getQueryFormatType();
                }

                protected void setValueOnSubject(Object object) {
                    if (QuerySelectionCriteriaPanel.this.queryFormatCanChange()) {
                        ((MWRelationalQuery)this.subject).setQueryFormatType((String)object);
                    }
                }
            };
        }

        private PropertyValueModel buildQueryComponentEnableBooleanHolder() {
            return new PropertyAspectAdapter(QuerySelectionCriteriaPanel.this.queryHolder){

                protected Object buildValue() {
                    return this.subject != null;
                }
            };
        }

        private void setActiveQueryFormatSubPanel(QueryFormatSubPanel queryFormatSubPanel) {
            QueryFormatSubPanel queryFormatSubPanel2 = this.activeQueryFormatSubPanel;
            if (queryFormatSubPanel == queryFormatSubPanel2) {
                return;
            }
            this.activeQueryFormatSubPanel = queryFormatSubPanel;
            if (queryFormatSubPanel2 != null) {
                this.remove(queryFormatSubPanel2);
            }
            if (this.activeQueryFormatSubPanel != null) {
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 1;
                gridBagConstraints.gridwidth = 1;
                gridBagConstraints.gridheight = 1;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.fill = 1;
                gridBagConstraints.anchor = 10;
                gridBagConstraints.insets = new Insets(5, 5, 5, 5);
                this.add((Component)this.activeQueryFormatSubPanel, gridBagConstraints);
            }
            this.revalidate();
            this.repaint();
        }
    }

    private final class AutoGeneratedQueryFormatPanel
    extends AbstractQueryFormatPanel {
        public AutoGeneratedQueryFormatPanel(ApplicationContext applicationContext) {
            super(applicationContext);
            this.initialize();
        }

        protected void initialize() {
            this.setLayout(new BorderLayout());
            this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            JLabel jLabel = this.buildLabel("AUTO_GENERATED_QUERY_COMMENT");
            jLabel.setFocusable(true);
            jLabel.setRequestFocusEnabled(true);
            this.add((Component)jLabel, "First");
        }
    }

    private abstract class AbstractQueryFormatPanel
    extends AbstractPanel {
        protected AbstractQueryFormatPanel(ApplicationContext applicationContext) {
            super(applicationContext);
        }
    }
}

