/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import java.util.Stack;
import javax.swing.AbstractCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.resources.ResourceRepository;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWQueryable;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWQueryableArgumentElement;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational.QueryableTreeModel;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational.QueryableTreeNode;

final class QueryableTree
extends SwingComponentFactory.AccessibleTree {
    private WorkbenchContext context;

    QueryableTree(QueryableTreeModel queryableTreeModel, WorkbenchContext workbenchContext) {
        super(queryableTreeModel);
        this.initialize(workbenchContext);
    }

    private FocusListener buildFocusListener() {
        return new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
                TreePath[] treePathArray = QueryableTree.this.getSelectionPaths();
                if (treePathArray == null) {
                    return;
                }
                for (int i = 0; i < treePathArray.length; ++i) {
                    Rectangle rectangle = QueryableTree.this.getUI().getPathBounds(QueryableTree.this, treePathArray[i]);
                    QueryableTree.this.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                }
            }

            public void focusLost(FocusEvent focusEvent) {
                this.focusGained(focusEvent);
            }
        };
    }

    private TreeSelectionListener buildTreeSelectionListener() {
        return new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                TreePath treePath = treeSelectionEvent.getNewLeadSelectionPath();
                if (treePath != null) {
                    TreePath[] treePathArray = new TreePath[treePath.getPathCount() - 1];
                    int n = treePathArray.length - 1;
                    treePathArray[n--] = treePath;
                    treePath = treePath.getParentPath();
                    Object object = QueryableTree.this.getModel().getRoot();
                    while (object != treePath.getLastPathComponent()) {
                        treePathArray[n--] = treePath;
                        treePath = treePath.getParentPath();
                    }
                    QueryableTree.this.setSelectionPaths(treePathArray);
                }
            }
        };
    }

    public TreePath getSelectionPath() {
        TreePath[] treePathArray = this.getSelectionPaths();
        if (treePathArray == null || treePathArray.length == 0) {
            return null;
        }
        return treePathArray[treePathArray.length - 1];
    }

    private void initialize(WorkbenchContext workbenchContext) {
        this.context = workbenchContext;
        this.setRowHeight(0);
        this.setEditable(true);
        this.setAutoscrolls(true);
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
        this.addFocusListener(this.buildFocusListener());
        QueryableTreeCell queryableTreeCell = new QueryableTreeCell();
        this.setCellEditor(queryableTreeCell);
        this.setCellRenderer(queryableTreeCell);
        this.addTreeSelectionListener(this.buildTreeSelectionListener());
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        TreePath treePath;
        Rectangle rectangle;
        if (this.isEditing() && mouseEvent.getButton() == 1 && !(rectangle = this.getPathBounds(treePath = this.getEditingPath())).contains(mouseEvent.getX(), mouseEvent.getY())) {
            this.stopEditing();
        }
        super.processMouseEvent(mouseEvent);
    }

    private ResourceRepository resourceRepository() {
        return this.context.getApplicationContext().getResourceRepository();
    }

    void setSelectedQueryableArgumentElement(MWQueryableArgumentElement mWQueryableArgumentElement) {
        if (mWQueryableArgumentElement == null) {
            return;
        }
        Stack<MWQueryableArgumentElement> stack = new Stack<MWQueryableArgumentElement>();
        while (mWQueryableArgumentElement != null) {
            stack.add(mWQueryableArgumentElement);
            mWQueryableArgumentElement = mWQueryableArgumentElement.getJoinedQueryableElement();
        }
        QueryableTreeModel queryableTreeModel = (QueryableTreeModel)this.getModel();
        MWQueryableArgumentElement mWQueryableArgumentElement2 = (MWQueryableArgumentElement)stack.pop();
        if (mWQueryableArgumentElement2.getQueryable() == null) {
            return;
        }
        int n = queryableTreeModel.buildQueryableObjects().indexOf(mWQueryableArgumentElement2.getQueryable());
        if (n == -1) {
            return;
        }
        int n2 = 0;
        int n3 = n;
        QueryableTreeNode queryableTreeNode = (QueryableTreeNode)queryableTreeModel.getChild(queryableTreeModel.getRoot(), n);
        queryableTreeNode.setAllowsNull(mWQueryableArgumentElement2.isAllowsNull());
        this.expandRow(n);
        MWQueryable mWQueryable = mWQueryableArgumentElement2.getQueryable();
        while (!stack.empty()) {
            ++n2;
            mWQueryableArgumentElement2 = (MWQueryableArgumentElement)stack.pop();
            if (mWQueryableArgumentElement2.getQueryable() == null || !queryableTreeModel.getQueryableFilter().accept((Object)mWQueryableArgumentElement2.getQueryable())) {
                return;
            }
            n = mWQueryable.subQueryableElements(queryableTreeModel.getQueryableFilter()).indexOf(mWQueryableArgumentElement2.getQueryable());
            queryableTreeNode = (QueryableTreeNode)queryableTreeModel.getChild(queryableTreeNode, n);
            queryableTreeNode.setAllowsNull(mWQueryableArgumentElement2.isAllowsNull());
            n3 = n3 + n + 1;
            this.expandRow(n3);
            mWQueryable = mWQueryableArgumentElement2.getQueryable();
        }
        this.setSelectionRow(n3);
    }

    private final class QueryableTreeCell
    extends AbstractCellEditor
    implements TreeCellEditor,
    TreeCellRenderer {
        private QueryableNodeCheckBoxPanel editor;
        private Object value;

        QueryableTreeCell() {
            this.initialize();
        }

        private QueryableNodeCheckBoxPanel createQueryKeyPanel() {
            return new QueryableNodeCheckBoxPanel();
        }

        public Object getCellEditorValue() {
            return this.value;
        }

        public Component getTreeCellEditorComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n) {
            this.editor.update(jTree, true, bl2, bl3, n, true);
            this.editor.populate((QueryableTreeNode)object, true);
            this.value = object;
            return this.editor;
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            if (jTree.getModel().getRoot() == object) {
                return new JLabel();
            }
            QueryableTreeNode queryableTreeNode = (QueryableTreeNode)object;
            bl4 = QueryableTree.this.isPathSelected(new TreePath(queryableTreeNode.getPath()));
            QueryableNodeCheckBoxPanel queryableNodeCheckBoxPanel = this.createQueryKeyPanel();
            queryableNodeCheckBoxPanel.update(jTree, bl, bl2, bl3, n, bl4);
            queryableNodeCheckBoxPanel.populate((QueryableTreeNode)object, bl);
            queryableNodeCheckBoxPanel.invalidate();
            return queryableNodeCheckBoxPanel;
        }

        private void initialize() {
            this.editor = this.createQueryKeyPanel();
        }

        public boolean isCellEditable(EventObject eventObject) {
            TreePath treePath = null;
            MouseEvent mouseEvent = null;
            if (eventObject instanceof MouseEvent) {
                mouseEvent = (MouseEvent)eventObject;
                treePath = QueryableTree.this.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
            } else {
                treePath = QueryableTree.this.getSelectionPath();
            }
            if (treePath == null) {
                return false;
            }
            QueryableTreeNode queryableTreeNode = (QueryableTreeNode)treePath.getLastPathComponent();
            MWQueryable mWQueryable = (MWQueryable)queryableTreeNode.getUserObject();
            if (!mWQueryable.allowsOuterJoin()) {
                return false;
            }
            if (mouseEvent == null) {
                return true;
            }
            JCheckBox jCheckBox = this.editor.allowsNullCheckBox;
            this.editor.populate(queryableTreeNode, true);
            int n = ((QueryableNodeCheckBoxPanel)this.editor).queryableLabel.getPreferredSize().width + 8;
            int n2 = QueryableTree.this.getPathBounds((TreePath)treePath).x + n + jCheckBox.getBorder().getBorderInsets((Component)jCheckBox).left;
            return mouseEvent.getX() >= n2;
        }
    }

    private final class QueryableNodeCheckBoxPanel
    extends JPanel {
        private JCheckBox allowsNullCheckBox;
        private DefaultTreeCellRenderer queryableLabel;
        private QueryableTreeNode queryableNode;

        protected QueryableNodeCheckBoxPanel() {
            super(new GridBagLayout());
            this.initialize();
        }

        protected ActionListener buildAllowsNullAction() {
            return new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    QueryableNodeCheckBoxPanel.this.queryableNode.setAllowsNull(QueryableNodeCheckBoxPanel.this.allowsNullCheckBox.isSelected());
                    QueryableTree.this.stopEditing();
                }
            };
        }

        private DefaultTreeCellRenderer buildQueryableLabel() {
            return new DefaultTreeCellRenderer(){

                public Color getBackgroundSelectionColor() {
                    if (!QueryableTree.this.hasFocus() && !QueryableTree.this.isEditing()) {
                        return UIManager.getColor("Panel.background");
                    }
                    return super.getBackgroundSelectionColor();
                }

                public Color getBorderSelectionColor() {
                    if (!QueryableTree.this.hasFocus() && !QueryableTree.this.isEditing()) {
                        return UIManager.getColor("Panel.background");
                    }
                    return super.getBorderSelectionColor();
                }

                public Dimension getPreferredSize() {
                    Dimension dimension = super.getPreferredSize();
                    dimension.height += 2;
                    return dimension;
                }
            };
        }

        private void initialize() {
            this.setOpaque(false);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            this.queryableLabel = this.buildQueryableLabel();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 21;
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            this.add((Component)this.queryableLabel, gridBagConstraints);
            this.allowsNullCheckBox = new JCheckBox();
            this.allowsNullCheckBox.setMargin(new Insets(0, 0, 0, 0));
            this.allowsNullCheckBox.setOpaque(false);
            this.allowsNullCheckBox.addActionListener(this.buildAllowsNullAction());
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 10;
            gridBagConstraints.insets = new Insets(0, 8, 0, 0);
            this.add((Component)this.allowsNullCheckBox, gridBagConstraints);
        }

        protected void populate(QueryableTreeNode queryableTreeNode, boolean bl) {
            this.queryableNode = queryableTreeNode;
            MWQueryable mWQueryable = (MWQueryable)queryableTreeNode.getUserObject();
            this.allowsNullCheckBox.setVisible(mWQueryable.allowsOuterJoin());
            this.allowsNullCheckBox.setEnabled(bl);
            this.allowsNullCheckBox.setSelected(queryableTreeNode.isAllowsNull());
            this.queryableLabel.setText(mWQueryable.getName());
            this.queryableLabel.setIcon(QueryableTree.this.resourceRepository().getIcon(mWQueryable.iconKey()));
            if (mWQueryable.usesAnyOf()) {
                this.allowsNullCheckBox.setText(QueryableTree.this.resourceRepository().getString("ALLOWS_NONE_CHECK_BOX_LABEL_IN_QUERYABLE_TREE"));
                this.allowsNullCheckBox.setMnemonic(QueryableTree.this.resourceRepository().getMnemonic("ALLOWS_NONE_CHECK_BOX_LABEL_IN_QUERYABLE_TREE"));
                this.allowsNullCheckBox.setDisplayedMnemonicIndex(QueryableTree.this.resourceRepository().getMnemonicIndex("ALLOWS_NONE_CHECK_BOX_LABEL_IN_QUERYABLE_TREE"));
            } else {
                this.allowsNullCheckBox.setText(QueryableTree.this.resourceRepository().getString("ALLOWS_NULL_CHECK_BOX_LABEL_IN_QUERYABLE_TREE"));
                this.allowsNullCheckBox.setMnemonic(QueryableTree.this.resourceRepository().getMnemonic("ALLOWS_NULL_CHECK_BOX_LABEL_IN_QUERYABLE_TREE"));
                this.allowsNullCheckBox.setDisplayedMnemonicIndex(QueryableTree.this.resourceRepository().getMnemonicIndex("ALLOWS_NULL_CHECK_BOX_LABEL_IN_QUERYABLE_TREE"));
            }
        }

        protected void update(JTree jTree, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            this.queryableLabel.getTreeCellRendererComponent(jTree, null, bl, bl2, bl3, n, bl4);
        }
    }
}

