/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.ListCellRenderer;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractPanel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.TopLinkOption;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWReportQuery;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational.RelationalQueryComponentFactory;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational.ReportQueryAdvancedOptionsDialog;
import org.eclipse.persistence.tools.workbench.uitools.app.AbstractReadOnlyListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.FilteringPropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ComboBoxModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.cell.SimpleListCellRenderer;

final class ReportQueryOptionsPanel
extends AbstractPanel {
    private PropertyValueModel queryHolder;

    ReportQueryOptionsPanel(PropertyValueModel propertyValueModel, WorkbenchContextHolder workbenchContextHolder) {
        super(workbenchContextHolder);
        this.initialize(propertyValueModel);
        this.initializeLayout();
    }

    private void initialize(PropertyValueModel propertyValueModel) {
        this.queryHolder = this.buildReportQueryHolder(propertyValueModel);
    }

    private PropertyValueModel buildReportQueryHolder(PropertyValueModel propertyValueModel) {
        return new FilteringPropertyValueModel(propertyValueModel){

            protected boolean accept(Object object) {
                return object instanceof MWReportQuery;
            }
        };
    }

    protected String helpTopicId() {
        return "descriptor.queries.options";
    }

    protected void initializeLayout() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JLabel jLabel = this.buildLabel("RETURN_CHOICE_LABEL");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.add((Component)jLabel, gridBagConstraints);
        JComboBox jComboBox = this.buildReturnChoiceComboBox();
        this.addHelpTopicId(jComboBox, this.helpTopicId() + ".returnChoice");
        jLabel.setLabelFor(jComboBox);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.add((Component)jComboBox, gridBagConstraints);
        JLabel jLabel2 = this.buildLabel("RETRIEVE_PRIMARY_KEYS_LABEL");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.add((Component)jLabel2, gridBagConstraints);
        JComboBox jComboBox2 = this.buildRetrievePrimaryKeysComboBox();
        this.addHelpTopicId(jComboBox2, this.helpTopicId() + ".retrievePrimaryKeys");
        jLabel2.setLabelFor(jComboBox2);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.add((Component)jComboBox2, gridBagConstraints);
        JLabel jLabel3 = this.buildLabel("CACHE_STATMENT_LABEL");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.add((Component)jLabel3, gridBagConstraints);
        JComboBox jComboBox3 = this.buildCacheStatementComboBox();
        this.addHelpTopicId(jComboBox3, this.helpTopicId() + ".cacheStatement");
        jLabel3.setLabelFor(jComboBox3);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.add((Component)jComboBox3, gridBagConstraints);
        JLabel jLabel4 = this.buildLabel("BIND_PARAMETERS_LABEL");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.add((Component)jLabel4, gridBagConstraints);
        JComboBox jComboBox4 = this.buildBindParametersComboBox();
        this.addHelpTopicId(jComboBox4, this.helpTopicId() + ".bind");
        jLabel4.setLabelFor(jComboBox4);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.add((Component)jComboBox4, gridBagConstraints);
        JButton jButton = this.buildAdvancedOptionsButton();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.insets = new Insets(10, 5, 5, 5);
        this.add((Component)jButton, gridBagConstraints);
        this.addHelpTopicId(this, this.helpTopicId());
    }

    private JComboBox buildReturnChoiceComboBox() {
        JComboBox jComboBox = new JComboBox(new ComboBoxModelAdapter(this.buildReturnChoiceValueModel(), this.buildReturnChoicePropertyAdapter()));
        jComboBox.setRenderer(this.buildTopLinkOptionModelRenderer());
        return jComboBox;
    }

    private ListCellRenderer buildTopLinkOptionModelRenderer() {
        return new SimpleListCellRenderer(){

            protected String buildText(Object object) {
                return object == null ? "" : ReportQueryOptionsPanel.this.resourceRepository().getString(((TopLinkOption)object).resourceKey());
            }
        };
    }

    private ListValueModel buildReturnChoiceValueModel() {
        return new AbstractReadOnlyListValueModel(){

            public Object getValue() {
                return MWReportQuery.returnChoiceOptions().toplinkOptions();
            }
        };
    }

    private PropertyValueModel buildReturnChoicePropertyAdapter() {
        return new PropertyAspectAdapter(this.queryHolder, "returnChoice"){

            protected Object getValueFromSubject() {
                return ((MWReportQuery)this.subject).getReturnChoice();
            }

            protected void setValueOnSubject(Object object) {
                ((MWReportQuery)this.subject).setReturnChoice((MWReportQuery.ReturnChoiceOption)object);
            }
        };
    }

    private JComboBox buildRetrievePrimaryKeysComboBox() {
        JComboBox jComboBox = new JComboBox(new ComboBoxModelAdapter(this.buildRetrievePrimaryKeysValueModel(), this.buildRetrievePrimaryKeysPropertyAdapter()));
        jComboBox.setRenderer(this.buildTopLinkOptionModelRenderer());
        return jComboBox;
    }

    private ListValueModel buildRetrievePrimaryKeysValueModel() {
        return new AbstractReadOnlyListValueModel(){

            public Object getValue() {
                return MWReportQuery.retrievePrimaryKeysOptions().toplinkOptions();
            }
        };
    }

    private PropertyValueModel buildRetrievePrimaryKeysPropertyAdapter() {
        return new PropertyAspectAdapter(this.queryHolder, "retrievePrimaryKeys"){

            protected Object getValueFromSubject() {
                return ((MWReportQuery)this.subject).getRetrievePrimaryKeys();
            }

            protected void setValueOnSubject(Object object) {
                ((MWReportQuery)this.subject).setRetrievePrimaryKeys((MWReportQuery.RetrievePrimaryKeysOption)object);
            }
        };
    }

    private JComboBox buildCacheStatementComboBox() {
        return RelationalQueryComponentFactory.buildCacheStatementComboBox(this.queryHolder, this.resourceRepository());
    }

    private JComboBox buildBindParametersComboBox() {
        return RelationalQueryComponentFactory.buildBindParametersComboBox(this.queryHolder, this.resourceRepository());
    }

    private JButton buildAdvancedOptionsButton() {
        JButton jButton = this.buildButton("ADVANCED_BUTTON_TEXT");
        jButton.addActionListener(this.buildAdvancedOptionsAction());
        return jButton;
    }

    private ActionListener buildAdvancedOptionsAction() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ReportQueryOptionsPanel.this.showAdvancedOptionsDialog();
            }
        };
    }

    private void showAdvancedOptionsDialog() {
        ReportQueryAdvancedOptionsDialog reportQueryAdvancedOptionsDialog = new ReportQueryAdvancedOptionsDialog(this.getQuery(), this.getWorkbenchContext());
        reportQueryAdvancedOptionsDialog.show();
        if (reportQueryAdvancedOptionsDialog.wasConfirmed()) {
            MWReportQuery mWReportQuery = this.getQuery();
            mWReportQuery.setLocking(reportQueryAdvancedOptionsDialog.getLocking());
            mWReportQuery.setPrepare(reportQueryAdvancedOptionsDialog.getPrepare());
            mWReportQuery.setCacheQueryResults(reportQueryAdvancedOptionsDialog.getCacheQueryResults());
            mWReportQuery.setDistinctState(reportQueryAdvancedOptionsDialog.getDistinctState());
            mWReportQuery.setQueryTimeout(reportQueryAdvancedOptionsDialog.getQueryTimeout());
            mWReportQuery.setMaximumRows(reportQueryAdvancedOptionsDialog.getMaximumRows());
            mWReportQuery.setFirstResult(reportQueryAdvancedOptionsDialog.getFirstResult());
            mWReportQuery.setExclusiveConnection(reportQueryAdvancedOptionsDialog.getExclusiveConnection());
        }
    }

    private MWReportQuery getQuery() {
        return (MWReportQuery)this.queryHolder.getValue();
    }
}

