/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.xml;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ListIterator;
import javax.swing.BorderFactory;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractSubjectPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.xml.MWEisInteraction;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.xml.MWEisQueryManager;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.xml.InteractionPanel;
import org.eclipse.persistence.tools.workbench.uitools.app.ListAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SimplePropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.TransformationPropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ListModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.cell.SimpleListCellRenderer;

public final class EisCustomCallsPropertiesPage
extends AbstractSubjectPanel {
    private PropertyValueModel selectedInteractionHolder;

    public EisCustomCallsPropertiesPage(ValueModel valueModel, WorkbenchContextHolder workbenchContextHolder) {
        super(valueModel, workbenchContextHolder);
    }

    protected void initialize(ValueModel valueModel) {
        super.initialize(valueModel);
        this.selectedInteractionHolder = new SimplePropertyValueModel();
    }

    protected void initializeLayout() {
        this.setName("Calls");
        this.setLayout(new BorderLayout());
        JScrollPane jScrollPane = new JScrollPane(this.buildPage());
        jScrollPane.setBorder(BorderFactory.createEmptyBorder());
        jScrollPane.setViewportBorder(BorderFactory.createEmptyBorder());
        this.add((Component)jScrollPane, "Center");
    }

    protected Component buildPage() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel2 = this.buildInteractionListPanel();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.3;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        jPanel.add((Component)jPanel2, gridBagConstraints);
        JPanel jPanel3 = this.buildInteractionPanel();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.7;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)jPanel3, gridBagConstraints);
        return jPanel;
    }

    private JPanel buildInteractionListPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JScrollPane jScrollPane = new JScrollPane(this.buildInteractionList());
        jScrollPane.setMinimumSize(new Dimension(1, 1));
        jScrollPane.setPreferredSize(new Dimension(1, 1));
        jScrollPane.getHorizontalScrollBar().setUnitIncrement(10);
        jScrollPane.getVerticalScrollBar().setUnitIncrement(10);
        jPanel.add((Component)jScrollPane, "Center");
        return jPanel;
    }

    private JList buildInteractionList() {
        JList jList = SwingComponentFactory.buildList(this.buildInteractionListModel());
        jList.setSelectionMode(0);
        jList.addListSelectionListener(this.buildInteractionListSelectionListener(jList));
        jList.setCellRenderer(this.buildInteractionListCellRenderer());
        return jList;
    }

    private ListModel buildInteractionListModel() {
        return new ListModelAdapter(this.buildInteractionListValue());
    }

    private ListValueModel buildInteractionListValue() {
        return new ListAspectAdapter(this.getSubjectHolder()){

            protected ListIterator getValueFromSubject() {
                return ((MWEisQueryManager)this.subject).interactions();
            }
        };
    }

    private ListSelectionListener buildInteractionListSelectionListener(final JList jList) {
        return new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                EisCustomCallsPropertiesPage.this.selectedInteractionHolder.setValue(jList.getSelectedValue());
            }
        };
    }

    private ListCellRenderer buildInteractionListCellRenderer() {
        return new SimpleListCellRenderer(){

            protected String buildText(Object object) {
                return EisCustomCallsPropertiesPage.this.buildDisplayText((MWEisInteraction)object);
            }
        };
    }

    private String buildDisplayText(MWEisInteraction mWEisInteraction) {
        MWEisQueryManager mWEisQueryManager = (MWEisQueryManager)this.subject();
        String string = null;
        if (mWEisInteraction == mWEisQueryManager.getInsertInteraction()) {
            string = "INSERT_INTERACTION_NAME";
        } else if (mWEisInteraction == mWEisQueryManager.getUpdateInteraction()) {
            string = "UPDATE_INTERACTION_NAME";
        } else if (mWEisInteraction == mWEisQueryManager.getDeleteInteraction()) {
            string = "DELETE_INTERACTION_NAME";
        } else if (mWEisInteraction == mWEisQueryManager.getReadObjectInteraction()) {
            string = "READ_OBJECT_INTERACTION_NAME";
        } else if (mWEisInteraction == mWEisQueryManager.getReadAllInteraction()) {
            string = "READ_ALL_INTERACTION_NAME";
        } else if (mWEisInteraction == mWEisQueryManager.getDoesExistInteraction()) {
            string = "DOES_EXIST_INTERACTION_NAME";
        } else {
            throw new IllegalArgumentException("Illegal interaction: " + mWEisInteraction);
        }
        return this.resourceRepository().getString(string);
    }

    private JPanel buildInteractionPanel() {
        return new InteractionPanel(this.getApplicationContext(), this.selectedInteractionHolder, this.buildEnablerHolder());
    }

    private PropertyValueModel buildEnablerHolder() {
        return new TransformationPropertyValueModel(this.selectedInteractionHolder){

            protected Object transform(Object object) {
                if (object == null) {
                    return null;
                }
                return object != null;
            }
        };
    }

    protected String helpTopicId() {
        return "descriptor.queryManager.customSQL";
    }
}

