/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.xml;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractPanel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWAbstractReadQuery;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.QueryComponentFactory;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.xml.EisQueryAdvancedOptionsDialog;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;

final class EisQueryOptionsPanel
extends AbstractPanel {
    private PropertyValueModel queryHolder;

    EisQueryOptionsPanel(PropertyValueModel propertyValueModel, WorkbenchContextHolder workbenchContextHolder) {
        super(workbenchContextHolder);
        this.queryHolder = propertyValueModel;
        this.initializeLayout();
    }

    protected String helpTopicId() {
        return "descriptor.queries.options";
    }

    protected void initializeLayout() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel(new GridBagLayout());
        JCheckBox jCheckBox = this.buildRefreshIdentityMapCheckBox();
        this.addHelpTopicId(jCheckBox, this.helpTopicId() + ".refresh");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)jCheckBox, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.add((Component)jPanel, gridBagConstraints);
        this.addHelpTopicId(jPanel, this.helpTopicId() + ".refresh");
        JButton jButton = this.buildAdvancedOptionsButton();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.insets = new Insets(10, 5, 5, 5);
        this.add((Component)jButton, gridBagConstraints);
        this.addHelpTopicId(this, this.helpTopicId());
    }

    private JCheckBox buildRefreshIdentityMapCheckBox() {
        return QueryComponentFactory.buildRefreshIdentityMapCheckBox(this.queryHolder, this.resourceRepository());
    }

    private JButton buildAdvancedOptionsButton() {
        JButton jButton = new JButton(this.resourceRepository().getString("ADVANCED_BUTTON_TEXT"));
        jButton.setEnabled(false);
        jButton.setMnemonic(this.resourceRepository().getMnemonic("ADVANCED_BUTTON_TEXT"));
        jButton.addActionListener(this.buildAdvancedOptionsAction());
        this.queryHolder.addPropertyChangeListener("value", this.buildQueryListener(jButton));
        return jButton;
    }

    private ActionListener buildAdvancedOptionsAction() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EisQueryOptionsPanel.this.showAdvancedOptionsDialog();
            }
        };
    }

    private void showAdvancedOptionsDialog() {
        EisQueryAdvancedOptionsDialog eisQueryAdvancedOptionsDialog = new EisQueryAdvancedOptionsDialog(this.getQuery(), this.getWorkbenchContext());
        eisQueryAdvancedOptionsDialog.show();
        if (eisQueryAdvancedOptionsDialog.wasConfirmed()) {
            MWAbstractReadQuery mWAbstractReadQuery = this.getQuery();
            mWAbstractReadQuery.setMaintainCache(eisQueryAdvancedOptionsDialog.getMaintainCache());
            mWAbstractReadQuery.setLocking(eisQueryAdvancedOptionsDialog.getLocking());
            mWAbstractReadQuery.setUseWrapperPolicy(eisQueryAdvancedOptionsDialog.getUseWrapperPolicy());
            mWAbstractReadQuery.setCacheQueryResults(eisQueryAdvancedOptionsDialog.getCacheQueryResults());
            mWAbstractReadQuery.setRefreshIdentityMapResult(eisQueryAdvancedOptionsDialog.getRefreshIdentityMapResult());
            mWAbstractReadQuery.setRefreshRemoteIdentityMapResult(eisQueryAdvancedOptionsDialog.getRefreshRemoteIdentityMapResult());
            mWAbstractReadQuery.setDistinctState(eisQueryAdvancedOptionsDialog.getDistinctState());
            mWAbstractReadQuery.setQueryTimeout(eisQueryAdvancedOptionsDialog.getQueryTimeout());
            mWAbstractReadQuery.setMaximumRows(eisQueryAdvancedOptionsDialog.getMaximumRows());
            mWAbstractReadQuery.setFirstResult(eisQueryAdvancedOptionsDialog.getFirstResult());
            mWAbstractReadQuery.setExclusiveConnection(eisQueryAdvancedOptionsDialog.getExclusiveConnection());
        }
    }

    private MWAbstractReadQuery getQuery() {
        return (MWAbstractReadQuery)this.queryHolder.getValue();
    }

    private PropertyChangeListener buildQueryListener(final Component component) {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                component.setEnabled(EisQueryOptionsPanel.this.getQuery() != null);
            }
        };
    }
}

