/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.schema;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ListIterator;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWElementDeclaration;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWModelGroup;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWParticle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWSchemaComponent;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.NullParticle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.Wildcard;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.schema.ElementDeclarationNodeStructure;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.schema.ModelGroupNodeStructure;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.schema.NullNodeStructure;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.schema.SchemaComponentDetail;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.schema.SchemaComponentNodeStructure;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.schema.SpecificParticleNodeStructure;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.schema.WildcardNodeStructure;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;

final class GeneralParticleNodeStructure
extends SchemaComponentNodeStructure {
    private SpecificParticleNodeStructure specificParticleStructure;

    GeneralParticleNodeStructure(MWParticle mWParticle) {
        super((MWSchemaComponent)mWParticle);
        this.specificParticleStructure = this.buildSpecificParticleStructure(mWParticle);
    }

    private SpecificParticleNodeStructure buildSpecificParticleStructure(MWParticle mWParticle) {
        SchemaComponentNodeStructure schemaComponentNodeStructure;
        if (mWParticle instanceof MWElementDeclaration) {
            schemaComponentNodeStructure = new ElementDeclarationNodeStructure((MWElementDeclaration)mWParticle);
        } else if (mWParticle instanceof MWModelGroup) {
            schemaComponentNodeStructure = new ModelGroupNodeStructure((MWModelGroup)mWParticle);
        } else if (mWParticle instanceof Wildcard) {
            schemaComponentNodeStructure = new WildcardNodeStructure((Wildcard)mWParticle);
        } else if (mWParticle instanceof NullParticle) {
            schemaComponentNodeStructure = new NullNodeStructure((NullParticle)mWParticle);
        } else {
            throw new IllegalArgumentException("Unsupported particle type.");
        }
        schemaComponentNodeStructure.addPropertyChangeListener("displayString", this.buildDisplayStringChangeListener());
        return schemaComponentNodeStructure;
    }

    private PropertyChangeListener buildDisplayStringChangeListener() {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                GeneralParticleNodeStructure.this.firePropertyChanged("displayString", propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
            }
        };
    }

    void disengageComponent() {
        super.disengageComponent();
        this.specificParticleStructure.disengageParticle();
    }

    public String displayString() {
        return this.specificParticleStructure.displayString();
    }

    protected ListIterator componentDetails() {
        SchemaComponentDetail[] schemaComponentDetailArray = new SchemaComponentDetail[]{this.buildMinOccursDetail(), this.buildMaxOccursDetail()};
        return this.specificParticleStructure.details(CollectionTools.listIterator((Object[])schemaComponentDetailArray));
    }

    SchemaComponentDetail buildMinOccursDetail() {
        return new SchemaComponentDetail(this.getComponent()){

            protected String getName() {
                return "minOccurs";
            }

            protected String getValueFromComponent() {
                return String.valueOf(((MWParticle)this.component).getMinOccurs());
            }
        };
    }

    SchemaComponentDetail buildMaxOccursDetail() {
        return new SchemaComponentDetail(this.getComponent()){

            protected String getName() {
                return "maxOccurs";
            }

            protected String getValueFromComponent() {
                int n = ((MWParticle)this.component).getMaxOccurs();
                return n == 0x7FFFFFF8 ? "unbounded" : String.valueOf(n);
            }
        };
    }
}

