/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.platformsplugin.ui.repository;

import java.util.Iterator;
import org.eclipse.persistence.tools.workbench.framework.action.AbstractFrameworkAction;
import org.eclipse.persistence.tools.workbench.framework.app.ApplicationNode;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.ui.dialog.NewNameDialog;
import org.eclipse.persistence.tools.workbench.platformsmodel.DatabasePlatform;
import org.eclipse.persistence.tools.workbench.platformsmodel.DatabasePlatformRepository;
import org.eclipse.persistence.tools.workbench.platformsplugin.ui.repository.DatabasePlatformRepositoryNode;
import org.eclipse.persistence.tools.workbench.utility.iterators.TransformationIterator;

final class AddDatabasePlatformAction
extends AbstractFrameworkAction {
    public AddDatabasePlatformAction(WorkbenchContext workbenchContext) {
        super(workbenchContext);
    }

    protected void initialize() {
        this.initializeTextAndMnemonic("ADD_DATABASE_PLATFORM");
        this.initializeIcon("ADD_DATABASE_PLATFORM");
        this.initializeToolTipText("ADD_DATABASE_PLATFORM.TOOL_TIP");
    }

    protected void execute() {
        NewNameDialog.Builder builder = this.buildNewNameDialogBuilder();
        ApplicationNode[] applicationNodeArray = this.selectedNodes();
        int n = applicationNodeArray.length;
        while (n-- > 0) {
            this.execute(((DatabasePlatformRepositoryNode)applicationNodeArray[n]).getDatabasePlatformRepository(), builder);
        }
    }

    private NewNameDialog.Builder buildNewNameDialogBuilder() {
        NewNameDialog.Builder builder = new NewNameDialog.Builder();
        builder.setTitle(this.resourceRepository().getString("ADD_DATABASE_PLATFORM_DIALOG_TITLE"));
        builder.setTextFieldDescription(this.resourceRepository().getString("ADD_DATABASE_PLATFORM_DIALOG_DESCRIPTION"));
        builder.setHelpTopicId("dialog.dbPlatformAdd");
        return builder;
    }

    protected void execute(DatabasePlatformRepository databasePlatformRepository, NewNameDialog.Builder builder) {
        builder.setExistingNames(this.existingTypeNames(databasePlatformRepository));
        NewNameDialog newNameDialog = builder.buildDialog(this.getWorkbenchContext());
        newNameDialog.show();
        if (newNameDialog.wasConfirmed()) {
            databasePlatformRepository.addPlatform(newNameDialog.getNewName(), newNameDialog.getNewName() + ".xml");
        }
    }

    private Iterator existingTypeNames(DatabasePlatformRepository databasePlatformRepository) {
        return new TransformationIterator(databasePlatformRepository.platforms()){

            protected Object transform(Object object) {
                return ((DatabasePlatform)object).getName();
            }
        };
    }
}

