/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.platformsplugin.ui.repository;

import java.awt.Component;
import java.util.Iterator;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.eclipse.persistence.tools.workbench.framework.context.ApplicationContext;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.view.ScrollablePropertiesPage;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.platformsmodel.DatabasePlatformRepository;
import org.eclipse.persistence.tools.workbench.platformsmodel.JDBCType;
import org.eclipse.persistence.tools.workbench.platformsmodel.JDBCTypeRepository;
import org.eclipse.persistence.tools.workbench.platformsmodel.JDBCTypeToJavaTypeDeclarationMapping;
import org.eclipse.persistence.tools.workbench.platformsmodel.JavaTypeDeclaration;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SortedListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.TransformationPropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValuePropertyPropertyValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ColumnAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.TableModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.cell.AbstractCellRendererAdapter;
import org.eclipse.persistence.tools.workbench.uitools.cell.AdaptableTableCellRenderer;
import org.eclipse.persistence.tools.workbench.uitools.swing.EmptyIcon;
import org.eclipse.persistence.tools.workbench.utility.Model;

final class DatabasePlatformRepositoryJDBCMappingsPropertiesPage
extends ScrollablePropertiesPage {
    private PropertyValueModel repositoryHolder;
    private TableModel tableModel;
    static final Icon EMPTY_ICON = new EmptyIcon(5);

    public DatabasePlatformRepositoryJDBCMappingsPropertiesPage(PropertyValueModel propertyValueModel, WorkbenchContextHolder workbenchContextHolder) {
        super(propertyValueModel, workbenchContextHolder);
    }

    protected void initialize(PropertyValueModel propertyValueModel) {
        super.initialize(propertyValueModel);
        this.repositoryHolder = this.buildRepositoryHolder();
        this.tableModel = this.buildTableModel();
    }

    protected PropertyValueModel buildRepositoryHolder() {
        return new TransformationPropertyValueModel(this.getSelectionHolder()){

            protected Object transform(Object object) {
                return object == null ? null : ((DatabasePlatformRepository)object).getJDBCTypeRepository();
            }

            protected Object reverseTransform(Object object) {
                throw new UnsupportedOperationException();
            }
        };
    }

    private TableModel buildTableModel() {
        return new TableModelAdapter(this.buildSortedMappingsAdapter(), this.buildColumnAdapter());
    }

    private ListValueModel buildSortedMappingsAdapter() {
        return new SortedListValueModelAdapter(this.buildMappingsAdapter());
    }

    private CollectionValueModel buildMappingsAdapter() {
        return new CollectionAspectAdapter(this.repositoryHolder, "jdbcTypeToJavaTypeDeclarationMappings"){

            protected Iterator getValueFromSubject() {
                return ((JDBCTypeRepository)this.subject).jdbcTypeToJavaTypeDeclarationMappings();
            }

            protected int sizeFromSubject() {
                return ((JDBCTypeRepository)this.subject).jdbcTypeToJavaTypeDeclarationMappingsSize();
            }
        };
    }

    private ColumnAdapter buildColumnAdapter() {
        return new MappingColumnAdapter(this.getApplicationContext());
    }

    protected Component buildPage() {
        JTable jTable = SwingComponentFactory.buildTable(this.tableModel);
        TableColumn tableColumn = jTable.getColumnModel().getColumn(0);
        tableColumn.setCellRenderer(this.buildJDBCTypeRenderer());
        TableColumn tableColumn2 = jTable.getColumnModel().getColumn(1);
        tableColumn2.setCellRenderer(this.buildJavaTypeRenderer());
        return jTable;
    }

    private TableCellRenderer buildJDBCTypeRenderer() {
        return new AdaptableTableCellRenderer(new AbstractCellRendererAdapter(){

            public String buildText(Object object) {
                return ((JDBCType)object).displayString();
            }

            public Icon buildIcon(Object object) {
                return EMPTY_ICON;
            }
        });
    }

    private TableCellRenderer buildJavaTypeRenderer() {
        return new AdaptableTableCellRenderer(new AbstractCellRendererAdapter(){

            public String buildText(Object object) {
                return ((JavaTypeDeclaration)object).displayString();
            }

            public Icon buildIcon(Object object) {
                return EMPTY_ICON;
            }
        });
    }

    private static class MappingColumnAdapter
    implements ColumnAdapter {
        private ApplicationContext context;
        public static final int COLUMN_COUNT = 2;
        public static final int JDBC_TYPE_COLUMN = 0;
        public static final int JAVA_TYPE_COLUMN = 1;
        private static final String[] COLUMN_NAMES = new String[]{"DATABASE_PLATFORM_REPOSITORY_JDBC_TYPE_COLUMN", "DATABASE_PLATFORM_REPOSITORY_JAVA_TYPE_COLUMN"};
        private static final String[] EMPTY_STRING_ARRAY = new String[0];

        MappingColumnAdapter(ApplicationContext applicationContext) {
            this.context = applicationContext;
        }

        public int getColumnCount() {
            return 2;
        }

        public String getColumnName(int n) {
            return this.context.getResourceRepository().getString(COLUMN_NAMES[n]);
        }

        public Class getColumnClass(int n) {
            return Object.class;
        }

        public boolean isColumnEditable(int n) {
            return false;
        }

        public PropertyValueModel[] cellModels(Object object) {
            JDBCTypeToJavaTypeDeclarationMapping jDBCTypeToJavaTypeDeclarationMapping = (JDBCTypeToJavaTypeDeclarationMapping)object;
            PropertyValueModel[] propertyValueModelArray = new PropertyValueModel[]{this.buildJDBCTypeAdapter(jDBCTypeToJavaTypeDeclarationMapping), this.buildJavaTypeAdapter(jDBCTypeToJavaTypeDeclarationMapping)};
            return propertyValueModelArray;
        }

        private PropertyValueModel buildJDBCTypeAdapter(JDBCTypeToJavaTypeDeclarationMapping jDBCTypeToJavaTypeDeclarationMapping) {
            PropertyAspectAdapter propertyAspectAdapter = new PropertyAspectAdapter(EMPTY_STRING_ARRAY, (Model)jDBCTypeToJavaTypeDeclarationMapping){

                protected Object getValueFromSubject() {
                    return ((JDBCTypeToJavaTypeDeclarationMapping)this.subject).getJDBCType();
                }

                protected void setValueOnSubject(Object object) {
                    throw new UnsupportedOperationException();
                }
            };
            return new ValuePropertyPropertyValueModelAdapter((PropertyValueModel)propertyAspectAdapter, "name");
        }

        private PropertyValueModel buildJavaTypeAdapter(JDBCTypeToJavaTypeDeclarationMapping jDBCTypeToJavaTypeDeclarationMapping) {
            return new PropertyAspectAdapter("javaTypeDeclaration", (Model)jDBCTypeToJavaTypeDeclarationMapping){

                protected Object getValueFromSubject() {
                    return ((JDBCTypeToJavaTypeDeclarationMapping)this.subject).getJavaTypeDeclaration();
                }

                protected void setValueOnSubject(Object object) {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }
}

