/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.scplugin.model.adapter;

import org.eclipse.persistence.internal.sessions.factories.model.pool.ConnectionPoolConfig;
import org.eclipse.persistence.internal.sessions.factories.model.pool.ReadConnectionPoolConfig;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.ConnectionPoolAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.NullLoginAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.SCAdapter;

public class ReadConnectionPoolAdapter
extends ConnectionPoolAdapter {
    public static final String EXCLUSIVE_PROPERTY = "exclusive";
    public static final String USE_NON_TRANSACTIONAL_READ_LOGIN_PROPERTY = "useNonTransactionalReadLogin";
    private volatile boolean useNonTransactionalReadLogin;

    ReadConnectionPoolAdapter(SCAdapter sCAdapter, ReadConnectionPoolConfig readConnectionPoolConfig) {
        super(sCAdapter, (ConnectionPoolConfig)readConnectionPoolConfig);
    }

    protected ReadConnectionPoolAdapter(SCAdapter sCAdapter) {
        super(sCAdapter, "ReadConnectionPool");
    }

    private final ReadConnectionPoolConfig readPool() {
        return (ReadConnectionPoolConfig)this.getModel();
    }

    protected Object buildModel() {
        return new ReadConnectionPoolConfig();
    }

    protected void initialize() {
        super.initialize();
        this.setConfigRequired(true);
    }

    protected void initializeDefaults() {
        super.initializeDefaults();
        this.setExclusive(true);
    }

    protected void initialize(Object object) {
        super.initialize(object);
        this.setLogin(NullLoginAdapter.instance());
    }

    protected void initializeFromModel(Object object) {
        super.initializeFromModel(object);
        this.useNonTransactionalReadLogin = this.readPool().getLoginConfig() != null;
    }

    protected void postInitializationFromModel() {
        super.postInitializationFromModel();
        if (this.getName().equals("unamed")) {
            this.setName("ReadConnectionPool");
        }
    }

    public boolean isExclusive() {
        return this.readPool().getExclusive();
    }

    public boolean isReadConnectionPool() {
        return true;
    }

    public void setExclusive(boolean bl) {
        boolean bl2 = this.isExclusive();
        this.readPool().setExclusive(bl);
        this.firePropertyChanged(EXCLUSIVE_PROPERTY, bl2, bl);
    }

    public boolean usesNonTransactionalReadLogin() {
        return this.useNonTransactionalReadLogin;
    }

    public void setUseNonTransactionalReadLogin(boolean bl) {
        boolean bl2 = this.useNonTransactionalReadLogin;
        if (bl2 == bl) {
            return;
        }
        this.useNonTransactionalReadLogin = bl;
        if (bl) {
            this.setLogin(this.buildLogin());
        } else {
            this.removeLogin();
        }
        this.firePropertyChanged(USE_NON_TRANSACTIONAL_READ_LOGIN_PROPERTY, bl2, bl);
    }
}

