/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.scplugin.model.adapter;

import java.lang.reflect.Constructor;
import org.eclipse.persistence.tools.workbench.scplugin.model.ServerPlatformManager;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.NullServerPlatformAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.SCAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.ServerPlatformAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.SessionAdapter;
import org.eclipse.persistence.tools.workbench.utility.ClassTools;

public class ServerPlatform {
    private String platformId;

    public ServerPlatform(String string) {
        this.initialize(string);
    }

    private void initialize(String string) {
        this.platformId = ServerPlatformManager.instance().getIdFor(string);
    }

    public String getRuntimeClassName() {
        return this.getRuntimePlatformClassNameFor(this.platformId);
    }

    public String getConfigClassName() {
        return ClassTools.shortNameForClassNamed((String)ServerPlatformManager.instance().getRuntimePlatformConfigClassNameForPlatformId(this.platformId));
    }

    public Class getAdapterClass() {
        return SCAdapter.adapterClassNamed(this.getConfigClassName());
    }

    private String getRuntimePlatformClassNameFor(String string) {
        return ServerPlatformManager.instance().getRuntimePlatformClassNameForClass(string);
    }

    ServerPlatformAdapter buildAdapter(SessionAdapter sessionAdapter) {
        if (this.platformId.equals("NoServerPlatform")) {
            return NullServerPlatformAdapter.instance();
        }
        Constructor constructor = SCAdapter.adapterConstructor(this.getAdapterClass());
        ServerPlatformAdapter serverPlatformAdapter = (ServerPlatformAdapter)SCAdapter.buildsAdapterWith(constructor, new Object[]{sessionAdapter});
        return serverPlatformAdapter;
    }
}

