/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.scplugin.model.meta;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.Vector;
import org.eclipse.persistence.indirection.ValueHolderInterface;
import org.eclipse.persistence.tools.workbench.scplugin.model.meta.ClassRepository;
import org.eclipse.persistence.tools.workbench.utility.Classpath;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.iterators.CompositeIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.ReadOnlyListIterator;
import org.eclipse.persistence.tools.workbench.utility.node.AbstractNodeModel;

public class SCClassRepository
extends AbstractNodeModel
implements ClassRepository {
    private List classpathEntries;
    private static final Class[] CORE_KEYS = new Class[]{Object.class, ValueHolderInterface.class};
    private static Set coreClassNames;

    public SCClassRepository(String[] stringArray) {
        this.initialize(stringArray);
    }

    public void addClasspathEntries(int n, List list) {
        this.addItemsToList(n, list, this.classpathEntries, "classpathEntries");
        this.markEntireBranchDirty();
    }

    public void addClasspathEntry(int n, String string) {
        this.addItemToList(n, string, this.classpathEntries, "classpathEntries");
        this.markEntireBranchDirty();
    }

    public ListIterator classpathEntries() {
        return new ReadOnlyListIterator(this.classpathEntries);
    }

    public int classpathEntriesSize() {
        return this.classpathEntries.size();
    }

    public String displayString() {
        return "";
    }

    public String entries() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = System.getProperty("path.separator");
        ListIterator listIterator = this.classpathEntries();
        while (listIterator.hasNext()) {
            String string2 = (String)listIterator.next();
            if ("".equals(string2)) continue;
            stringBuffer.append(string2);
            if (!listIterator.hasNext()) continue;
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public String getClasspathEntry(int n) {
        return (String)this.classpathEntries.get(n);
    }

    protected void initialize() {
        super.initialize();
        this.classpathEntries = new Vector();
        this.markEntireBranchClean();
    }

    private void initialize(String[] stringArray) {
        this.classpathEntries = new Vector(stringArray.length);
        CollectionTools.addAll((Collection)this.classpathEntries, (Object[])stringArray);
    }

    public Iterator classDescriptions() {
        return new CompositeIterator(SCClassRepository.coreClassNames(), this.types());
    }

    public void refreshClassDescriptions() {
    }

    public String removeClasspathEntry(int n) {
        this.markEntireBranchDirty();
        return (String)this.removeItemFromList(n, this.classpathEntries, "classpathEntries");
    }

    public String replaceClasspathEntry(int n, String string) {
        this.markEntireBranchDirty();
        return (String)this.setItemInList(n, string, this.classpathEntries, "classpathEntries");
    }

    boolean shouldBeSaved() {
        return this.classpathEntriesSize() > 0;
    }

    public void toString(StringBuffer stringBuffer) {
        stringBuffer.append("classpathEntries=");
        stringBuffer.append(this.classpathEntries);
    }

    public Iterator types() {
        Classpath classpath = new Classpath(this.classpathEntries);
        return classpath.classNamesStream();
    }

    void update(ClassRepository classRepository) {
        this.removeItemsFromList(0, this.classpathEntriesSize(), this.classpathEntries, "classpathEntries");
        this.addItemsToList(0, CollectionTools.list((Iterator)classRepository.classpathEntries()), this.classpathEntries, "classpathEntries");
        this.markEntireBranchClean();
    }

    private static Iterator coreClassNames() {
        if (coreClassNames == null) {
            coreClassNames = SCClassRepository.buildCoreClassNames();
        }
        return coreClassNames.iterator();
    }

    private static Set buildCoreClassNames() {
        HashSet hashSet = new HashSet(10000);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < CORE_KEYS.length; ++i) {
            arrayList.add(Classpath.locationFor((Class)CORE_KEYS[i]));
        }
        Classpath classpath = new Classpath(arrayList);
        classpath.addClassNamesTo(hashSet);
        return hashSet;
    }
}

