/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.scplugin.ui.login;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.text.Document;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.resources.ResourceRepository;
import org.eclipse.persistence.tools.workbench.framework.uitools.Pane;
import org.eclipse.persistence.tools.workbench.framework.uitools.RegexpDocument;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.DatabaseLoginAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.ui.login.AbstractLoginPane;
import org.eclipse.persistence.tools.workbench.scplugin.ui.tools.BooleanCellRendererAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.ui.tools.ClassChooserTools;
import org.eclipse.persistence.tools.workbench.uitools.ComponentEnabler;
import org.eclipse.persistence.tools.workbench.uitools.Displayable;
import org.eclipse.persistence.tools.workbench.uitools.SwitcherPanel;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ReadOnlyCollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ReadOnlyListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SortedListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ComboBoxModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.DocumentAdapter;
import org.eclipse.persistence.tools.workbench.uitools.cell.AbstractCellRendererAdapter;
import org.eclipse.persistence.tools.workbench.uitools.cell.AdaptableListCellRenderer;
import org.eclipse.persistence.tools.workbench.uitools.cell.CellRendererAdapter;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.Transformer;

abstract class AbstractRdbmsLoginPane
extends AbstractLoginPane {
    private JComponent databaseSourcePane;
    private JComponent driverManagerPane;

    public AbstractRdbmsLoginPane(PropertyValueModel propertyValueModel, WorkbenchContextHolder workbenchContextHolder) {
        super(propertyValueModel, workbenchContextHolder);
    }

    private CollectionValueModel buildDatabaseDriverCollectionHolder() {
        Vector<Boolean> vector = new Vector<Boolean>();
        vector.add(Boolean.TRUE);
        vector.add(Boolean.FALSE);
        return new ReadOnlyCollectionValueModel(vector);
    }

    private ComboBoxModel buildDatabaseDriverComboBoxAdapter() {
        return new ComboBoxModelAdapter(this.buildDatabaseDriverCollectionHolder(), this.buildDatabaseDriverSelectionHolder());
    }

    private PropertyValueModel buildDatabaseDriverHolder() {
        return new PropertyAspectAdapter(this.getSubjectHolder(), "useDriverManager"){

            protected Object getValueFromSubject() {
                DatabaseLoginAdapter databaseLoginAdapter = (DatabaseLoginAdapter)this.subject;
                return databaseLoginAdapter.databaseDriverIsDriverManager();
            }
        };
    }

    private CellRendererAdapter buildDatabaseDriverLabelDecorator() {
        ResourceRepository resourceRepository = this.resourceRepository();
        return new BooleanCellRendererAdapter(resourceRepository.getString("CONNECTION_RDBMS_DRIVER_MANAGER_CHOICE"), resourceRepository.getString("CONNECTION_RDBMS_DATA_SOURCE_CHOICE"));
    }

    protected abstract PropertyValueModel buildDatabaseDriverSelectionHolder();

    private SwitcherPanel buildDatabaseDriverSwitcherPanel() {
        this.getDriverManagerPane();
        this.getDataSourcePane();
        return new SwitcherPanel(this.buildDatabaseDriverHolder(), this.buildDatabaseDriverTransformer());
    }

    private Transformer buildDatabaseDriverTransformer() {
        return new Transformer(){

            public Object transform(Object object) {
                DatabaseLoginAdapter databaseLoginAdapter = (DatabaseLoginAdapter)AbstractRdbmsLoginPane.this.subject();
                if (object == null || databaseLoginAdapter == null) {
                    return null;
                }
                if (Boolean.TRUE.equals(object)) {
                    return AbstractRdbmsLoginPane.this.getDriverManagerPane();
                }
                return AbstractRdbmsLoginPane.this.getDataSourcePane();
            }
        };
    }

    private Document buildDataSourceNameDocumentAdapter() {
        return new DocumentAdapter(this.buildDataSourceNameHolder());
    }

    private PropertyValueModel buildDataSourceNameHolder() {
        return new PropertyAspectAdapter(this.getSubjectHolder(), "dataSource"){

            protected Object getValueFromSubject() {
                DatabaseLoginAdapter databaseLoginAdapter = (DatabaseLoginAdapter)this.subject;
                return databaseLoginAdapter.getDataSourceName();
            }

            protected void setValueOnSubject(Object object) {
                DatabaseLoginAdapter databaseLoginAdapter = (DatabaseLoginAdapter)this.subject;
                databaseLoginAdapter.setDataSourceName((String)object);
            }
        };
    }

    private JComponent buildDataSourcePane() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Pane pane = new Pane(new GridBagLayout());
        pane.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        JComponent jComponent = this.buildLabeledComboBox("CONNECTION_RDBMS_LOOKUP_TYPE_FIELD", this.buildLookupTypeComboModel(), this.buildLookupTypeCellRenderer());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        pane.add((Component)jComponent, gridBagConstraints);
        JComponent jComponent2 = this.buildLabeledTextField("CONNECTION_RDBMS_DATA_SOURCE_FIELD", this.buildDataSourceNameDocumentAdapter());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        pane.add((Component)jComponent2, gridBagConstraints);
        return pane;
    }

    private JButton buildDriverClassBrowseButton() {
        return ClassChooserTools.buildBrowseButton(this.getWorkbenchContextHolder(), "CONNECTION_RDBMS_DRIVER_CLASS_BROWSE_BUTTON", this.buildClassRepositoryHolder(), this.buildDriverClassHolder());
    }

    private ListValueModel buildDriverClassCollectionHolder() {
        Collection collection = CollectionTools.collection((Iterator)DatabaseLoginAdapter.driverClasses());
        ReadOnlyCollectionValueModel readOnlyCollectionValueModel = new ReadOnlyCollectionValueModel(collection);
        return new SortedListValueModelAdapter(readOnlyCollectionValueModel);
    }

    private ComboBoxModel buildDriverClassComboAdapter() {
        return new ComboBoxModelAdapter(this.buildDriverClassCollectionHolder(), this.buildDriverClassHolder());
    }

    private PropertyValueModel buildDriverClassHolder() {
        return new PropertyAspectAdapter(this.getSubjectHolder(), "driverClass"){

            protected Object getValueFromSubject() {
                DatabaseLoginAdapter databaseLoginAdapter = (DatabaseLoginAdapter)this.subject;
                return databaseLoginAdapter.getDriverClassName();
            }

            protected void setValueOnSubject(Object object) {
                DatabaseLoginAdapter databaseLoginAdapter = (DatabaseLoginAdapter)this.subject;
                databaseLoginAdapter.setDriverClassName((String)object);
            }
        };
    }

    private JComponent buildDriverManagerPane() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Pane pane = new Pane(new GridBagLayout());
        pane.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        JComboBox<String> jComboBox = new JComboBox<String>(this.buildDriverClassComboAdapter());
        jComboBox.setEditable(true);
        jComboBox.setPrototypeDisplayValue("m");
        JTextField jTextField = (JTextField)jComboBox.getEditor().getEditorComponent();
        jTextField.setDocument(RegexpDocument.buildDocument(3));
        JComponent jComponent = this.buildLabeledComponent("CONNECTION_RDBMS_DRIVER_CLASS_COMBO_BOX", jComboBox, this.buildDriverClassBrowseButton());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        pane.add((Component)jComponent, gridBagConstraints);
        JComponent jComponent2 = this.buildLabeledEditableComboBox("CONNECTION_RDBMS_DRIVER_URL_COMBO_BOX", this.buildDriverURLComboAdapter());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        pane.add((Component)jComponent2, gridBagConstraints);
        return pane;
    }

    private ListValueModel buildDriverURLCollectionHolder() {
        return new SortedListValueModelAdapter(new CollectionAspectAdapter(this.buildDriverClassHolder()){

            protected Iterator getValueFromSubject() {
                return DatabaseLoginAdapter.driverURLs((String)this.subject);
            }
        });
    }

    private ComboBoxModel buildDriverURLComboAdapter() {
        return new ComboBoxModelAdapter(this.buildDriverURLCollectionHolder(), this.buildDriverURLHolder());
    }

    private PropertyValueModel buildDriverURLHolder() {
        return new PropertyAspectAdapter(this.getSubjectHolder(), "connectionURL"){

            protected Object getValueFromSubject() {
                DatabaseLoginAdapter databaseLoginAdapter = (DatabaseLoginAdapter)this.subject;
                return databaseLoginAdapter.getConnectionURL();
            }

            protected void setValueOnSubject(Object object) {
                DatabaseLoginAdapter databaseLoginAdapter = (DatabaseLoginAdapter)this.subject;
                databaseLoginAdapter.setConnectionURL((String)object);
            }
        };
    }

    private ListCellRenderer buildLookupTypeCellRenderer() {
        return new AdaptableListCellRenderer(new AbstractCellRendererAdapter(){

            public String buildText(Object object) {
                LookupType lookupType = (LookupType)object;
                return lookupType.displayString();
            }
        });
    }

    private ListValueModel buildLookupTypeCollectionHolder(List list) {
        return new ReadOnlyListValueModel(list);
    }

    private ComboBoxModel buildLookupTypeComboModel() {
        LookupType lookupType = new LookupType(this.resourceRepository().getString("CONNECTION_RDBMS_LOOKUP_TYPE_STRING_CHOICE"), new Integer(1));
        LookupType lookupType2 = new LookupType(this.resourceRepository().getString("CONNECTION_RDBMS_LOOKUP_TYPE_COMPOUND_NAME_CHOICE"), new Integer(3));
        LookupType lookupType3 = new LookupType(this.resourceRepository().getString("CONNECTION_RDBMS_LOOKUP_TYPE_COMPOSITE_NAME_CHOICE"), new Integer(2));
        Vector<LookupType> vector = new Vector<LookupType>(3);
        vector.add(lookupType);
        vector.add(lookupType2);
        vector.add(lookupType3);
        CollectionTools.sort(vector, (Comparator)this.buildLookupTypeComparator());
        return new ComboBoxModelAdapter(this.buildLookupTypeCollectionHolder(vector), this.buildLookupTypeHolder(vector));
    }

    private Comparator buildLookupTypeComparator() {
        return new Comparator(){

            public int compare(Object object, Object object2) {
                LookupType lookupType = (LookupType)object;
                LookupType lookupType2 = (LookupType)object2;
                return Displayable.DEFAULT_COLLATOR.compare(lookupType.displayString(), lookupType2.displayString());
            }
        };
    }

    private PropertyValueModel buildLookupTypeHolder(final List list) {
        return new PropertyAspectAdapter(this.getSubjectHolder(), "lookup"){

            private LookupType findLookupType(List list2, Integer n) {
                int n2 = list2.size();
                while (--n2 >= 0) {
                    LookupType lookupType = (LookupType)list2.get(n2);
                    if (lookupType.lookupValue().intValue() != n.intValue()) continue;
                    return lookupType;
                }
                return null;
            }

            protected Object getValueFromSubject() {
                DatabaseLoginAdapter databaseLoginAdapter = (DatabaseLoginAdapter)this.subject;
                return this.findLookupType(list, databaseLoginAdapter.getLookupType());
            }

            protected void setValueOnSubject(Object object) {
                LookupType lookupType = (LookupType)object;
                DatabaseLoginAdapter databaseLoginAdapter = (DatabaseLoginAdapter)this.subject;
                databaseLoginAdapter.setLookupType(lookupType.lookupValue());
            }
        };
    }

    private Component getDataSourcePane() {
        if (this.databaseSourcePane == null) {
            this.databaseSourcePane = this.buildDataSourcePane();
        }
        return this.databaseSourcePane;
    }

    private JComponent getDriverManagerPane() {
        if (this.driverManagerPane == null) {
            this.driverManagerPane = this.buildDriverManagerPane();
        }
        return this.driverManagerPane;
    }

    protected void initializeLayout() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JComponent jComponent = this.buildLabeledComboBox("CONNECTION_RDBMS_DATABASE_DRIVER_COMBO_BOX", this.buildDatabaseDriverComboBoxAdapter(), new AdaptableListCellRenderer(this.buildDatabaseDriverLabelDecorator()));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)jComponent, gridBagConstraints);
        SwitcherPanel switcherPanel = this.buildDatabaseDriverSwitcherPanel();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)switcherPanel, gridBagConstraints);
        JCheckBox jCheckBox = this.buildSaveUsernameCheckBox();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(2, 0, 0, 0);
        this.add((Component)jCheckBox, gridBagConstraints);
        Component component = this.buildUserNameWidgets();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(5, 10, 0, 0);
        this.add(component, gridBagConstraints);
        new ComponentEnabler((ValueModel)this.buildSaveUsernameHolder(), component);
        JCheckBox jCheckBox2 = this.buildSavePasswordCheckBox();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(2, 0, 0, 0);
        this.add((Component)jCheckBox2, gridBagConstraints);
        Component component2 = this.buildPasswordWidgets();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(5, 10, 0, 0);
        this.add(component2, gridBagConstraints);
        new ComponentEnabler((ValueModel)this.buildSavePasswordHolder(), component2);
    }

    protected void updateEnableStateOfChildren(boolean bl) {
        super.updateEnableStateOfChildren(bl);
        if (this.databaseSourcePane != null) {
            this.databaseSourcePane.setEnabled(bl);
        }
        if (this.driverManagerPane != null) {
            this.driverManagerPane.setEnabled(bl);
        }
    }

    private class LookupType {
        private String displayString;
        private Integer lookupValue;

        LookupType(String string, Integer n) {
            this.displayString = string;
            this.lookupValue = n;
        }

        public String displayString() {
            return this.displayString;
        }

        public Integer lookupValue() {
            return this.lookupValue;
        }
    }
}

