/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.scplugin.ui.project;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.uitools.AddRemoveListPanel;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.Nominative;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.SessionAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.SessionBrokerAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.TopLinkSessionsAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.ui.project.AddNewBrokerAction;
import org.eclipse.persistence.tools.workbench.scplugin.ui.project.AddNewSessionAction;
import org.eclipse.persistence.tools.workbench.scplugin.ui.tools.AbstractSessionsListPane;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;

final class SessionsListPane
extends AbstractSessionsListPane {
    SessionsListPane(PropertyValueModel propertyValueModel, WorkbenchContextHolder workbenchContextHolder) {
        super(propertyValueModel, workbenchContextHolder);
    }

    protected void addNewSession() {
        AddNewSessionAction addNewSessionAction = new AddNewSessionAction(this.getWorkbenchContext(), false);
        addNewSessionAction.execute();
    }

    protected void addNewSessionBroker() {
        AddNewBrokerAction addNewBrokerAction = new AddNewBrokerAction(this.getWorkbenchContext(), false);
        addNewBrokerAction.execute();
    }

    protected AddRemoveListPanel buildSessionListPane() {
        return new ExtendedSessionListPanel();
    }

    protected CollectionValueModel buildSessionsCollectionHolder() {
        return new CollectionAspectAdapter(this.getSubjectHolder(), "sessions"){

            protected Iterator getValueFromSubject() {
                TopLinkSessionsAdapter topLinkSessionsAdapter = (TopLinkSessionsAdapter)this.subject;
                return topLinkSessionsAdapter.sessions();
            }

            protected int sizeFromSubject() {
                TopLinkSessionsAdapter topLinkSessionsAdapter = (TopLinkSessionsAdapter)this.subject;
                return topLinkSessionsAdapter.sessionsSize();
            }
        };
    }

    protected boolean canRemoveSessions(Collection collection) {
        int n;
        Nominative nominative = (Nominative)this.subject();
        String string = nominative.getName();
        Vector vector = this.retrieveSessionBrokerWithManagedSessions(collection);
        if (!vector.isEmpty()) {
            if (vector.size() == 1) {
                SessionBrokerAdapter sessionBrokerAdapter = (SessionBrokerAdapter)vector.firstElement();
                JOptionPane.showMessageDialog(this.currentWindow(), this.resourceRepository().getString("DELETE_BROKER_MESSAGE", sessionBrokerAdapter.displayString()), this.resourceRepository().getString("DELETE_BROKER_TITLE"), 2);
            } else {
                JOptionPane.showMessageDialog(this.currentWindow(), this.resourceRepository().getString("DELETE_BROKERS_MESSAGE"), this.resourceRepository().getString("DELETE_BROKER_TITLE"), 2);
            }
            n = 1;
        } else if (collection.size() == 1) {
            SessionAdapter sessionAdapter = (SessionAdapter)collection.iterator().next();
            n = JOptionPane.showConfirmDialog(this.currentWindow(), this.resourceRepository().getString("PROJECT_SESSIONS_PROMPT_REMOVE_SINGLE", sessionAdapter.displayString(), string), this.resourceRepository().getString("PROJECT_SESSIONS_PROMPT_REMOVE_SINGLE_TITLE"), 0);
        } else {
            n = JOptionPane.showConfirmDialog(this.currentWindow(), this.resourceRepository().getString("PROJECT_SESSIONS_PROMPT_REMOVE_MULTI", string), this.resourceRepository().getString("PROJECT_SESSIONS_PROMPT_REMOVE_MULTI_TITLE"), 0);
        }
        return n == 0;
    }

    private Vector retrieveSessionBrokerWithManagedSessions(Collection collection) {
        Vector<SessionBrokerAdapter> vector = new Vector<SessionBrokerAdapter>();
        for (SessionAdapter sessionAdapter : collection) {
            SessionBrokerAdapter sessionBrokerAdapter;
            if (!sessionAdapter.isBroker() || (sessionBrokerAdapter = (SessionBrokerAdapter)sessionAdapter).sessionsSize() <= 0) continue;
            vector.add(sessionBrokerAdapter);
        }
        return vector;
    }

    protected void removeSessions(Collection collection) {
        TopLinkSessionsAdapter topLinkSessionsAdapter = (TopLinkSessionsAdapter)this.subject();
        topLinkSessionsAdapter.removeSessions(collection);
    }

    private class ExtendedSessionListPanel
    extends AbstractSessionsListPane.CustomizedSessionListPanel {
        private ExtendedSessionListPanel() {
            super(SessionsListPane.this);
        }

        private ActionListener buildAddBrokerAction() {
            return new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    SessionsListPane.this.addNewSessionBroker();
                }
            };
        }

        protected JButton buildAddBrokerButton() {
            JButton jButton = this.buildButton("PROJECT_SESSIONS_BROKER_ADD_BUTTON");
            jButton.addActionListener(this.buildAddBrokerAction());
            return jButton;
        }

        protected void buildButtonPanel(JComponent jComponent, JButton jButton, JButton jButton2, JButton jButton3) {
            jComponent.add(jButton);
            jComponent.add(this.buildAddBrokerButton());
            jComponent.add(jButton2);
            jComponent.add(jButton3);
        }
    }
}

