/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.scplugin.ui.session.basic;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Collections;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.text.Document;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.view.ScrollablePropertiesPage;
import org.eclipse.persistence.tools.workbench.framework.uitools.RegexpDocument;
import org.eclipse.persistence.tools.workbench.framework.uitools.TriStateBooleanCellRendererAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.SCAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.SessionAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.ui.session.basic.EventListenersPane;
import org.eclipse.persistence.tools.workbench.scplugin.ui.tools.ClassChooserTools;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ReadOnlyCollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ComboBoxModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.DocumentAdapter;
import org.eclipse.persistence.tools.workbench.uitools.cell.AdaptableListCellRenderer;
import org.eclipse.persistence.tools.workbench.uitools.cell.CellRendererAdapter;
import org.eclipse.persistence.tools.workbench.utility.TriStateBoolean;

public final class SessionOptionsPropertiesPage
extends ScrollablePropertiesPage {
    public SessionOptionsPropertiesPage(PropertyValueModel propertyValueModel, WorkbenchContextHolder workbenchContextHolder) {
        super(propertyValueModel, workbenchContextHolder);
    }

    private ValueModel buildClassRepositoryHolder() {
        return new PropertyAspectAdapter(this.getSelectionHolder()){

            protected Object getValueFromSubject() {
                SCAdapter sCAdapter = (SCAdapter)((Object)this.subject);
                return sCAdapter.getClassRepository();
            }
        };
    }

    private JButton buildExceptionHandlerBrowseButton() {
        return ClassChooserTools.buildBrowseButton(this.getWorkbenchContextHolder(), "OPTIONS_EXCEPTION_HANDLER_BROWSE_BUTTON", this.buildClassRepositoryHolder(), this.buildExceptionHandlerHolder());
    }

    private Document buildExceptionHandlerDocumentAdapter() {
        return new DocumentAdapter(this.buildExceptionHandlerHolder(), new RegexpDocument(3));
    }

    private PropertyValueModel buildExceptionHandlerHolder() {
        return new PropertyAspectAdapter(this.getSelectionHolder(), "exceptionHandlerClass"){

            protected Object getValueFromSubject() {
                SessionAdapter sessionAdapter = (SessionAdapter)this.subject;
                return sessionAdapter.getExceptionHandlerClass();
            }

            protected void setValueOnSubject(Object object) {
                SessionAdapter sessionAdapter = (SessionAdapter)this.subject;
                sessionAdapter.setExceptionHandlerClass((String)object);
            }
        };
    }

    protected Component buildPage() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = BorderFactory.createTitledBorder("m").getBorderInsets(this);
        insets.right += 5;
        insets.left += 5;
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JComponent jComponent = this.buildLabeledComboBox("OPTIONS_PROFILER_COMBO_BOX", this.buildProfilerComboBoxAdapter(), new AdaptableListCellRenderer(this.buildProfilerLabelDecorator()));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, insets.left, 0, insets.right);
        jPanel.add((Component)jComponent, gridBagConstraints);
        this.addHelpTopicId(jComponent, "session.options.profiler");
        JComponent jComponent2 = this.buildLabeledTextField("OPTIONS_EXCEPTION_HANDLER_FIELD", this.buildExceptionHandlerDocumentAdapter(), this.buildExceptionHandlerBrowseButton());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(5, insets.left, 0, insets.right);
        jPanel.add((Component)jComponent2, gridBagConstraints);
        this.addHelpTopicId(jComponent2, "session.options.exceptionHandler");
        JComponent jComponent3 = this.buildLabeledTextField("OPTIONS_SESSION_CUSTOMIZER_CLASS_FIELD", this.buildSessionCustomizerClassDocumentAdapter(), this.buildSessionCustomizerBrowseButton());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(5, insets.left, 0, insets.right);
        jPanel.add((Component)jComponent3, gridBagConstraints);
        this.addHelpTopicId(jComponent3, "session.options.sessionCustomizerClass");
        EventListenersPane eventListenersPane = new EventListenersPane(this.getSelectionHolder(), this.getWorkbenchContextHolder());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 19;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        jPanel.add((Component)eventListenersPane, gridBagConstraints);
        this.addPaneForAlignment(eventListenersPane);
        this.addHelpTopicId(jPanel, "session.options");
        return jPanel;
    }

    private CollectionValueModel buildProfilerCollectionHolder() {
        Vector<TriStateBoolean> vector = new Vector<TriStateBoolean>();
        vector.add(TriStateBoolean.UNDEFINED);
        if (this.isTopLinkProfilerFirst()) {
            vector.add(TriStateBoolean.TRUE);
            vector.add(TriStateBoolean.FALSE);
        } else {
            vector.add(TriStateBoolean.FALSE);
            vector.add(TriStateBoolean.TRUE);
        }
        return new ReadOnlyCollectionValueModel(vector);
    }

    private ComboBoxModel buildProfilerComboBoxAdapter() {
        return new ComboBoxModelAdapter(this.buildProfilerCollectionHolder(), this.buildProfilerSelectionHolder());
    }

    private CellRendererAdapter buildProfilerLabelDecorator() {
        return new TriStateBooleanCellRendererAdapter(this.resourceRepository()){

            protected String undefinedResourceKey() {
                return "OPTIONS_PROFILER_NO_PROFILER_CHOICE";
            }

            protected String trueResourceKey() {
                return "OPTIONS_PROFILER_TOPLINK_CHOICE";
            }

            protected String falseResourceKey() {
                return "OPTIONS_PROFILER_DMS_CHOICE";
            }
        };
    }

    private PropertyValueModel buildProfilerSelectionHolder() {
        return new PropertyAspectAdapter(this.getSelectionHolder(), "profiler"){

            protected Object getValueFromSubject() {
                SessionAdapter sessionAdapter = (SessionAdapter)this.subject;
                String string = sessionAdapter.getProfiler();
                if (string == null) {
                    return TriStateBoolean.UNDEFINED;
                }
                boolean bl = "toplink".equals(string);
                return TriStateBoolean.valueOf((boolean)bl);
            }

            protected void setValueOnSubject(Object object) {
                SessionAdapter sessionAdapter = (SessionAdapter)this.subject;
                if (TriStateBoolean.UNDEFINED.equals(object)) {
                    sessionAdapter.setProfiler(null);
                } else if (TriStateBoolean.TRUE.equals(object)) {
                    sessionAdapter.setProfiler("toplink");
                } else {
                    sessionAdapter.setProfiler("dms");
                }
            }
        };
    }

    private JButton buildSessionCustomizerBrowseButton() {
        return ClassChooserTools.buildBrowseButton(this.getWorkbenchContextHolder(), "OPTIONS_SESSION_CUSTOMIZER_CLASS_BROWSE_BUTTON", this.buildClassRepositoryHolder(), this.buildSessionCustomizerClassHolder());
    }

    private Document buildSessionCustomizerClassDocumentAdapter() {
        return new DocumentAdapter(this.buildSessionCustomizerClassHolder(), new RegexpDocument(3));
    }

    private PropertyValueModel buildSessionCustomizerClassHolder() {
        return new PropertyAspectAdapter(this.getSelectionHolder(), "sessionCustomizerClass"){

            protected Object getValueFromSubject() {
                SessionAdapter sessionAdapter = (SessionAdapter)this.subject;
                return sessionAdapter.getSessionCustomizerClass();
            }

            protected void setValueOnSubject(Object object) {
                SessionAdapter sessionAdapter = (SessionAdapter)this.subject;
                sessionAdapter.setSessionCustomizerClass((String)object);
            }
        };
    }

    private boolean isTopLinkProfilerFirst() {
        Vector<String> vector = new Vector<String>();
        vector.add(this.resourceRepository().getString("OPTIONS_PROFILER_TOPLINK_CHOICE"));
        vector.add(this.resourceRepository().getString("OPTIONS_PROFILER_DMS_CHOICE"));
        Collections.sort(vector);
        return vector.firstElement().equals(this.resourceRepository().getString("OPTIONS_PROFILER_TOPLINK_CHOICE"));
    }
}

