/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.scplugin.ui.session.login;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.platformsmodel.DatabasePlatform;
import org.eclipse.persistence.tools.workbench.platformsmodel.DatabasePlatformRepository;
import org.eclipse.persistence.tools.workbench.platformsplugin.ui.PlatformComponentFactory;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.DatabaseLoginAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.DatabaseSessionAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.SCAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.ServerPlatformAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.SessionAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.SessionBrokerAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.ui.login.LoginExternalOptionsPane;
import org.eclipse.persistence.tools.workbench.scplugin.ui.login.RdbmsLoginPane;
import org.eclipse.persistence.tools.workbench.scplugin.ui.session.login.AbstractLoginPropertiesPage;
import org.eclipse.persistence.tools.workbench.uitools.ComponentEnabler;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.utility.Model;
import org.eclipse.persistence.tools.workbench.utility.node.AbstractNodeModel;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public class RdbmsConnectionPropertiesPage
extends AbstractLoginPropertiesPage {
    private PseudoExternalConnectionPoolingModel pseudoModel;

    public RdbmsConnectionPropertiesPage(PropertyValueModel propertyValueModel, WorkbenchContextHolder workbenchContextHolder) {
        super(propertyValueModel, workbenchContextHolder);
        this.addHelpTopicId(this, "session.login.database.connection");
    }

    private PropertyValueModel buildDatabasePlatformHolder() {
        return new PropertyAspectAdapter(this.getSelectionHolder(), "platformClass"){

            protected Object getValueFromSubject() {
                DatabaseLoginAdapter databaseLoginAdapter = (DatabaseLoginAdapter)this.subject;
                String string = databaseLoginAdapter.getPlatformClass();
                if (string == null) {
                    return null;
                }
                try {
                    return DatabasePlatformRepository.getDefault().platformForRuntimePlatformClassNamed(string);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    return null;
                }
            }

            protected void setValueOnSubject(Object object) {
                DatabaseLoginAdapter databaseLoginAdapter = (DatabaseLoginAdapter)this.subject;
                DatabasePlatform databasePlatform = (DatabasePlatform)object;
                if (databasePlatform != null) {
                    databaseLoginAdapter.setPlatformClass(databasePlatform.getRuntimePlatformClassName());
                }
            }
        };
    }

    protected Component buildPage() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JComponent jComponent = this.buildLabeledComponent("CONNECTION_RDBMS_DATABASE_PLATFORM_FIELD", PlatformComponentFactory.buildPlatformChooser(this.buildDatabasePlatformHolder()));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)jComponent, gridBagConstraints);
        this.addHelpTopicId(jComponent, "session.login.database.connection.platform");
        RdbmsLoginPane rdbmsLoginPane = new RdbmsLoginPane(this.getSelectionHolder(), this.getWorkbenchContextHolder());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        jPanel.add((Component)rdbmsLoginPane, gridBagConstraints);
        this.addPaneForAlignment(rdbmsLoginPane);
        CustomizedExternalOptionsPane customizedExternalOptionsPane = new CustomizedExternalOptionsPane();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        jPanel.add((Component)customizedExternalOptionsPane, gridBagConstraints);
        return jPanel;
    }

    private PropertyChangeListener buildSelectionHolderListener() {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                RdbmsConnectionPropertiesPage.this.pseudoModel.setParentNode((Node)((AbstractNodeModel)propertyChangeEvent.getNewValue()));
            }
        };
    }

    protected void initialize(PropertyValueModel propertyValueModel) {
        super.initialize(propertyValueModel);
        this.getSelectionHolder().addPropertyChangeListener("value", this.buildSelectionHolderListener());
        this.pseudoModel = new PseudoExternalConnectionPoolingModel();
        this.pseudoModel.setParentNode((Node)((AbstractNodeModel)this.selection()));
    }

    private class PseudoExternalConnectionPoolingModel
    extends AbstractNodeModel {
        private boolean enabled;
        private PropertyChangeListener listener;
        private PropertyChangeListener managedListener;
        private PropertyChangeListener serverPlatformListener;
        private SessionBrokerAdapter sessionBroker;
        public static final String ENABLED_PROPERTY = "enabled";

        private PseudoExternalConnectionPoolingModel() {
        }

        private PropertyChangeListener buildManagedPropertyChangeListener() {
            return new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    SCAdapter sCAdapter;
                    DatabaseLoginAdapter databaseLoginAdapter = (DatabaseLoginAdapter)PseudoExternalConnectionPoolingModel.this.getParent();
                    SessionAdapter sessionAdapter = (SessionAdapter)databaseLoginAdapter.getParent();
                    if (PseudoExternalConnectionPoolingModel.this.sessionBroker != null) {
                        sCAdapter = PseudoExternalConnectionPoolingModel.this.sessionBroker.getServerPlatform();
                        sCAdapter.removePropertyChangeListener("enableJTA", PseudoExternalConnectionPoolingModel.this.listener);
                    }
                    sCAdapter = (DatabaseSessionAdapter)sessionAdapter;
                    PseudoExternalConnectionPoolingModel.this.sessionBroker = ((DatabaseSessionAdapter)sCAdapter).getBroker();
                    ServerPlatformAdapter serverPlatformAdapter = sessionAdapter.getServerPlatform();
                    serverPlatformAdapter.addPropertyChangeListener("enableJTA", PseudoExternalConnectionPoolingModel.this.listener);
                    PseudoExternalConnectionPoolingModel.this.updateEnableState();
                }
            };
        }

        private PropertyChangeListener buildPropertyChangeListener() {
            return new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    PseudoExternalConnectionPoolingModel.this.updateEnableState();
                }
            };
        }

        private PropertyChangeListener buildServerPlatformPropertyChangeListener() {
            return new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    ServerPlatformAdapter serverPlatformAdapter = (ServerPlatformAdapter)((Object)propertyChangeEvent.getOldValue());
                    serverPlatformAdapter.removePropertyChangeListener("enableJTA", PseudoExternalConnectionPoolingModel.this.listener);
                    ServerPlatformAdapter serverPlatformAdapter2 = (ServerPlatformAdapter)((Object)propertyChangeEvent.getNewValue());
                    serverPlatformAdapter2.addPropertyChangeListener("enableJTA", PseudoExternalConnectionPoolingModel.this.listener);
                    PseudoExternalConnectionPoolingModel.this.updateEnableState();
                }
            };
        }

        protected void checkParent(Node node) {
        }

        private void disengageListeners() {
            DatabaseLoginAdapter databaseLoginAdapter = (DatabaseLoginAdapter)this.getParent();
            databaseLoginAdapter.removePropertyChangeListener("useDriverManager", this.listener);
            SessionAdapter sessionAdapter = (SessionAdapter)databaseLoginAdapter.getParent();
            sessionAdapter.removePropertyChangeListener("serverPlatform", this.serverPlatformListener);
            ServerPlatformAdapter serverPlatformAdapter = this.sessionBroker != null ? this.sessionBroker.getServerPlatform() : sessionAdapter.getServerPlatform();
            serverPlatformAdapter.removePropertyChangeListener("enableJTA", this.listener);
            if (!sessionAdapter.isBroker()) {
                DatabaseSessionAdapter databaseSessionAdapter = (DatabaseSessionAdapter)sessionAdapter;
                databaseSessionAdapter.removePropertyChangeListener("managedByBroker", this.managedListener);
                this.sessionBroker = null;
            }
        }

        public String displayString() {
            return null;
        }

        private void engageListeners() {
            DatabaseLoginAdapter databaseLoginAdapter = (DatabaseLoginAdapter)this.getParent();
            databaseLoginAdapter.addPropertyChangeListener("useDriverManager", this.listener);
            SessionAdapter sessionAdapter = (SessionAdapter)databaseLoginAdapter.getParent();
            sessionAdapter.addPropertyChangeListener("serverPlatform", this.serverPlatformListener);
            ServerPlatformAdapter serverPlatformAdapter = sessionAdapter.getServerPlatform();
            serverPlatformAdapter.addPropertyChangeListener("enableJTA", this.listener);
            if (!sessionAdapter.isBroker()) {
                DatabaseSessionAdapter databaseSessionAdapter = (DatabaseSessionAdapter)sessionAdapter;
                databaseSessionAdapter.addPropertyChangeListener("managedByBroker", this.managedListener);
                this.sessionBroker = databaseSessionAdapter.getBroker();
            }
        }

        protected void initialize() {
            super.initialize();
            this.listener = this.buildPropertyChangeListener();
            this.managedListener = this.buildManagedPropertyChangeListener();
            this.serverPlatformListener = this.buildServerPlatformPropertyChangeListener();
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean bl) {
            boolean bl2 = this.isEnabled();
            this.enabled = bl;
            this.firePropertyChanged(ENABLED_PROPERTY, bl2, bl);
        }

        public void setParentNode(Node node) {
            if (this.getParent() != null) {
                this.disengageListeners();
            }
            super.setParent(node);
            if (node != null) {
                this.engageListeners();
                this.updateEnableState();
            }
        }

        private void updateEnableState() {
            boolean bl;
            DatabaseLoginAdapter databaseLoginAdapter = (DatabaseLoginAdapter)this.getParent();
            DatabaseSessionAdapter databaseSessionAdapter = (DatabaseSessionAdapter)databaseLoginAdapter.getParent();
            boolean bl2 = bl = databaseLoginAdapter.databaseDriverIsDriverManager() && !databaseSessionAdapter.hasJTA();
            if (databaseSessionAdapter.isManaged() && databaseSessionAdapter.getBroker().hasJTA()) {
                bl = false;
            }
            this.setEnabled(bl);
        }
    }

    private class CustomizedExternalOptionsPane
    extends LoginExternalOptionsPane {
        protected CustomizedExternalOptionsPane() {
            super(RdbmsConnectionPropertiesPage.this.getSelectionHolder(), RdbmsConnectionPropertiesPage.this.getApplicationContext());
        }

        protected JCheckBox buildExternalConnectionPoolingCheckBox() {
            JCheckBox jCheckBox = super.buildExternalConnectionPoolingCheckBox();
            this.buildExternalConnectionPoolingEnabler(jCheckBox);
            return jCheckBox;
        }

        private ComponentEnabler buildExternalConnectionPoolingEnabler(JCheckBox jCheckBox) {
            return new ComponentEnabler((ValueModel)this.buildExternalConnectionPoolingEnableStateHolder(), Collections.singleton(jCheckBox));
        }

        private PropertyValueModel buildExternalConnectionPoolingEnableStateHolder() {
            return new PropertyAspectAdapter("enabled", (Model)RdbmsConnectionPropertiesPage.this.pseudoModel){

                protected Object getValueFromSubject() {
                    PseudoExternalConnectionPoolingModel pseudoExternalConnectionPoolingModel = (PseudoExternalConnectionPoolingModel)((Object)this.subject);
                    return pseudoExternalConnectionPoolingModel.isEnabled();
                }
            };
        }
    }
}

