/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.uitools;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import org.eclipse.persistence.tools.workbench.uitools.RecentFilesManager;
import org.eclipse.persistence.tools.workbench.utility.AbstractModel;

public final class PreferencesRecentFilesManager
extends AbstractModel
implements RecentFilesManager {
    private Preferences recentFilesNode;
    private PreferenceChangeListener recentFilesListener;
    private List recentFiles;
    private Preferences maxSizeNode;
    String maxSizeKeyName;
    private PreferenceChangeListener maxSizeListener;
    private int maxSize;

    public PreferencesRecentFilesManager(Preferences preferences, Preferences preferences2, String string) {
        this.initialize(preferences, preferences2, string);
    }

    protected void initialize() {
        super.initialize();
        this.recentFilesListener = this.buildRecentFilesListener();
        this.maxSizeListener = this.buildMaxSizeListener();
    }

    private PreferenceChangeListener buildRecentFilesListener() {
        return new PreferenceChangeListener(){

            public void preferenceChange(PreferenceChangeEvent preferenceChangeEvent) {
                PreferencesRecentFilesManager.this.recentFilesChanged(preferenceChangeEvent.getKey(), preferenceChangeEvent.getNewValue());
            }

            public String toString() {
                return "recent files listener";
            }
        };
    }

    private PreferenceChangeListener buildMaxSizeListener() {
        return new PreferenceChangeListener(){

            public void preferenceChange(PreferenceChangeEvent preferenceChangeEvent) {
                if (preferenceChangeEvent.getKey().equals(PreferencesRecentFilesManager.this.maxSizeKeyName)) {
                    PreferencesRecentFilesManager.this.maxSizeChanged();
                }
            }

            public String toString() {
                return "max size listener";
            }
        };
    }

    private void initialize(Preferences preferences, Preferences preferences2, String string) {
        this.recentFilesNode = preferences;
        preferences.addPreferenceChangeListener(this.recentFilesListener);
        this.maxSizeNode = preferences2;
        this.maxSizeKeyName = string;
        preferences2.addPreferenceChangeListener(this.maxSizeListener);
        this.maxSize = this.buildMaxSize();
        this.checkMaxSize(this.maxSize);
        this.recentFiles = this.buildRecentFiles();
    }

    public synchronized int getMaxSize() {
        return this.maxSize;
    }

    public synchronized void setMaxSize(int n) {
        if (this.maxSize == n) {
            return;
        }
        this.checkMaxSize(n);
        this.maxSize = n;
        List list = this.recentFiles;
        this.recentFiles = this.buildRecentFiles();
        if (!((Object)list).equals(this.recentFiles)) {
            this.fireStateChanged();
        }
        this.maxSizeNode.putInt(this.maxSizeKeyName, n);
    }

    public synchronized File[] getRecentFiles() {
        return this.recentFiles.toArray(new File[this.recentFiles.size()]);
    }

    public synchronized void setMostRecentFile(File file) {
        int n = this.recentFiles.indexOf(file);
        if (n == 0) {
            return;
        }
        if (n == -1) {
            this.recentFiles.add(0, file);
            if (this.recentFiles.size() > this.maxSize) {
                while (this.recentFiles.size() > this.maxSize) {
                    this.recentFiles.remove(this.recentFiles.size() - 1);
                }
            }
            this.fireStateChanged();
            this.replacePreferences(this.recentFiles);
        } else {
            this.recentFiles.remove(n);
            this.recentFiles.add(0, file);
            this.fireStateChanged();
            this.replacePreferences(this.recentFiles.subList(0, n + 1));
        }
    }

    public synchronized void removeRecentFile(File file) {
        int n = this.recentFiles.indexOf(file);
        if (n == -1) {
            return;
        }
        this.recentFiles.remove(n);
        this.fireStateChanged();
        this.recentFilesNode.remove(Integer.toString(this.recentFiles.size() + 1));
        this.replacePreferences(this.recentFiles);
    }

    private int buildMaxSize() {
        return this.maxSizeNode.getInt(this.maxSizeKeyName, 4);
    }

    private void checkMaxSize(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("the maximum size must not be negative");
        }
        if (n > 9) {
            throw new IllegalArgumentException("the maximum size must be less than 9");
        }
    }

    private List buildRecentFiles() {
        ArrayList<File> arrayList = new ArrayList<File>(this.maxSize);
        int n = 1;
        String string = this.recentFilesNode.get(Integer.toString(n), null);
        while (string != null && n <= this.maxSize) {
            arrayList.add(new File(string));
            string = this.recentFilesNode.get(Integer.toString(++n), null);
        }
        return arrayList;
    }

    private void replacePreferences(List list) {
        for (int i = 0; i < list.size(); ++i) {
            this.recentFilesNode.put(Integer.toString(i + 1), ((File)list.get(i)).getPath());
        }
    }

    synchronized void recentFilesChanged(String string, String string2) {
        int n = 0;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return;
        }
        if (!Integer.toString(n).equals(string)) {
            return;
        }
        if (n < 1 || n > this.recentFiles.size() + 1 || n > this.maxSize) {
            return;
        }
        int n2 = n - 1;
        if (string2 == null) {
            while (this.recentFiles.size() > n2) {
                this.recentFiles.remove(this.recentFiles.size() - 1);
            }
            this.fireStateChanged();
            return;
        }
        File file = new File(string2);
        if (n2 == this.recentFiles.size()) {
            this.recentFiles.add(file);
            this.fireStateChanged();
            return;
        }
        if (file.equals(this.recentFiles.get(n2))) {
            return;
        }
        this.recentFiles.set(n2, file);
        this.fireStateChanged();
    }

    synchronized void maxSizeChanged() {
        int n = this.buildMaxSize();
        if (this.maxSize == n) {
            return;
        }
        this.checkMaxSize(n);
        this.maxSize = n;
        List list = this.recentFiles;
        this.recentFiles = this.buildRecentFiles();
        if (!((Object)list).equals(this.recentFiles)) {
            this.fireStateChanged();
        }
    }
}

