/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.uitools;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JPanel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.utility.Transformer;

public class SwitcherPanel
extends JPanel {
    private PropertyValueModel valueHolder;
    private Transformer transformer;
    private PropertyChangeListener listener;

    private SwitcherPanel() {
        super(new BorderLayout());
        this.initialize();
    }

    public SwitcherPanel(PropertyValueModel propertyValueModel, Transformer transformer) {
        this();
        this.initialize(propertyValueModel, transformer);
    }

    public SwitcherPanel(PropertyValueModel propertyValueModel) {
        this(propertyValueModel, Transformer.NULL_INSTANCE);
    }

    protected void initialize() {
        this.listener = this.buildListener();
    }

    protected PropertyChangeListener buildListener() {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                SwitcherPanel.this.valueChanged(propertyChangeEvent.getNewValue());
            }

            public String toString() {
                return "value listener";
            }
        };
    }

    protected void initialize(PropertyValueModel propertyValueModel, Transformer transformer) {
        if (propertyValueModel == null) {
            throw new NullPointerException();
        }
        this.valueHolder = propertyValueModel;
        this.valueHolder.addPropertyChangeListener("value", this.listener);
        this.transformer = transformer;
        this.valueChanged(propertyValueModel.getValue());
    }

    protected void valueChanged(Object object) {
        Component component = null;
        Component component2 = (Component)this.transformer.transform(object);
        if (this.getComponentCount() > 0) {
            component = this.getComponent(0);
            if (component == component2) {
                return;
            }
            this.remove(0);
        }
        if (component == null && component2 == null) {
            return;
        }
        if (component2 != null) {
            this.add(component2, "Center");
        }
        if (this.isShowing()) {
            this.revalidate();
            this.repaint();
        }
    }
}

