/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.uitools.app;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModelWrapper;
import org.eclipse.persistence.tools.workbench.uitools.app.SimplePropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;

public class BufferedPropertyValueModel
extends PropertyValueModelWrapper {
    protected Object bufferedValue;
    protected boolean accepting;
    protected ValueModel triggerHolder;
    protected PropertyChangeListener triggerChangeListener;
    protected static final Object UNASSIGNED = new Object();

    public BufferedPropertyValueModel(PropertyValueModel propertyValueModel, ValueModel valueModel) {
        super(propertyValueModel);
        this.initializeTriggerHolder(valueModel);
    }

    protected void initialize() {
        super.initialize();
        this.bufferedValue = UNASSIGNED;
        this.accepting = false;
        this.triggerChangeListener = this.buildTriggerChangeListener();
    }

    protected PropertyChangeListener buildTriggerChangeListener() {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                BufferedPropertyValueModel.this.triggerChanged(propertyChangeEvent);
            }

            public String toString() {
                return "trigger change listener";
            }
        };
    }

    protected void initializeTriggerHolder(ValueModel valueModel) {
        if (valueModel == null) {
            throw new NullPointerException();
        }
        this.triggerHolder = valueModel;
    }

    public Object getValue() {
        return this.bufferedValue == UNASSIGNED ? this.valueHolder.getValue() : this.bufferedValue;
    }

    public void setValue(Object object) {
        Object object2 = this.getValue();
        this.bufferedValue = object;
        this.firePropertyChanged("value", object2, this.bufferedValue);
    }

    protected void engageValueHolder() {
        super.engageValueHolder();
        this.triggerHolder.addPropertyChangeListener("value", this.triggerChangeListener);
    }

    protected void disengageValueHolder() {
        this.triggerHolder.removePropertyChangeListener("value", this.triggerChangeListener);
        super.disengageValueHolder();
    }

    protected void valueChanged(PropertyChangeEvent propertyChangeEvent) {
        if (this.accepting) {
            return;
        }
        if (this.bufferedValue == UNASSIGNED) {
            this.firePropertyChanged(propertyChangeEvent.getPropertyName(), propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
        } else {
            this.handleChangeConflict(propertyChangeEvent);
        }
    }

    protected void handleChangeConflict(PropertyChangeEvent propertyChangeEvent) {
    }

    protected void triggerChanged(PropertyChangeEvent propertyChangeEvent) {
        if (this.bufferedValue == UNASSIGNED) {
            return;
        }
        if (((Boolean)propertyChangeEvent.getNewValue()).booleanValue()) {
            this.accepting = true;
            this.valueHolder.setValue(this.bufferedValue);
            this.bufferedValue = UNASSIGNED;
            this.accepting = false;
        } else {
            Object object = this.bufferedValue;
            this.bufferedValue = UNASSIGNED;
            this.firePropertyChanged("value", object, this.valueHolder.getValue());
        }
    }

    public void toString(StringBuffer stringBuffer) {
        stringBuffer.append(this.getValue());
    }

    public boolean isBuffering() {
        return this.bufferedValue != UNASSIGNED;
    }

    public static class Trigger
    extends SimplePropertyValueModel {
        public Object getValue() {
            if (this.value == null) {
                throw new IllegalStateException("The method Trigger.getValue() may only be called during change notification.");
            }
            return this.value;
        }

        public void setValue(Object object) {
            super.setValue(object);
            this.value = null;
        }

        public void setValue(boolean bl) {
            this.setValue((Object)bl);
        }

        public boolean booleanValue() {
            return (Boolean)this.getValue();
        }

        public void accept() {
            this.setValue(true);
        }

        public boolean isAccepted() {
            return this.booleanValue();
        }

        public void reset() {
            this.setValue(false);
        }

        public boolean isReset() {
            return !this.booleanValue();
        }
    }
}

