/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.uitools.app;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModelWrapper;
import org.eclipse.persistence.tools.workbench.utility.Counter;
import org.eclipse.persistence.tools.workbench.utility.Model;
import org.eclipse.persistence.tools.workbench.utility.events.ListChangeEvent;

public abstract class ItemAspectListValueModelAdapter
extends ListValueModelWrapper {
    protected IdentityHashMap counters;

    protected ItemAspectListValueModelAdapter(ListValueModel listValueModel) {
        super(listValueModel);
    }

    protected ItemAspectListValueModelAdapter(CollectionValueModel collectionValueModel) {
        this(new CollectionListValueModelAdapter(collectionValueModel));
    }

    protected void initialize() {
        super.initialize();
        this.counters = new IdentityHashMap();
    }

    public Object getValue() {
        return this.listHolder.getValue();
    }

    public void addItem(int n, Object object) {
        this.listHolder.addItem(n, object);
    }

    public void addItems(int n, List list) {
        this.listHolder.addItems(n, list);
    }

    public Object removeItem(int n) {
        return this.listHolder.removeItem(n);
    }

    public List removeItems(int n, int n2) {
        return this.listHolder.removeItems(n, n2);
    }

    public Object replaceItem(int n, Object object) {
        return this.listHolder.replaceItem(n, object);
    }

    public List replaceItems(int n, List list) {
        return this.listHolder.replaceItems(n, list);
    }

    public Object getItem(int n) {
        return this.listHolder.getItem(n);
    }

    public int size() {
        return this.listHolder.size();
    }

    protected void engageModel() {
        super.engageModel();
        this.engageAllItems();
    }

    protected void engageAllItems() {
        this.engageItems((ListIterator)this.listHolder.getValue());
    }

    protected void engageItems(Iterator iterator) {
        while (iterator.hasNext()) {
            this.engageItem(iterator.next());
        }
    }

    protected void engageItem(Object object) {
        Counter counter = (Counter)this.counters.get(object);
        if (counter == null) {
            counter = new Counter();
            this.counters.put(object, counter);
            this.startListeningToItem((Model)object);
        }
        counter.increment();
    }

    protected abstract void startListeningToItem(Model var1);

    protected void disengageModel() {
        this.disengageAllItems();
        super.disengageModel();
    }

    protected void disengageAllItems() {
        this.disengageItems((ListIterator)this.listHolder.getValue());
    }

    protected void disengageItems(Iterator iterator) {
        while (iterator.hasNext()) {
            this.disengageItem(iterator.next());
        }
    }

    protected void disengageItem(Object object) {
        Counter counter = (Counter)this.counters.get(object);
        if (counter == null) {
            throw new IllegalStateException("missing counter: " + object);
        }
        if (counter.decrement() == 0) {
            this.counters.remove(object);
            this.stopListeningToItem((Model)object);
        }
    }

    protected abstract void stopListeningToItem(Model var1);

    protected void itemsAdded(ListChangeEvent listChangeEvent) {
        this.fireItemsAdded(listChangeEvent.cloneWithSource((Object)this, "value"));
        this.engageItems(listChangeEvent.items());
    }

    protected void itemsRemoved(ListChangeEvent listChangeEvent) {
        this.disengageItems(listChangeEvent.items());
        this.fireItemsRemoved(listChangeEvent.cloneWithSource((Object)this, "value"));
    }

    protected void itemsReplaced(ListChangeEvent listChangeEvent) {
        this.disengageItems(listChangeEvent.replacedItems());
        this.fireItemsReplaced(listChangeEvent.cloneWithSource((Object)this, "value"));
        this.engageItems(listChangeEvent.items());
    }

    protected void listChanged(ListChangeEvent listChangeEvent) {
        ArrayList arrayList = new ArrayList(this.counters.keySet());
        this.disengageItems(arrayList.iterator());
        this.counters.clear();
        this.fireListChanged("value");
        this.engageAllItems();
    }

    protected void itemAspectChanged(EventObject eventObject) {
        Object object = eventObject.getSource();
        int n = this.lastIdentityIndexOf(object);
        while (n != -1) {
            this.itemAspectChanged(n, object);
            n = this.lastIdentityIndexOf(object, n);
        }
    }

    protected void itemAspectChanged(int n, Object object) {
        this.fireItemReplaced("value", n, object, object);
    }

    protected int lastIdentityIndexOf(Object object) {
        return this.lastIdentityIndexOf(object, this.listHolder.size());
    }

    protected int lastIdentityIndexOf(Object object, int n) {
        int n2 = n;
        while (n2-- > 0) {
            if (this.listHolder.getItem(n2) != object) continue;
            return n2;
        }
        return -1;
    }
}

