/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.uitools.app;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.persistence.tools.workbench.uitools.app.AspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.Model;
import org.eclipse.persistence.tools.workbench.utility.events.StateChangeEvent;
import org.eclipse.persistence.tools.workbench.utility.events.StateChangeListener;
import org.eclipse.persistence.tools.workbench.utility.iterators.ReadOnlyListIterator;

public abstract class ListCurator
extends AspectAdapter
implements ListValueModel {
    private List record;
    private StateChangeListener stateChangeListener;

    protected ListCurator(Model model) {
        super(model);
    }

    protected ListCurator(ValueModel valueModel) {
        super(valueModel);
    }

    protected void initialize() {
        super.initialize();
        this.record = new ArrayList();
        this.stateChangeListener = this.buildStateChangeListener();
    }

    protected StateChangeListener buildStateChangeListener() {
        return new StateChangeListener(){

            public void stateChanged(StateChangeEvent stateChangeEvent) {
                ListCurator.this.submitInventoryReport();
            }

            public String toString() {
                return "state change listener";
            }
        };
    }

    public Object getValue() {
        return new ReadOnlyListIterator(this.record);
    }

    public Object getItem(int n) {
        return this.record.get(n);
    }

    public int size() {
        return this.record.size();
    }

    public void addItem(int n, Object object) {
        throw new UnsupportedOperationException();
    }

    public void addItems(int n, List list) {
        for (int i = 0; i < list.size(); ++i) {
            this.addItem(n + i, list.get(i));
        }
    }

    public Object removeItem(int n) {
        throw new UnsupportedOperationException();
    }

    public List removeItems(int n, int n2) {
        ArrayList<Object> arrayList = new ArrayList<Object>(n2);
        for (int i = 0; i < n2; ++i) {
            arrayList.add(this.removeItem(n));
        }
        return arrayList;
    }

    public Object replaceItem(int n, Object object) {
        throw new UnsupportedOperationException();
    }

    public List replaceItems(int n, List list) {
        ArrayList<Object> arrayList = new ArrayList<Object>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            arrayList.add(this.replaceItem(n + i, list.get(i)));
        }
        return arrayList;
    }

    protected boolean hasListeners() {
        return this.hasAnyListChangeListeners("value");
    }

    protected void fireAspectChange(Object object, Object object2) {
        this.fireListChanged("value");
    }

    protected void engageNonNullSubject() {
        ((Model)this.subject).addStateChangeListener(this.stateChangeListener);
        CollectionTools.addAll((Collection)this.record, (Iterator)this.getValueForRecord());
    }

    protected void disengageNonNullSubject() {
        ((Model)this.subject).removeStateChangeListener(this.stateChangeListener);
        this.record.clear();
    }

    protected abstract Iterator getValueForRecord();

    void submitInventoryReport() {
        List list = CollectionTools.list((Iterator)this.getValueForRecord());
        int n = 0;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            this.inventoryNewItem(n, iterator.next());
            ++n;
        }
        n = 0;
        while (n < this.record.size()) {
            iterator = this.record.get(n);
            if (!list.contains(iterator)) {
                this.removeItemFromInventory(n, iterator);
                continue;
            }
            ++n;
        }
    }

    private void inventoryNewItem(int n, Object object) {
        ArrayList arrayList = new ArrayList(this.record);
        if (n < arrayList.size() && arrayList.get(n).equals(object)) {
            return;
        }
        if (!arrayList.contains(object)) {
            this.addItemToInventory(n, object);
        } else {
            this.removeItemFromInventory(n, arrayList.get(n));
            this.inventoryNewItem(n, object);
        }
    }

    private void addItemToInventory(int n, Object object) {
        this.record.add(n, object);
        this.fireItemAdded("value", n, object);
    }

    private void removeItemFromInventory(int n, Object object) {
        this.record.remove(object);
        this.fireItemRemoved("value", n, object);
    }
}

