/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.uitools.app.swing;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeListener;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

public class NumberSpinnerModelAdapter
extends SpinnerNumberModel {
    private Number defaultValue;
    protected PropertyValueModel numberHolder;
    private PropertyChangeListener numberChangeListener;

    public NumberSpinnerModelAdapter(PropertyValueModel propertyValueModel) {
        this(propertyValueModel, 0);
    }

    public NumberSpinnerModelAdapter(PropertyValueModel propertyValueModel, int n) {
        this(propertyValueModel, null, null, new Integer(1), new Integer(n));
    }

    public NumberSpinnerModelAdapter(PropertyValueModel propertyValueModel, int n, int n2, int n3) {
        this(propertyValueModel, n, n2, n3, n);
    }

    public NumberSpinnerModelAdapter(PropertyValueModel propertyValueModel, int n, int n2, int n3, int n4) {
        this(propertyValueModel, new Integer(n), new Integer(n2), new Integer(n3), new Integer(n4));
    }

    public NumberSpinnerModelAdapter(PropertyValueModel propertyValueModel, double d, double d2, double d3, double d4) {
        this(propertyValueModel, d, d2, d3, d4, d2);
    }

    public NumberSpinnerModelAdapter(PropertyValueModel propertyValueModel, double d, double d2, double d3, double d4, double d5) {
        this(propertyValueModel, new Double(d2), new Double(d3), new Double(d4), new Double(d5));
    }

    public NumberSpinnerModelAdapter(PropertyValueModel propertyValueModel, Comparable comparable, Comparable comparable2, Number number, Number number2) {
        super(propertyValueModel.getValue() == null ? (Number)number2 : (Number)((Number)propertyValueModel.getValue()), comparable, comparable2, number);
        this.numberHolder = propertyValueModel;
        this.numberChangeListener = this.buildNumberChangeListener();
        this.defaultValue = number2;
    }

    private PropertyChangeListener buildNumberChangeListener() {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                NumberSpinnerModelAdapter.this.synchronize(propertyChangeEvent.getNewValue());
            }

            public String toString() {
                return "number listener";
            }
        };
    }

    public Object getValue() {
        if (this.getChangeListeners().length == 0) {
            super.setValue(this.spinnerValueOf(this.numberHolder.getValue()));
        }
        return super.getValue();
    }

    protected final Number getSuperValue() {
        return super.getNumber();
    }

    public void setValue(Object object) {
        super.setValue(object);
        this.numberHolder.setValue(object);
    }

    public void addChangeListener(ChangeListener changeListener) {
        if (this.getChangeListeners().length == 0) {
            this.numberHolder.addPropertyChangeListener("value", this.numberChangeListener);
            this.synchronize(this.numberHolder.getValue());
        }
        super.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        super.removeChangeListener(changeListener);
        if (this.getChangeListeners().length == 0) {
            this.numberHolder.removePropertyChangeListener("value", this.numberChangeListener);
        }
    }

    protected Number getDefaultValue() {
        return this.defaultValue;
    }

    protected void setDefaultValue(Number number) {
        this.defaultValue = number;
    }

    protected Object spinnerValueOf(Object object) {
        return object == null ? this.getDefaultValue() : object;
    }

    protected void synchronize(Object object) {
        Object object2 = this.spinnerValueOf(object);
        if (!this.getValue().equals(object2)) {
            this.setValue(object2);
        }
    }

    public String toString() {
        return StringTools.buildToStringFor((Object)this, (Object)this.numberHolder);
    }
}

