/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.uitools.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.IllegalComponentStateException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Locale;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleIcon;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleStateSet;
import javax.swing.Icon;

public class ArrowIcon
implements Icon,
Accessible {
    private int width;
    private int height;
    private int orientation;
    private Dimension arrowDimension;
    private Color color;
    private boolean opaque;
    private AccessibleContext accessibleContext;
    private String description;

    public ArrowIcon(int n) {
        this();
        this.orientation = n;
    }

    public ArrowIcon() {
        this(10, 10);
    }

    public ArrowIcon(int n, int n2) {
        this(n, n2, 3);
    }

    public ArrowIcon(int n, int n2, int n3) {
        this(n, n2, n3, Color.black);
    }

    public ArrowIcon(int n, int n2, int n3, Color color) {
        this.width = n;
        this.height = n2;
        this.orientation = n3;
        this.color = color;
        this.opaque = color != null;
    }

    public int getIconWidth() {
        return this.width;
    }

    public void setIconWidth(int n) {
        if (n != this.width) {
            this.width = n;
            this.arrowDimension = null;
        }
    }

    public int getIconHeight() {
        return this.height;
    }

    public void setIconHeight(int n) {
        if (n != this.height) {
            this.height = n;
            this.arrowDimension = null;
        }
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int n) {
        if (n != this.orientation) {
            this.orientation = n;
            this.arrowDimension = null;
        }
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public boolean isOpaque() {
        return this.opaque;
    }

    public void setOpaque(boolean bl) {
        this.opaque = bl;
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleArrowIcon();
        }
        return this.accessibleContext;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        Color color = graphics.getColor();
        if (n2 < 0) {
            n2 = 0;
        }
        Dimension dimension = this.getArrowDimension();
        int n3 = (this.width - dimension.width) / 2;
        int n4 = (this.height - dimension.height) / 2;
        graphics.translate(n + n3, n2 + n4);
        if (this.opaque) {
            if (component.isEnabled()) {
                graphics.setColor(this.color != null ? this.color : component.getBackground().darker());
            } else {
                Color color2 = component.getBackground();
                graphics.translate(1, 1);
                graphics.setColor(color2.brighter());
                this.paintOpaqueTriangle(graphics, dimension.width, dimension.height);
                graphics.translate(-1, -1);
                graphics.setColor(color2.darker());
            }
            this.paintOpaqueTriangle(graphics, dimension.width, dimension.height);
        } else {
            this.paintTransparentTriangle(graphics, dimension.width, dimension.height, component.getBackground());
        }
        graphics.translate(-n - n3, -n2 - n4);
        graphics.setColor(color);
    }

    private Dimension getArrowDimension() {
        if (this.arrowDimension == null) {
            this.arrowDimension = this.buildArrowDimension();
        }
        return this.arrowDimension;
    }

    private Dimension buildArrowDimension() {
        int n = 0;
        int n2 = 0;
        int n3 = this.width;
        int n4 = this.height;
        int n5 = this.orientation;
        if (n3 == n4) {
            if (n5 == 3 || n5 == 7) {
                n2 = n4;
                if (n2 % 2 == 0) {
                    --n2;
                }
                n = (n2 + 1) / 2;
            } else {
                n = n3;
                if (n % 2 == 0) {
                    --n;
                }
                n2 = (n + 1) / 2;
            }
        } else if (n3 < n4) {
            n = n3;
            if (n5 == 1 || n5 == 5) {
                if (n % 2 == 0) {
                    --n;
                }
                n2 = (n + 1) / 2;
            } else {
                n2 = n * 2 - 1;
            }
        } else {
            n2 = n4;
            if (n5 == 3 || n5 == 7) {
                if (n2 % 2 == 0) {
                    --n2;
                }
                n = (n2 + 1) / 2;
            } else {
                n = n2 * 2 - 1;
            }
        }
        return new Dimension(n, n2);
    }

    private void paintTransparentTriangle(Graphics graphics, int n, int n2, Color color) {
        Color color2 = color.brighter();
        Color color3 = color.darker();
        int n3 = this.orientation;
        --n;
        --n2;
        if (n3 == 3) {
            graphics.setColor(color2);
            graphics.drawLine(0, n2, n, n2 / 2);
            graphics.setColor(color3);
            graphics.drawLine(0, 0, n, n2 / 2);
            graphics.drawLine(0, 0, 0, n2);
        } else if (n3 == 7) {
            graphics.setColor(color2);
            graphics.drawLine(0, n2 / 2, n, n2);
            graphics.drawLine(n, 0, n, n2);
            graphics.setColor(color3);
            graphics.drawLine(n, 0, 0, n2 / 2);
        } else if (n3 == 1) {
            graphics.setColor(color3);
            graphics.drawLine(0, n2, n / 2, 0);
            graphics.drawLine(0, n2, n, n2);
            graphics.setColor(color2);
            graphics.drawLine(n / 2, 0, n, n2);
        } else if (n3 == 5) {
            graphics.setColor(color2);
            graphics.drawLine(n / 2, n2, n, 0);
            graphics.setColor(color3);
            graphics.drawLine(0, 0, n, 0);
            graphics.drawLine(0, 0, n / 2, n2);
        }
    }

    private void paintOpaqueTriangle(Graphics graphics, int n, int n2) {
        block5: {
            int n3;
            block7: {
                block6: {
                    block4: {
                        n3 = this.orientation;
                        if (n3 != 3) break block4;
                        int n4 = n2 - 1;
                        for (int i = 0; i < n; ++i) {
                            graphics.drawLine(i, i, i, n4 - i);
                        }
                        break block5;
                    }
                    if (n3 != 7) break block6;
                    int n5 = n - 1;
                    --n2;
                    int n6 = n;
                    while (n6-- > 0) {
                        int n7 = n5 - n6;
                        graphics.drawLine(n6, n7, n6, n2 - n7);
                    }
                    break block5;
                }
                if (n3 != 1) break block7;
                int n8 = n2 - 1;
                --n;
                int n9 = n2;
                while (n9-- > 0) {
                    int n10 = n8 - n9;
                    graphics.drawLine(n10, n9, n - n10, n9);
                }
                break block5;
            }
            if (n3 != 5) break block5;
            int n11 = n - 1;
            for (int i = 0; i < n2; ++i) {
                graphics.drawLine(i, i, n11 - i, i);
            }
        }
    }

    private class AccessibleArrowIcon
    extends AccessibleContext
    implements AccessibleIcon,
    Serializable {
        private AccessibleArrowIcon() {
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.ICON;
        }

        public AccessibleStateSet getAccessibleStateSet() {
            return null;
        }

        public Accessible getAccessibleParent() {
            return null;
        }

        public int getAccessibleIndexInParent() {
            return -1;
        }

        public int getAccessibleChildrenCount() {
            return 0;
        }

        public Accessible getAccessibleChild(int n) {
            return null;
        }

        public Locale getLocale() throws IllegalComponentStateException {
            return null;
        }

        public String getAccessibleIconDescription() {
            return ArrowIcon.this.getDescription();
        }

        public void setAccessibleIconDescription(String string) {
            ArrowIcon.this.setDescription(string);
        }

        public int getAccessibleIconHeight() {
            return ArrowIcon.this.getIconHeight();
        }

        public int getAccessibleIconWidth() {
            return ArrowIcon.this.getIconWidth();
        }

        private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
            objectInputStream.defaultReadObject();
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            objectOutputStream.defaultWriteObject();
        }
    }
}

